/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.TextBatchProcessor;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JCUtilities;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaDeclarationProcessor;
import org.netbeans.editor.ext.java.JavaImport;
import org.netbeans.editor.ext.java.JavaTokenContext;

public abstract class JavaSyntaxSupport
extends ExtSyntaxSupport {
    static final int INIT = 0;
    static final int AFTER_TYPE = 1;
    static final int AFTER_VARIABLE = 2;
    static final int AFTER_COMMA = 3;
    static final int AFTER_DOT = 4;
    static final int AFTER_TYPE_LSB = 5;
    static final int AFTER_MATCHING_VARIABLE_LSB = 6;
    static final int AFTER_MATCHING_VARIABLE = 7;
    static final int AFTER_EQUAL = 8;
    private static final TokenID[] COMMENT_TOKENS = new TokenID[]{JavaTokenContext.LINE_COMMENT, JavaTokenContext.BLOCK_COMMENT};
    private static final TokenID[] BRACKET_SKIP_TOKENS = new TokenID[]{JavaTokenContext.LINE_COMMENT, JavaTokenContext.BLOCK_COMMENT, JavaTokenContext.CHAR_LITERAL, JavaTokenContext.STRING_LITERAL};
    private static final char[] COMMAND_SEPARATOR_CHARS = new char[]{';', '{', '}'};
    private JavaImport javaImport;
    private boolean java15;

    public JavaSyntaxSupport(BaseDocument doc) {
        super(doc);
        this.tokenNumericIDsValid = true;
    }

    protected abstract JCFinder getFinder();

    protected JavaImport createJavaImport() {
        return new JavaImport(this);
    }

    protected void documentModified(DocumentEvent evt) {
        super.documentModified(evt);
        if (this.javaImport != null) {
            this.javaImport.documentModifiedAtPosition(evt.getOffset(), this.getDocument());
        }
    }

    protected void setJava15(boolean java15) {
        this.java15 = java15;
    }

    public TokenID[] getCommentTokens() {
        return COMMENT_TOKENS;
    }

    public TokenID[] getBracketSkipTokens() {
        return BRACKET_SKIP_TOKENS;
    }

    public int getLastCommandSeparator(int pos) throws BadLocationException {
        if (pos == 0) {
            return 0;
        }
        TextBatchProcessor tbp = new TextBatchProcessor(){

            public int processTextBatch(BaseDocument doc, int startPos, int endPos, boolean lastBatch) {
                try {
                    int prev;
                    int[] matchingBrkPos;
                    int[] blks = JavaSyntaxSupport.this.getCommentBlocks(endPos, startPos);
                    FinderFactory.CharArrayBwdFinder cmdFinder = new FinderFactory.CharArrayBwdFinder(COMMAND_SEPARATOR_CHARS);
                    int lastSeparatorOffset = JavaSyntaxSupport.this.findOutsideBlocks((Finder)cmdFinder, startPos, endPos, blks);
                    if (lastSeparatorOffset < 1) {
                        return lastSeparatorOffset;
                    }
                    TokenID separatorID = JavaSyntaxSupport.this.getTokenID(lastSeparatorOffset);
                    if (separatorID.getNumericID() == 58 && (matchingBrkPos = JavaSyntaxSupport.this.findMatchingBlock(lastSeparatorOffset, true)) != null && (prev = Utilities.getFirstNonWhiteBwd((BaseDocument)JavaSyntaxSupport.this.getDocument(), (int)matchingBrkPos[0])) > -1 && JavaSyntaxSupport.this.getTokenID(prev).getNumericID() == 56) {
                        return JavaSyntaxSupport.this.getLastCommandSeparator(prev);
                    }
                    if (separatorID.getNumericID() != 57 && separatorID.getNumericID() != 58 && separatorID.getNumericID() != 51) {
                        lastSeparatorOffset = this.processTextBatch(doc, lastSeparatorOffset, 0, lastBatch);
                    }
                    return lastSeparatorOffset;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
        };
        int lastPos = this.getDocument().processText(tbp, pos, 0);
        TokenItem item = this.getTokenChain(pos - 1, pos);
        do {
            int tokenOffset = item.getOffset();
            if (lastPos != -1 && tokenOffset < lastPos) break;
            if (item.getTokenContextPath().contains(JavaTokenContext.contextPath)) continue;
            lastPos = item.getNext() != null ? item.getNext().getOffset() : item.getOffset() + item.getImage().length();
            break;
        } while ((item = item.getPrevious()) != null);
        return lastPos;
    }

    public JCClass getClassFromName(String className, boolean searchByName) {
        this.refreshJavaImport();
        JCClass ret = JavaCompletion.getPrimitiveClass(className);
        if (ret == null) {
            ret = this.getJavaImport().getClazz(className);
        }
        if (ret == null && searchByName) {
            if (this.isUnknownImport(className)) {
                return null;
            }
            List clsList = this.getFinder().findClasses(null, className, true);
            if (clsList != null && clsList.size() > 0 && clsList.size() > 0) {
                ret = (JCClass)clsList.get(0);
            }
        }
        return ret;
    }

    public synchronized JavaImport getJavaImport() {
        if (this.javaImport == null) {
            this.javaImport = this.createJavaImport();
        }
        this.javaImport.update(this.getDocument());
        return this.javaImport;
    }

    protected boolean isUnknownImport(String className) {
        return this.getJavaImport().isUnknownImport(className);
    }

    protected List getUnknownImports() {
        return this.getJavaImport().getUnknownImports();
    }

    public boolean isImported(JCClass cls) {
        return this.getJavaImport().isImported(cls);
    }

    public void refreshJavaImport() {
        if (this.javaImport != null) {
            this.javaImport.update(this.getDocument());
        }
    }

    protected void refreshClassInfo() {
    }

    protected List getImportedInnerClasses() {
        this.refreshJavaImport();
        return this.getJavaImport().getInnerClasses();
    }

    public JCClass getClass(int pos) {
        return null;
    }

    public boolean isStaticBlock(int pos) {
        return false;
    }

    public boolean isAnnotation(int pos) {
        try {
            BaseDocument document = this.getDocument();
            int off = Utilities.getFirstNonWhiteBwd((BaseDocument)document, (int)pos);
            int ch = 42;
            while (off > -1 && (ch = document.getChars(off, 1)[0]) == 46) {
                if ((off = Utilities.getFirstNonWhiteBwd((BaseDocument)document, (int)off)) > -1) {
                    off = Utilities.getPreviousWord((BaseDocument)document, (int)off);
                }
                if (off <= -1) continue;
                off = Utilities.getFirstNonWhiteBwd((BaseDocument)document, (int)off);
            }
            if (off > -1 && ch == 64) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    public int[] getFunctionBlock(int[] identifierBlock) throws BadLocationException {
        int[] retValue = super.getFunctionBlock(identifierBlock);
        if (!this.isAnnotation(identifierBlock[0])) {
            return retValue;
        }
        return null;
    }

    protected ExtSyntaxSupport.DeclarationTokenProcessor createDeclarationTokenProcessor(String varName, int startPos, int endPos) {
        return this.java15 ? new JavaDeclarationProcessor(this, varName) : new JavaDeclarationTokenProcessor(this, varName);
    }

    protected ExtSyntaxSupport.VariableMapTokenProcessor createVariableMapTokenProcessor(int startPos, int endPos) {
        return this.java15 ? new JavaDeclarationProcessor(this, null) : new JavaDeclarationTokenProcessor(this, null);
    }

    private boolean insideMethod(JTextComponent textComp, int startPos) {
        try {
            int level = 0;
            BaseDocument doc = (BaseDocument)textComp.getDocument();
            for (int i = startPos - 1; i > 0; --i) {
                char ch = doc.getChars(i, 1)[0];
                if (ch == ';') {
                    return false;
                }
                if (ch == ')') {
                    ++level;
                }
                if (ch != '(') continue;
                if (level == 0) {
                    return true;
                }
                --level;
            }
            return false;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public int checkCompletion(JTextComponent target, String typedText, boolean visible) {
        if (!visible) {
            int dotPos = target.getCaret().getDot();
            switch (typedText.charAt(0)) {
                case ' ': {
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    if (dotPos < 2) break;
                    int pos = Math.max(dotPos - 8, 0);
                    try {
                        String txtBeforeSpace = doc.getText(pos, dotPos - pos);
                        if (txtBeforeSpace.endsWith("import ") && !Character.isJavaIdentifierPart(txtBeforeSpace.charAt(0))) {
                            return 0;
                        }
                        if (txtBeforeSpace.endsWith(", ") && this.insideMethod(target, dotPos)) {
                            return 0;
                        }
                    }
                    catch (BadLocationException e) {}
                    break;
                }
                case '.': {
                    return 0;
                }
                case ',': {
                    if (this.insideMethod(target, dotPos)) {
                        return 0;
                    }
                }
                default: {
                    if (!Character.isJavaIdentifierStart(typedText.charAt(0)) || dotPos < 5) break;
                    try {
                        String maybeNew = target.getDocument().getText(dotPos - 5, 4);
                        if (maybeNew.equals("new ")) {
                            return 0;
                        }
                        break;
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                }
            }
            return 1;
        }
        switch (typedText.charAt(0)) {
            case ';': 
            case '=': 
            case '{': {
                return 4;
            }
        }
        return 3;
    }

    public boolean isAssignable(JCType from, JCType to) {
        JCClass fromCls = from.getClazz();
        JCClass toCls = to.getClazz();
        if (fromCls.equals(JavaCompletion.NULL_CLASS)) {
            return to.getArrayDepth() > 0 || !JavaCompletion.isPrimitiveClass(toCls);
        }
        if (toCls.equals(JavaCompletion.OBJECT_CLASS)) {
            return from.getArrayDepth() > to.getArrayDepth() || from.getArrayDepth() == to.getArrayDepth() && !JavaCompletion.isPrimitiveClass(fromCls);
        }
        if (from.getArrayDepth() != to.getArrayDepth()) {
            return false;
        }
        if (fromCls.equals(toCls)) {
            return true;
        }
        if (fromCls.isInterface()) {
            return toCls.isInterface() && JCUtilities.getAllInterfaces(this.getFinder(), fromCls).indexOf(toCls) >= 0;
        }
        TokenID fromClsKwd = JavaTokenContext.getKeyword(fromCls.getName());
        if (fromClsKwd != null) {
            TokenID toClsKwd = JavaTokenContext.getKeyword(toCls.getName());
            return toClsKwd != null && JCUtilities.getPrimitivesAssignable(fromClsKwd.getNumericID(), toClsKwd.getNumericID());
        }
        if (toCls.isInterface()) {
            return JCUtilities.getAllInterfaces(this.getFinder(), fromCls).indexOf(toCls) >= 0;
        }
        return JCUtilities.getSuperclasses(this.getFinder(), fromCls).indexOf(toCls) >= 0;
    }

    public JCType getCommonType(JCType typ1, JCType typ2) {
        if (typ1.equals(typ2)) {
            return typ1;
        }
        TokenID cls1Kwd = JavaTokenContext.getKeyword(typ1.getClazz().getName());
        TokenID cls2Kwd = JavaTokenContext.getKeyword(typ2.getClazz().getName());
        if (cls1Kwd == null && cls2Kwd == null) {
            if (this.isAssignable(typ1, typ2)) {
                return typ1;
            }
            if (this.isAssignable(typ2, typ1)) {
                return typ2;
            }
            return null;
        }
        if (typ1.getArrayDepth() != typ2.getArrayDepth()) {
            return null;
        }
        if (cls1Kwd != null && cls2Kwd != null) {
            return JavaCompletion.getType(JCUtilities.getPrimitivesCommonClass(cls1Kwd.getNumericID(), cls2Kwd.getNumericID()), typ1.getArrayDepth());
        }
        return null;
    }

    public List filterMethods(List methodList, List parmTypeList, boolean acceptMoreParameters) {
        if (parmTypeList == null) {
            return methodList;
        }
        ArrayList<JCConstructor> ret = new ArrayList<JCConstructor>();
        int parmTypeCnt = parmTypeList.size();
        int cnt = methodList.size();
        for (int i = 0; i < cnt; ++i) {
            JCConstructor m = (JCConstructor)methodList.get(i);
            JCParameter[] methodParms = m.getParameters();
            if (methodParms.length != parmTypeCnt && (!acceptMoreParameters || methodParms.length < parmTypeCnt)) continue;
            boolean accept = true;
            boolean bestMatch = !acceptMoreParameters;
            for (int j = 0; accept && j < parmTypeCnt; ++j) {
                JCType mpt = methodParms[j].getType();
                JCType t = (JCType)parmTypeList.get(j);
                if (t != null) {
                    if (t.equals(mpt)) continue;
                    bestMatch = false;
                    if (this.isAssignable(t, mpt)) continue;
                    accept = false;
                    break;
                }
                bestMatch = false;
            }
            if (!accept) continue;
            if (bestMatch) {
                ret.clear();
            }
            ret.add(m);
            if (bestMatch) break;
        }
        return ret;
    }

    protected boolean isAbbrevDisabled(int offset) {
        boolean abbrevDisabled = false;
        TokenID[] disableTokenIds = BRACKET_SKIP_TOKENS;
        if (disableTokenIds != null) {
            TokenItem token;
            try {
                token = this.getTokenChain(offset, offset + 1);
            }
            catch (BadLocationException e) {
                token = null;
            }
            if (token != null) {
                TokenItem prevToken;
                if (offset > token.getOffset()) {
                    for (int i = disableTokenIds.length - 1; i >= 0; --i) {
                        if (token.getTokenID() != disableTokenIds[i]) continue;
                        abbrevDisabled = true;
                        break;
                    }
                }
                if (!abbrevDisabled && token.getOffset() == offset && (prevToken = token.getPrevious()) != null && prevToken.getTokenID() == JavaTokenContext.LINE_COMMENT) {
                    abbrevDisabled = true;
                }
            }
        }
        return abbrevDisabled;
    }

    public boolean isCompletionDisabled(int offset) {
        boolean completionDisabled = false;
        TokenID[] disableTokenIds = BRACKET_SKIP_TOKENS;
        if (disableTokenIds != null) {
            TokenItem token;
            try {
                token = this.getTokenChain(offset, offset + 1);
            }
            catch (BadLocationException e) {
                token = null;
            }
            if (token != null) {
                TokenItem prevToken;
                if (offset > token.getOffset()) {
                    for (int i = disableTokenIds.length - 1; i >= 0; --i) {
                        if (token.getTokenID() != disableTokenIds[i]) continue;
                        completionDisabled = true;
                        break;
                    }
                }
                if (!(completionDisabled || token.getOffset() != offset || (prevToken = token.getPrevious()) == null || prevToken.getTokenID() != JavaTokenContext.LINE_COMMENT && prevToken.getTokenID() != JavaTokenContext.FLOAT_LITERAL && prevToken.getTokenID() != JavaTokenContext.DOUBLE_LITERAL)) {
                    completionDisabled = true;
                }
            }
        }
        return completionDisabled;
    }

    public static class JavaDeclarationTokenProcessor
    implements ExtSyntaxSupport.DeclarationTokenProcessor,
    ExtSyntaxSupport.VariableMapTokenProcessor {
        protected JavaSyntaxSupport sup;
        protected int decStartPos = -1;
        protected int decArrayDepth;
        protected int typeStartPos;
        protected int typeEndPos;
        protected int decVarNameOffset;
        protected int decVarNameLen;
        protected int parenthesisCounter;
        protected int arrayDepth;
        protected char[] buffer;
        protected int bufferStartPos;
        protected String varName;
        protected int state;
        protected HashMap varMap;

        public JavaDeclarationTokenProcessor(JavaSyntaxSupport sup, String varName) {
            this.sup = sup;
            this.varName = varName;
            if (varName == null) {
                this.varMap = new HashMap();
            }
        }

        public int getDeclarationPosition() {
            return this.decStartPos;
        }

        public Map getVariableMap() {
            return this.varMap;
        }

        protected void processDeclaration() {
            if (this.varName == null) {
                JCClass cls;
                String decType = new String(this.buffer, this.typeStartPos - this.bufferStartPos, this.typeEndPos - this.typeStartPos);
                if (decType.indexOf(32) >= 0) {
                    decType = Analyzer.removeSpaces((String)decType);
                }
                String decVarName = new String(this.buffer, this.decVarNameOffset, this.decVarNameLen);
                JCClass innerClass = null;
                JCClass outerCls = this.sup.getClass(this.decVarNameOffset);
                if (outerCls != null) {
                    String outerClassName = outerCls.getFullName();
                    innerClass = this.sup.getFinder().getExactClass(outerClassName + "." + decType);
                    if (innerClass != null) {
                        this.varMap.put(decVarName, JavaCompletion.getType(innerClass, this.decArrayDepth));
                    }
                }
                if (innerClass == null && (cls = this.sup.getClassFromName(decType, true)) != null) {
                    this.varMap.put(decVarName, JavaCompletion.getType(cls, this.decArrayDepth));
                }
            } else {
                this.decStartPos = this.typeStartPos;
            }
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int tokenOffset, int tokenLen) {
            int pos = this.bufferStartPos + tokenOffset;
            if (!tokenContextPath.contains(JavaTokenContext.contextPath)) {
                this.state = 0;
                return true;
            }
            block0 : switch (tokenID.getNumericID()) {
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: {
                    this.typeStartPos = pos;
                    this.arrayDepth = 0;
                    this.typeEndPos = pos + tokenLen;
                    this.state = 1;
                    break;
                }
                case 48: {
                    switch (this.state) {
                        case 1: {
                            this.state = 4;
                            this.typeEndPos = pos + tokenLen;
                            break block0;
                        }
                        case 2: 
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 124: {
                    switch (this.state) {
                        case 1: {
                            ++this.arrayDepth;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 55: {
                    switch (this.state) {
                        case 1: {
                            this.state = 5;
                            ++this.arrayDepth;
                            break block0;
                        }
                        case 7: {
                            this.state = 6;
                            ++this.decArrayDepth;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 56: {
                    switch (this.state) {
                        case 5: {
                            this.state = 1;
                            break block0;
                        }
                        case 6: {
                            this.state = 7;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 53: {
                    ++this.parenthesisCounter;
                    if (this.state == 8) break;
                    this.state = 0;
                    break;
                }
                case 54: {
                    if (this.state == 7) {
                        this.processDeclaration();
                    }
                    if (this.parenthesisCounter > 0) {
                        --this.parenthesisCounter;
                    }
                    if (this.state == 8) break;
                    this.state = 0;
                    break;
                }
                case 57: 
                case 58: {
                    if (this.parenthesisCounter > 0) {
                        --this.parenthesisCounter;
                    }
                    this.state = 0;
                    break;
                }
                case 49: {
                    if (this.parenthesisCounter > 0) {
                        if (this.parenthesisCounter == 1 && this.state == 7) {
                            this.processDeclaration();
                        }
                        if (this.state == 8) break;
                        this.state = 0;
                        break;
                    }
                    switch (this.state) {
                        case 7: {
                            this.processDeclaration();
                        }
                        case 2: 
                        case 8: {
                            this.state = 3;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 96: {
                    if (this.state == 8) break;
                    this.state = 0;
                    break;
                }
                case 17: {
                    switch (this.state) {
                        case 7: {
                            this.processDeclaration();
                        }
                        case 2: {
                            this.state = 8;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 51: {
                    if (this.state == 7) {
                        this.processDeclaration();
                    }
                    this.state = 0;
                    break;
                }
                case 6: {
                    switch (this.state) {
                        case 1: 
                        case 3: {
                            if (this.varName == null || Analyzer.equals((String)this.varName, (char[])this.buffer, (int)tokenOffset, (int)tokenLen)) {
                                this.decArrayDepth = this.arrayDepth;
                                this.decVarNameOffset = tokenOffset;
                                this.decVarNameLen = tokenLen;
                                this.state = 7;
                                break block0;
                            }
                            this.state = 2;
                            break block0;
                        }
                        case 2: {
                            this.state = 0;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                        case 4: {
                            this.typeEndPos = pos + tokenLen;
                            this.state = 1;
                            break block0;
                        }
                        case 0: {
                            this.typeStartPos = pos;
                            this.arrayDepth = 0;
                            this.typeEndPos = pos + tokenLen;
                            this.state = 1;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 5: {
                    break;
                }
                case 50: {
                    this.processDeclaration();
                }
                default: {
                    this.state = 0;
                }
            }
            return true;
        }

        public int eot(int offset) {
            return 0;
        }

        public void nextBuffer(char[] buffer, int offset, int len, int startPos, int preScan, boolean lastBuffer) {
            this.buffer = buffer;
            this.bufferStartPos = startPos - offset;
        }
    }

    public static interface OffsetJavaVariable
    extends JavaVariable {
        public int getOffset();
    }

    public static interface JavaVariable {
        public JCExpression getTypeExpression();

        public JCExpression getVariableExpression();
    }
}

