/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.Transport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConnectPanel
extends JPanel
implements Controller,
ActionListener {
    private List connectors;
    private JComboBox cbConnectors;
    private JTextField[] tfParams;
    static /* synthetic */ Class class$org$netbeans$api$debugger$jpda$JPDADebugger;

    public ConnectPanel() {
        VirtualMachineManager vmm = Bootstrap.virtualMachineManager();
        this.connectors = new ArrayList();
        this.connectors.addAll(vmm.attachingConnectors());
        this.connectors.addAll(vmm.listeningConnectors());
        Iterator ci = this.connectors.iterator();
        while (ci.hasNext()) {
            String name = ((Connector)ci.next()).name();
            int index = name.lastIndexOf(46);
            if (index >= 0) {
                name = name.substring(index + 1);
            }
            if (!name.equalsIgnoreCase("SACoreAttachingConnector") && !name.equalsIgnoreCase("SAPIDAttachingConnector") && !name.equalsIgnoreCase("SADebugServerAttachingConnector")) continue;
            ci.remove();
        }
        if (this.connectors.size() == 0) {
            this.add(new JLabel(NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_No_Connector")));
            return;
        }
        int defaultIndex = 0;
        if (this.connectors.size() > 1) {
            this.cbConnectors = new JComboBox();
            this.cbConnectors.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ConnectPanel.class, (String)"ACSD_CTL_Connector"));
            String lacn = Properties.getDefault().getProperties("debugger").getString("last_attaching_connector", "");
            int k = this.connectors.size();
            for (int i = 0; i < k; ++i) {
                int jj;
                Connector connector = (Connector)this.connectors.get(i);
                if (lacn != null && connector.name().equals(lacn)) {
                    defaultIndex = i;
                }
                String s = (jj = connector.name().lastIndexOf(46)) < 0 ? connector.name() : connector.name().substring(jj + 1);
                this.cbConnectors.addItem(s + " (" + connector.description() + ")");
            }
            this.cbConnectors.setActionCommand("SwitchMe!");
            this.cbConnectors.addActionListener(this);
        }
        this.cbConnectors.setSelectedIndex(defaultIndex);
    }

    private void refresh(int index) {
        GridBagConstraints c;
        this.removeAll();
        Connector connector = (Connector)this.connectors.get(index);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        if (this.cbConnectors != null) {
            c = new GridBagConstraints();
            c.insets = new Insets(0, 0, 3, 3);
            c.anchor = 17;
            JLabel lblConnectors = new JLabel(NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_Connector"));
            lblConnectors.setDisplayedMnemonic(NbBundle.getMessage((Class)ConnectPanel.class, (String)"MN_CTL_Connector").charAt(0));
            lblConnectors.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ConnectPanel.class, (String)"ACSD_CTL_Connector"));
            lblConnectors.setLabelFor(this.cbConnectors);
            layout.setConstraints(lblConnectors, c);
            this.add(lblConnectors);
            c.insets = new Insets(0, 3, 3, 0);
            c.weightx = 1.0;
            c.fill = 2;
            c.gridwidth = 0;
            layout.setConstraints(this.cbConnectors, c);
            this.add(this.cbConnectors);
        }
        c = new GridBagConstraints();
        c.insets = new Insets(3, 0, 0, 6);
        c.anchor = 17;
        JLabel lblTransport = new JLabel(NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_Transport"));
        lblTransport.setDisplayedMnemonic(NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_Transport_Mnemonic").charAt(0));
        lblTransport.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ConnectPanel.class, (String)"ACSD_CTL_Transport"));
        layout.setConstraints(lblTransport, c);
        this.add(lblTransport);
        final JTextField tfTransport = new JTextField();
        tfTransport.setEditable(false);
        lblTransport.setLabelFor(tfTransport);
        c.gridwidth = 0;
        c.insets = new Insets(3, 3, 0, 0);
        c.fill = 2;
        c.weightx = 1.0;
        layout.setConstraints(tfTransport, c);
        Transport t = connector.transport();
        tfTransport.setText(t != null ? t.name() : "");
        tfTransport.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ConnectPanel.class, (String)"ACSD_CTL_Transport"));
        tfTransport.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                tfTransport.selectAll();
            }
        });
        this.add(tfTransport);
        Map args = ConnectPanel.getSavedArgs(connector);
        this.tfParams = new JTextField[args.size()];
        Iterator it = new TreeSet(args.keySet()).iterator();
        int i = 0;
        while (it.hasNext()) {
            String name = (String)it.next();
            Connector.Argument a = (Connector.Argument)args.get(name);
            String label = ConnectPanel.translate(a.label());
            char mnemonic = ConnectPanel.getMnemonic(a.label());
            c = new GridBagConstraints();
            c.insets = new Insets(6, 0, 0, 3);
            c.anchor = 17;
            JLabel iLabel = new JLabel(label);
            iLabel.setDisplayedMnemonic(mnemonic);
            iLabel.setToolTipText(a.description());
            this.add((Component)iLabel, c);
            JTextField tfParam = new JTextField(a.value());
            iLabel.setLabelFor(tfParam);
            tfParam.setName(name);
            tfParam.getAccessibleContext().setAccessibleDescription(new MessageFormat(NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$jpda$ui$ConnectPanel == null ? ConnectPanel.class$("org.netbeans.modules.debugger.jpda.ui.ConnectPanel") : class$org$netbeans$modules$debugger$jpda$ui$ConnectPanel), (String)"ACSD_CTL_Argument")).format(new Object[]{ConnectPanel.translate(a.label())}));
            tfParam.setToolTipText(a.description());
            c = new GridBagConstraints();
            c.gridwidth = 0;
            c.insets = new Insets(6, 3, 0, 0);
            c.fill = 2;
            c.weightx = 1.0;
            this.add((Component)tfParam, c);
            this.tfParams[i++] = tfParam;
        }
        c = new GridBagConstraints();
        c.weighty = 1.0;
        JPanel p = new JPanel();
        p.setPreferredSize(new Dimension(1, 1));
        this.add((Component)p, c);
    }

    public void actionPerformed(ActionEvent e) {
        Container w;
        this.refresh(((JComboBox)e.getSource()).getSelectedIndex());
        for (w = this.getParent(); w != null && !(w instanceof Window); w = w.getParent()) {
        }
        if (w != null) {
            ((Window)w).pack();
        }
    }

    public boolean cancel() {
        return true;
    }

    public boolean ok() {
        int index = this.cbConnectors.getSelectedIndex();
        final Connector connector = (Connector)this.connectors.get(index);
        final Map args = ConnectPanel.getEditedArgs(this.tfParams, connector);
        if (args == null) {
            return true;
        }
        ConnectPanel.saveArgs(args, connector);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProgressHandle progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$jpda$ui$ConnectPanel == null ? (class$org$netbeans$modules$debugger$jpda$ui$ConnectPanel = ConnectPanel.class$("org.netbeans.modules.debugger.jpda.ui.ConnectPanel")) : class$org$netbeans$modules$debugger$jpda$ui$ConnectPanel), (String)"CTL_connectProgress"));
                try {
                    progress.start();
                    DebuggerEngine[] es = null;
                    if (connector instanceof AttachingConnector) {
                        es = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-AttachingDICookie", (Object[])new Object[]{AttachingDICookie.create((AttachingConnector)((AttachingConnector)connector), (Map)args)}));
                    } else if (connector instanceof ListeningConnector) {
                        es = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-ListeningDICookie", (Object[])new Object[]{ListeningDICookie.create((ListeningConnector)((ListeningConnector)connector), (Map)args)}));
                    }
                    if (es != null) {
                        for (int i = 0; i < es.length; ++i) {
                            JPDADebugger d = (JPDADebugger)es[i].lookupFirst(null, class$org$netbeans$api$debugger$jpda$JPDADebugger == null ? ConnectPanel.class$("org.netbeans.api.debugger.jpda.JPDADebugger") : class$org$netbeans$api$debugger$jpda$JPDADebugger);
                            if (d == null) continue;
                            try {
                                if (d.getState() == 2) continue;
                                d.waitRunning();
                                continue;
                            }
                            catch (DebuggerStartException dsex) {
                                // empty catch block
                            }
                        }
                    }
                }
                finally {
                    progress.finish();
                }
            }
        });
        return true;
    }

    private static boolean isUnknownHost(String hostname) {
        if (hostname == null) {
            return true;
        }
        int length = hostname.length();
        if (length == 0) {
            return true;
        }
        if (length < 6) {
            return false;
        }
        char firstChar = hostname.charAt(0);
        if ('a' <= firstChar && firstChar <= 'z' || 'A' <= firstChar && firstChar <= 'Z' || firstChar == '-') {
            return false;
        }
        char c = hostname.charAt(5);
        if (c == firstChar) {
            return hostname.substring(1, 5).equalsIgnoreCase("none");
        }
        if (length < 9) {
            return false;
        }
        c = hostname.charAt(8);
        if (c == firstChar) {
            return hostname.substring(1, 8).equalsIgnoreCase("unknown");
        }
        return false;
    }

    private static Map getSavedArgs(Connector connector) {
        Map<String, Connector.Argument> args = connector.defaultArguments();
        Map savedArgs = Properties.getDefault().getProperties("debugger").getMap("connection_settings", new HashMap());
        if ((savedArgs = (Map)savedArgs.get(connector.name())) == null) {
            return args;
        }
        Iterator<String> i = args.keySet().iterator();
        while (i.hasNext()) {
            String argName = i.next();
            String savedValue = (String)savedArgs.get(argName);
            if (savedValue == null) continue;
            args.get(argName).setValue(savedValue);
        }
        return args;
    }

    private static Map getEditedArgs(JTextField[] tfParams, Connector connector) {
        Map<String, Connector.Argument> args = connector.defaultArguments();
        int k = tfParams.length;
        for (int i = 0; i < k; ++i) {
            JTextField tf = tfParams[i];
            String paramName = tf.getName();
            String paramValue = tf.getText();
            Connector.Argument a = args.get(paramName);
            while (!a.isValid(paramValue) && !paramValue.equals("") || paramValue.equals("") && a.mustSpecify()) {
                NotifyDescriptor.InputLine in = null;
                in = paramValue.equals("") && a.mustSpecify() ? new NotifyDescriptor.InputLine(ConnectPanel.translate(a.label()), NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$jpda$ui$ConnectPanel == null ? ConnectPanel.class$("org.netbeans.modules.debugger.jpda.ui.ConnectPanel") : class$org$netbeans$modules$debugger$jpda$ui$ConnectPanel), (String)"CTL_Required_value_title")) : new NotifyDescriptor.InputLine(ConnectPanel.translate(a.label()), NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$jpda$ui$ConnectPanel == null ? ConnectPanel.class$("org.netbeans.modules.debugger.jpda.ui.ConnectPanel") : class$org$netbeans$modules$debugger$jpda$ui$ConnectPanel), (String)"CTL_Invalid_value_title"));
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)in) == NotifyDescriptor.CANCEL_OPTION) {
                    return null;
                }
                paramValue = in.getInputText();
            }
            a.setValue(paramValue);
        }
        return args;
    }

    private static void saveArgs(Map args, Connector connector) {
        Map<String, Connector.Argument> defaultValues = connector.defaultArguments();
        HashMap<String, String> argsToSave = new HashMap<String, String>();
        Iterator i = args.keySet().iterator();
        while (i.hasNext()) {
            String argName = (String)i.next();
            Connector.Argument value = (Connector.Argument)args.get(argName);
            Connector.Argument defaultValue = defaultValues.get(argName);
            if (value == null || value == defaultValue || value.equals(defaultValue)) continue;
            argsToSave.put(argName, value.value());
        }
        Map m = Properties.getDefault().getProperties("debugger").getMap("connection_settings", new HashMap());
        String name = connector.name();
        m.put(name, argsToSave);
        Properties.getDefault().getProperties("debugger").setString("last_attaching_connector", name);
        Properties.getDefault().getProperties("debugger").setMap("connection_settings", m);
    }

    private static String translate(String str) {
        if (str.equalsIgnoreCase("Host")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_Host");
        }
        if (str.equalsIgnoreCase("Port")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_Port");
        }
        if (str.equalsIgnoreCase("Java executable")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_ConnectorArgument_JavaExecutable");
        }
        if (str.equalsIgnoreCase("Corefile")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_ConnectorArgument_Corefile");
        }
        if (str.equalsIgnoreCase("Debug server")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_ConnectorArgument_DebugServer");
        }
        if (str.equalsIgnoreCase("PID")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_ConnectorArgument_PID");
        }
        if (str.equalsIgnoreCase("Name")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_ConnectorArgument_Name");
        }
        if (str.equalsIgnoreCase("Timeout")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_ConnectorArgument_Timeout");
        }
        if (str.equalsIgnoreCase("Local Address")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_ConnectorArgument_LocalAddress");
        }
        return str;
    }

    private static char getMnemonic(String str) {
        if (str.equalsIgnoreCase("Host")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_Host_mnemonic").charAt(0);
        }
        if (str.equalsIgnoreCase("Port")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_Port_mnemonic").charAt(0);
        }
        if (str.equalsIgnoreCase("Java executable")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_ConnectorArgument_JavaExecutable_mnemonic").charAt(0);
        }
        if (str.equalsIgnoreCase("Corefile")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_ConnectorArgument_Corefile_mnemonic").charAt(0);
        }
        if (str.equalsIgnoreCase("Debug server")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_ConnectorArgument_DebugServer_mnemonic").charAt(0);
        }
        if (str.equalsIgnoreCase("PID")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_ConnectorArgument_PID_mnemonic").charAt(0);
        }
        if (str.equalsIgnoreCase("Name")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_ConnectorArgument_Name_mnemonic").charAt(0);
        }
        if (str.equalsIgnoreCase("Timeout")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_ConnectorArgument_Timeout_mnemonic").charAt(0);
        }
        if (str.equalsIgnoreCase("Local Address")) {
            return NbBundle.getMessage((Class)ConnectPanel.class, (String)"CTL_ConnectorArgument_LocalAddress_mnemonic").charAt(0);
        }
        return str.charAt(0);
    }
}

