/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.util.Vector;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.models.MonitorModel;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class ThreadsTableModel
implements TableModel,
Constants {
    private Vector listeners = new Vector();

    public Object getValueAt(Object row, String columnID) throws UnknownTypeException {
        if (row instanceof MonitorModel.ThreadWithBordel) {
            row = ((MonitorModel.ThreadWithBordel)row).originalThread;
        }
        if (row instanceof JPDAThreadGroup) {
            if (columnID.equals("ThreadState")) {
                return "";
            }
            if (columnID.equals("ThreadSuspended")) {
                JPDAThreadGroup group = (JPDAThreadGroup)row;
                JPDAThread[] threads = group.getThreads();
                if (threads.length < 1) {
                    return Boolean.FALSE;
                }
                return new Boolean(threads[0].isSuspended());
            }
        }
        if (row instanceof JPDAThread) {
            if (columnID.equals("ThreadState")) {
                switch (((JPDAThread)row).getState()) {
                    case 3: {
                        return NbBundle.getMessage((Class)ThreadsTableModel.class, (String)"CTL_Thread_State_OnMonitor");
                    }
                    case 5: {
                        return NbBundle.getMessage((Class)ThreadsTableModel.class, (String)"CTL_Thread_State_NotStarted");
                    }
                    case 1: {
                        return NbBundle.getMessage((Class)ThreadsTableModel.class, (String)"CTL_Thread_State_Running");
                    }
                    case 2: {
                        return NbBundle.getMessage((Class)ThreadsTableModel.class, (String)"CTL_Thread_State_Sleeping");
                    }
                    case -1: {
                        return NbBundle.getMessage((Class)ThreadsTableModel.class, (String)"CTL_Thread_State_Unknown");
                    }
                    case 4: {
                        return NbBundle.getMessage((Class)ThreadsTableModel.class, (String)"CTL_Thread_State_Waiting");
                    }
                    case 0: {
                        return NbBundle.getMessage((Class)ThreadsTableModel.class, (String)"CTL_Thread_State_Zombie");
                    }
                }
            } else if (columnID.equals("ThreadSuspended")) {
                return ((JPDAThread)row).isSuspended();
            }
        }
        throw new UnknownTypeException(row);
    }

    public boolean isReadOnly(Object row, String columnID) throws UnknownTypeException {
        if (row instanceof MonitorModel.ThreadWithBordel) {
            row = ((MonitorModel.ThreadWithBordel)row).originalThread;
        }
        if (row instanceof JPDAThreadGroup) {
            if (columnID.equals("ThreadState")) {
                return true;
            }
            if (columnID.equals("ThreadSuspended")) {
                return false;
            }
        }
        if (row instanceof JPDAThread) {
            if (columnID.equals("ThreadState")) {
                return true;
            }
            if (columnID.equals("ThreadSuspended")) {
                return false;
            }
        }
        throw new UnknownTypeException(row);
    }

    public void setValueAt(Object row, String columnID, Object value) throws UnknownTypeException {
        if (row instanceof MonitorModel.ThreadWithBordel) {
            row = ((MonitorModel.ThreadWithBordel)row).originalThread;
        }
        if (row instanceof JPDAThreadGroup && columnID.equals("ThreadSuspended")) {
            if (((Boolean)value).booleanValue()) {
                ((JPDAThreadGroup)row).suspend();
            } else {
                ((JPDAThreadGroup)row).resume();
            }
            this.fireTableValueChanged(row, "ThreadSuspended");
            return;
        }
        if (row instanceof JPDAThread && columnID.equals("ThreadSuspended")) {
            if (value.equals(Boolean.TRUE)) {
                ((JPDAThread)row).suspend();
            } else {
                ((JPDAThread)row).resume();
            }
            this.fireTableValueChanged(row, "ThreadSuspended");
            return;
        }
        throw new UnknownTypeException(row);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireTableValueChanged(Object o, String propertyName) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, o, propertyName));
        }
    }
}

