/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.views;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.Model;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

class ViewModelListener
extends DebuggerManagerAdapter {
    private static boolean verbose = System.getProperty("netbeans.debugger.models") != null;
    private String viewType;
    private JComponent view;

    ViewModelListener(String viewType, JComponent view) {
        this.viewType = viewType;
        this.view = view;
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        this.updateModel();
    }

    void destroy() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        Models.setModelsToView((JComponent)this.view, (Models.CompoundModel)Models.EMPTY_MODEL);
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.updateModel();
    }

    private List joinLookups(DebuggerEngine e, DebuggerManager dm, Class service) {
        List es = e.lookup(this.viewType, service);
        List ms = dm.lookup(this.viewType, service);
        ms.removeAll(es);
        es.addAll(ms);
        return es;
    }

    private void updateModel() {
        List mm;
        List columnModels;
        List nodeActionsProviderFilters;
        List nodeActionsProviders;
        List tableModelFilters;
        List tableModels;
        List nodeModelFilters;
        List nodeModels;
        List treeExpansionModels;
        List treeModelFilters;
        List treeModels;
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        DebuggerEngine e = dm.getCurrentEngine();
        if (e != null) {
            treeModels = this.joinLookups(e, dm, TreeModel.class);
            treeModelFilters = this.joinLookups(e, dm, TreeModelFilter.class);
            treeExpansionModels = this.joinLookups(e, dm, TreeExpansionModel.class);
            nodeModels = this.joinLookups(e, dm, NodeModel.class);
            nodeModelFilters = this.joinLookups(e, dm, NodeModelFilter.class);
            tableModels = this.joinLookups(e, dm, TableModel.class);
            tableModelFilters = this.joinLookups(e, dm, TableModelFilter.class);
            nodeActionsProviders = this.joinLookups(e, dm, NodeActionsProvider.class);
            nodeActionsProviderFilters = this.joinLookups(e, dm, NodeActionsProviderFilter.class);
            columnModels = this.joinLookups(e, dm, ColumnModel.class);
            mm = this.joinLookups(e, dm, Model.class);
        } else {
            treeModels = dm.lookup(this.viewType, TreeModel.class);
            treeModelFilters = dm.lookup(this.viewType, TreeModelFilter.class);
            treeExpansionModels = dm.lookup(this.viewType, TreeExpansionModel.class);
            nodeModels = dm.lookup(this.viewType, NodeModel.class);
            nodeModelFilters = dm.lookup(this.viewType, NodeModelFilter.class);
            tableModels = dm.lookup(this.viewType, TableModel.class);
            tableModelFilters = dm.lookup(this.viewType, TableModelFilter.class);
            nodeActionsProviders = dm.lookup(this.viewType, NodeActionsProvider.class);
            nodeActionsProviderFilters = dm.lookup(this.viewType, NodeActionsProviderFilter.class);
            columnModels = dm.lookup(this.viewType, ColumnModel.class);
            mm = dm.lookup(this.viewType, Model.class);
        }
        ArrayList<List> models = new ArrayList<List>(11);
        models.add(treeModels);
        models.add(treeModelFilters);
        models.add(treeExpansionModels);
        models.add(nodeModels);
        models.add(nodeModelFilters);
        models.add(tableModels);
        models.add(tableModelFilters);
        models.add(nodeActionsProviders);
        models.add(nodeActionsProviderFilters);
        models.add(columnModels);
        models.add(mm);
        Models.setModelsToView((JComponent)this.view, (Models.CompoundModel)Models.createCompoundModel(models));
    }

    private static class EmptyModel
    implements NodeModel {
        private EmptyModel() {
        }

        public String getDisplayName(Object node) throws UnknownTypeException {
            if (node == "Root") {
                return "Name";
            }
            throw new UnknownTypeException(node);
        }

        public String getIconBase(Object node) throws UnknownTypeException {
            if (node == "Root") {
                return "org/netbeans/modules/debugger/resources/DebuggerTab";
            }
            throw new UnknownTypeException(node);
        }

        public String getShortDescription(Object node) throws UnknownTypeException {
            throw new UnknownTypeException(node);
        }

        public void addModelListener(ModelListener l) {
        }

        public void removeModelListener(ModelListener l) {
        }
    }
}

