/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.clientproject.SourceRoots;
import org.netbeans.modules.j2ee.clientproject.classpath.BootClassPathImplementation;
import org.netbeans.modules.j2ee.clientproject.classpath.ProjectClassPathImplementation;
import org.netbeans.modules.j2ee.clientproject.classpath.SourcePathImplementation;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider,
PropertyChangeListener {
    private static final String BUILD_CLASSES_DIR = "build.classes.dir";
    private static final String DIST_JAR = "dist.jar";
    private static final String BUILD_TEST_CLASSES_DIR = "build.test.classes.dir";
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final ClassPath[] cache = new ClassPath[8];
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots) {
        this.helper = helper;
        this.projectDirectory = FileUtil.toFile((FileObject)helper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = evaluator;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = testSourceRoots;
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
    }

    private synchronized FileObject getDir(String propname) {
        String prop;
        FileObject fo = this.dirCache.get(propname);
        if (!(fo != null && fo.isValid() || (prop = this.helper.getStandardPropertyEvaluator().getProperty(propname)) == null)) {
            fo = this.helper.resolveFileObject(prop);
            this.dirCache.put(propname, fo);
        }
        return fo;
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private FileObject[] getTestSrcDir() {
        return this.testSourceRoots.getRoots();
    }

    private FileObject getBuildClassesDir() {
        return this.getDir(BUILD_CLASSES_DIR);
    }

    private FileObject getDistJar() {
        return this.getDir(DIST_JAR);
    }

    private FileObject getBuildTestClassesDir() {
        return this.getDir(BUILD_TEST_CLASSES_DIR);
    }

    private int getType(FileObject file) {
        FileObject root;
        int i;
        FileObject[] srcPath = this.getPrimarySrcPath();
        for (i = 0; i < srcPath.length; ++i) {
            root = srcPath[i];
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return 0;
        }
        srcPath = this.getTestSrcDir();
        for (i = 0; i < srcPath.length; ++i) {
            root = srcPath[i];
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return 1;
        }
        FileObject dir = this.getBuildClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 2;
        }
        dir = this.getDistJar();
        if (dir != null && dir.equals(FileUtil.getArchiveFile((FileObject)file))) {
            return 4;
        }
        dir = this.getBuildTestClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 3;
        }
        return -1;
    }

    private ClassPath getCompileTimeClasspath(FileObject file) {
        int type = this.getType(file);
        return this.getCompileTimeClasspath(type);
    }

    private ClassPath getCompileTimeClasspath(int type) {
        if (type < 0 || type > 1) {
            return null;
        }
        ClassPath cp = this.cache[2 + type];
        if (cp == null) {
            cp = type == 0 ? ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(this.helper, "${javac.classpath}:${j2ee.platform.classpath}", this.evaluator, false)) : ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(this.helper, "${javac.test.classpath}:${j2ee.platform.classpath}", this.evaluator, false));
            this.cache[2 + type] = cp;
        }
        return cp;
    }

    private ClassPath getRunTimeClasspath(FileObject file) {
        ClassPath cp;
        int type = this.getType(file);
        if (type < 0 || type > 4) {
            return null;
        }
        if (type > 1) {
            type -= 2;
        }
        if ((cp = this.cache[4 + type]) == null) {
            if (type == 0) {
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"run.classpath"}));
            } else if (type == 1) {
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"run.test.classpath"}));
            } else if (type == 2) {
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{DIST_JAR}));
            }
            this.cache[4 + type] = cp;
        }
        return cp;
    }

    private ClassPath getSourcepath(FileObject file) {
        int type = this.getType(file);
        return this.getSourcepath(type);
    }

    private ClassPath getSourcepath(int type) {
        if (type < 0 || type > 1) {
            return null;
        }
        ClassPath cp = this.cache[type];
        if (cp == null) {
            switch (type) {
                case 0: {
                    cp = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.sourceRoots, this.helper, this.evaluator));
                    break;
                }
                case 1: {
                    cp = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.testSourceRoots));
                }
            }
        }
        this.cache[type] = cp;
        return cp;
    }

    private ClassPath getBootClassPath() {
        ClassPath cp = this.cache[7];
        if (cp == null) {
            this.cache[7] = cp = ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImplementation(this.evaluator));
        }
        return cp;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(file);
        }
        if (type.equals("classpath/execute")) {
            return this.getRunTimeClasspath(file);
        }
        if (type.equals("classpath/source")) {
            return this.getSourcepath(file);
        }
        if (type.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String type) {
        if ("classpath/boot".equals(type)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/compile".equals(type)) {
            ClassPath[] l = new ClassPath[]{this.getCompileTimeClasspath(0), this.getCompileTimeClasspath(1)};
            return l;
        }
        if ("classpath/source".equals(type)) {
            ClassPath[] l = new ClassPath[]{this.getSourcepath(0), this.getSourcepath(1)};
            return l;
        }
        assert (false);
        return null;
    }

    public ClassPath getProjectSourcesClassPath(String type) {
        if ("classpath/source".equals(type)) {
            return this.getSourcepath(0);
        }
        if ("classpath/compile".equals(type)) {
            return this.getCompileTimeClasspath(0);
        }
        assert (false);
        return null;
    }

    public synchronized void propertyChange(PropertyChangeEvent evt) {
        this.dirCache.remove(evt.getPropertyName());
    }
}

