/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.diff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.diff.Add;
import org.netbeans.modules.xml.xdm.diff.Change;
import org.netbeans.modules.xml.xdm.diff.Delete;
import org.netbeans.modules.xml.xdm.diff.DiffFinder;
import org.netbeans.modules.xml.xdm.diff.Difference;
import org.netbeans.modules.xml.xdm.diff.NodeInfo;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeDiff {
    private XDMModel model;

    public void merge(XDMModel model, List<Difference> deList) {
        Set diffs;
        Node target;
        this.model = model;
        HashMap changesByNode = new HashMap();
        HashMap childrenDiffsByNode = new HashMap();
        HashMap<Integer, Node> idToChangeds = new HashMap<Integer, Node>();
        for (Difference difference : deList) {
            if (difference instanceof Change) {
                Change change = (Change)difference;
                if (change.isAttributeChanged() || change.isTokenChanged()) {
                    this.addDiffToMap(change.getOldNodeInfo().getNode(), change, changesByNode);
                }
                if (!change.isPositionChanged()) continue;
                this.addDiffToMap(difference.getOldNodeInfo().getParent(), change, childrenDiffsByNode);
                continue;
            }
            this.addDiffToMap(difference.getOldNodeInfo().getParent(), difference, childrenDiffsByNode);
        }
        for (Map.Entry entry : changesByNode.entrySet()) {
            target = this.getCurrentNode((Node)entry.getKey(), idToChangeds);
            assert (target != null) : "target " + ((Node)entry.getKey()).getId() + "is no longer inTree";
            diffs = (Set)entry.getValue();
            Node changed = this.applyChanges(diffs, target);
            assert (changed.getId() == target.getId()) : "changed id should not change";
            idToChangeds.put(changed.getId(), changed);
        }
        for (Map.Entry entry : childrenDiffsByNode.entrySet()) {
            target = this.getCurrentNode((Node)entry.getKey(), idToChangeds);
            assert (target != null) : "target " + ((Node)entry.getKey()).getId() + "is no longer inTree";
            diffs = (Set)entry.getValue();
            Node processed = this.applyChildrenDiffs(diffs, target);
            assert (processed.getId() == target.getId()) : "processed id should not change";
        }
    }

    private <T extends Difference> void addDiffToMap(Node key, T diff, HashMap<Node, Set<T>> map) {
        Set<T> diffs = map.get(key);
        if (diffs == null) {
            diffs = new HashSet<T>();
            map.put(key, diffs);
        }
        diffs.add(diff);
    }

    private Node getCurrentNode(Node target, HashMap<Integer, Node> idToChangeds) {
        List<Node> path;
        Node newTarget = idToChangeds.get(target.getId());
        if (!(newTarget != null && newTarget.isInTree() || (path = DiffFinder.getPathToRoot(target)) == null || path.isEmpty())) {
            newTarget = path.get(0);
            idToChangeds.put(target.getId(), newTarget);
        }
        return newTarget;
    }

    private Node applyChildrenDiffs(Set<Difference> diffs, Node target) {
        int id = target.getId();
        TreeMap<Integer, Difference> toAddOrReorder = new TreeMap<Integer, Difference>();
        for (Difference d : diffs) {
            if (d instanceof Delete) {
                this.delete(d.getOldNodeInfo());
                target = d.getNewParent();
                assert (id == target.getId());
                continue;
            }
            if (d instanceof Add) {
                toAddOrReorder.put(d.getNewNodeInfo().getPosition(), d);
                continue;
            }
            if (!(d instanceof Change)) continue;
            Change change = (Change)d;
            assert (change.isPositionChanged() && change.getOldNodeInfo().getParent().getId() == target.getId());
            toAddOrReorder.put(change.getNewNodeInfo().getPosition(), change);
        }
        target = this.processAddOrReorder(target, toAddOrReorder);
        assert (id == target.getId());
        for (Difference d : diffs) {
            d.setNewParent(target);
            assert (this.getReleventDiffNodeInfo(d).getNode().isInTree()) : "Processed child not in tree: " + d;
        }
        return target;
    }

    private NodeInfo getReleventDiffNodeInfo(Difference d) {
        if (d instanceof Add) {
            return d.getNewNodeInfo();
        }
        if (d instanceof Change) {
            Change c = (Change)d;
            if (c.isAttributeChanged() || c.isTokenChanged()) {
                return c.getNewNodeInfo();
            }
            return c.getOldNodeInfo();
        }
        if (d instanceof Delete) {
            return d.getOldNodeInfo();
        }
        throw new IllegalArgumentException("Invald diff type");
    }

    private List<Node> getChildrenNodes(Node target) {
        NodeList cList = target.getChildNodes();
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < cList.getLength(); ++i) {
            nodes.add((Node)cList.item(i));
        }
        return nodes;
    }

    private NodeInfo getReorderNodeInfo(Change change) {
        assert (change.isPositionChanged());
        if (change.isAttributeChanged() || change.isTokenChanged()) {
            return change.getNewNodeInfo();
        }
        return change.getOldNodeInfo();
    }

    private Node processAddOrReorder(Node target, SortedMap<Integer, Difference> toAddOrReorder) {
        Node toReorder;
        Difference diff;
        int id = target.getId();
        List<Node> worksheet = this.getChildrenNodes(target);
        for (Map.Entry<Integer, Difference> e : toAddOrReorder.entrySet()) {
            diff = e.getValue();
            if (!(diff instanceof Change)) continue;
            toReorder = this.getReorderNodeInfo((Change)diff).getNode();
            worksheet.remove(toReorder);
        }
        for (Map.Entry<Integer, Difference> e : toAddOrReorder.entrySet()) {
            int index;
            diff = e.getValue();
            if (diff instanceof Change) {
                toReorder = this.getReorderNodeInfo((Change)diff).getNode();
                index = diff.getNewNodeInfo().getPosition();
                worksheet.add(index, toReorder);
                continue;
            }
            if (!(diff instanceof Add)) continue;
            this.add(target, (Add)diff);
            target = diff.getNewParent();
            assert (id == target.getId());
            Node added = ((Add)diff).getNewNodeInfo().getNode();
            index = ((Add)diff).getNewNodeInfo().getPosition();
            worksheet.add(index, added);
        }
        assert (target.getChildNodes().getLength() == worksheet.size());
        int[] permutation = new int[worksheet.size()];
        NodeList cList = target.getChildNodes();
        for (int i = 0; i < cList.getLength(); ++i) {
            Node m = (Node)cList.item(i);
            int j = -1;
            for (int k = 0; k < worksheet.size(); ++k) {
                Node n = worksheet.get(k);
                if (m != n && !n.isEquivalentNode(m)) continue;
                j = k;
                break;
            }
            assert (j > -1) : "current item " + i + " is not on worksheet";
            permutation[i] = j;
        }
        target = this.reorder(target, permutation);
        for (Map.Entry<Integer, Difference> e : toAddOrReorder.entrySet()) {
            Change c;
            Difference diff2 = e.getValue();
            if (!(diff2 instanceof Change) || !(c = (Change)diff2).isPositionChanged() || c.isAttributeChanged() || c.isTokenChanged()) continue;
            c.getNewNodeInfo().setNode(c.getOldNodeInfo().getNode());
        }
        return target;
    }

    private Node applyChanges(Set<Change> diffs, Node target) {
        Node parent = null;
        for (Change change : diffs) {
            target = this.applyChange(change, target);
            parent = change.getNewParent();
        }
        for (Change change : diffs) {
            change.getNewNodeInfo().setNode(target);
            change.setNewParent(parent);
        }
        return target;
    }

    private Node applyChange(Change de, Node target) {
        Node oldNode = de.getOldNodeInfo().getNode();
        assert (target.getId() == oldNode.getId()) : "change target node id != old node id";
        Node curNode = de.getNewNodeInfo().getNode();
        if (de.isTokenChanged()) {
            NodeImpl newNode = this.createClone(target);
            newNode.copyTokens(curNode);
            de.setNewParent(this.modify(oldNode, newNode));
            target = newNode;
        }
        if (de.isAttributeChanged()) {
            assert (oldNode.getLocalName().equals(curNode.getLocalName()));
            this.applyAttrTokenChange(target, de);
        } else if (de.isTokenChanged()) {
            de.getNewNodeInfo().setNode(target);
        }
        return de.getNewNodeInfo().getNode();
    }

    private void applyAttrTokenChange(Node target, Change de) {
        Node curNode = de.getNewNodeInfo().getNode();
        List<Node> ancestors2 = DiffFinder.getPathToRoot(target);
        NamedNodeMap nm2 = curNode.getAttributes();
        HashMap<String, Integer> nodeToPosition = new HashMap<String, Integer>();
        for (int i = 0; i < nm2.getLength(); ++i) {
            Attribute newAttr = (Attribute)nm2.item(i);
            assert (newAttr.getName() != null);
            nodeToPosition.put(newAttr.getName(), new Integer(i));
        }
        List<Change.AttributeDiff> attrChanges = de.getAttrChanges();
        TreeMap<Integer, Attribute> positionToNode = new TreeMap<Integer, Attribute>();
        for (Change.AttributeDiff attributeDiff : attrChanges) {
            Attribute oldAttr = attributeDiff.getOldAttribute();
            Attribute currAttr = attributeDiff.getNewAttribute();
            if (oldAttr != null) {
                if (currAttr == null) {
                    ancestors2 = this.model.delete(oldAttr);
                    continue;
                }
                NodeImpl cloneAttr = this.createClone(oldAttr);
                cloneAttr.copyTokens(currAttr);
                ancestors2 = this.model.modify(oldAttr, cloneAttr);
                continue;
            }
            if (currAttr == null) continue;
            Integer pos = (Integer)nodeToPosition.get(currAttr.getName());
            assert (pos != null) : "Attribute " + currAttr.getName() + " \n" + de + nodeToPosition + " \n" + positionToNode;
            positionToNode.put(pos, currAttr);
        }
        for (Map.Entry entry : positionToNode.entrySet()) {
            NodeImpl copy = this.createCopy((Node)entry.getValue());
            curNode = (Element)ancestors2.get(0);
            ancestors2 = this.model.add(curNode, copy, (Integer)entry.getKey());
        }
        curNode = (Element)ancestors2.get(0);
        de.getNewNodeInfo().setNode(curNode);
        assert (ancestors2.get(1).isInTree()) : "new parent not intree";
        de.setNewParent(ancestors2.get(1));
    }

    private NodeImpl createCopy(Node currNode) {
        NodeImpl newNode = (NodeImpl)((NodeImpl)currNode).copy();
        return newNode;
    }

    private NodeImpl createClone(Node oldNode) {
        NodeImpl newNode = (NodeImpl)((NodeImpl)oldNode).clone(false, false, false);
        return newNode;
    }

    private void add(Node parent, Difference diff) {
        NodeInfo newInfo = diff.getNewNodeInfo();
        int pos = newInfo.getPosition();
        assert (pos <= parent.getChildNodes().getLength());
        NodeImpl newNode = null;
        newNode = diff instanceof Change ? this.createClone(newInfo.getNode()) : this.createCopy(newInfo.getNode());
        diff.setNewParent(this.model.add(parent, newNode, pos).get(0));
        newInfo.setNode(newNode);
    }

    private Node reorder(Node parent, int[] permutation) {
        return this.model.reorderChildren(parent, permutation).get(0);
    }

    private void delete(NodeInfo oldInfo) {
        oldInfo.setNewParent(this.model.delete(oldInfo.getNode()).get(0));
    }

    private Node modify(Node oldNode, Node newNode) {
        List<Node> ancestors = this.model.modify(oldNode, newNode);
        return ancestors.isEmpty() ? null : ancestors.get(0);
    }
}

