/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DatabaseConnectionConvertor
implements Environment.Provider,
InstanceCookie.Of {
    public static final String CONNECTIONS_PATH = "Databases/Connections";
    private static final int DELAY = 2000;
    private static FileObject newlyCreated = null;
    private static DatabaseConnection newlyCreatedInstance = null;
    private XMLDataObject holder = null;
    private Lookup lookup = null;
    private Reference refConnection = new WeakReference<Object>(null);
    private PCL listener;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    private static DatabaseConnectionConvertor createProvider() {
        return new DatabaseConnectionConvertor();
    }

    private DatabaseConnectionConvertor() {
    }

    private DatabaseConnectionConvertor(XMLDataObject object) {
        this.holder = object;
        InstanceContent cookies = new InstanceContent();
        cookies.add((Object)this);
        this.lookup = new AbstractLookup((AbstractLookup.Content)cookies);
    }

    private DatabaseConnectionConvertor(XMLDataObject object, DatabaseConnection existingInstance) {
        this(object);
        this.refConnection = new WeakReference<DatabaseConnection>(existingInstance);
        this.attachListener();
    }

    public Lookup getEnvironment(DataObject obj) {
        if (obj.getPrimaryFile() == newlyCreated) {
            return new DatabaseConnectionConvertor((XMLDataObject)obj, newlyCreatedInstance).getLookup();
        }
        return new DatabaseConnectionConvertor((XMLDataObject)obj).getLookup();
    }

    public String instanceName() {
        return this.holder.getName();
    }

    public Class instanceClass() {
        return DatabaseConnection.class;
    }

    public boolean instanceOf(Class type) {
        return type.isAssignableFrom(DatabaseConnection.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instanceCreate() throws IOException, ClassNotFoundException {
        DatabaseConnectionConvertor databaseConnectionConvertor = this;
        synchronized (databaseConnectionConvertor) {
            Object o = this.refConnection.get();
            if (o != null) {
                return o;
            }
            Handler handler = new Handler();
            try {
                XMLReader reader = XMLUtil.createXMLReader();
                InputSource is = new InputSource(this.holder.getPrimaryFile().getInputStream());
                is.setSystemId(this.holder.getPrimaryFile().getURL().toExternalForm());
                reader.setContentHandler(handler);
                reader.setErrorHandler(handler);
                reader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
                reader.parse(is);
            }
            catch (SAXException ex) {
                Exception x = ex.getException();
                if (x instanceof IOException) {
                    throw (IOException)x;
                }
                throw new IOException(ex.getMessage());
            }
            DatabaseConnection inst = DatabaseConnectionConvertor.createDatabaseConnection(handler);
            this.refConnection = new WeakReference<DatabaseConnection>(inst);
            this.attachListener();
            return inst;
        }
    }

    private void attachListener() {
        this.listener = new PCL();
        DatabaseConnection dbconn = (DatabaseConnection)this.refConnection.get();
        dbconn.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)dbconn));
    }

    private static DatabaseConnection createDatabaseConnection(Handler handler) {
        DatabaseConnection dbconn = new DatabaseConnection(handler.driverClass, handler.driverName, handler.connectionUrl, handler.schema, handler.user, null);
        return dbconn;
    }

    public static DataObject create(DatabaseConnection dbconn) throws IOException {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(CONNECTIONS_PATH);
        DataFolder df = DataFolder.findFolder((FileObject)fo);
        AtomicWriter writer = new AtomicWriter(dbconn, df, DatabaseConnectionConvertor.convertToFileName(dbconn.getName()));
        df.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)writer);
        return writer.holder;
    }

    private static String convertToFileName(String databaseURL) {
        return databaseURL.substring(0, Math.min(32, databaseURL.length())).replaceAll("[^\\p{Alnum}]", "_");
    }

    public static void importOldConnections() {
        Vector dbconns = RootNode.getOption().getConnections();
        Iterator i = dbconns.iterator();
        while (i.hasNext()) {
            try {
                DatabaseConnectionConvertor.create((DatabaseConnection)i.next());
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            i.remove();
        }
    }

    public static void remove(DatabaseConnection dbconn) throws IOException {
        String name = dbconn.getName();
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(CONNECTIONS_PATH);
        DataFolder folder = DataFolder.findFolder((FileObject)fo);
        DataObject[] objects = folder.getChildren();
        for (int i = 0; i < objects.length; ++i) {
            DatabaseConnection connection;
            InstanceCookie ic = (InstanceCookie)objects[i].getCookie(class$org$openide$cookies$InstanceCookie == null ? DatabaseConnectionConvertor.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
            if (ic == null) continue;
            Object obj = null;
            try {
                obj = ic.instanceCreate();
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (!(obj instanceof DatabaseConnection) || !(connection = (DatabaseConnection)obj).getName().equals(name)) continue;
            objects[i].delete();
            break;
        }
    }

    Lookup getLookup() {
        return this.lookup;
    }

    private final class PCL
    implements PropertyChangeListener,
    Runnable {
        LinkedList keepAlive = new LinkedList();
        RequestProcessor.Task saveTask = null;

        private PCL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            PCL pCL = this;
            synchronized (pCL) {
                if (this.saveTask == null) {
                    this.saveTask = RequestProcessor.getDefault().create((Runnable)this);
                }
                this.keepAlive.add(evt);
            }
            this.saveTask.schedule(2000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PropertyChangeEvent e;
            PCL pCL = this;
            synchronized (pCL) {
                e = (PropertyChangeEvent)this.keepAlive.removeFirst();
            }
            DatabaseConnection dbconn = (DatabaseConnection)e.getSource();
            try {
                DatabaseConnectionConvertor.this.holder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)new AtomicWriter(dbconn, (MultiDataObject)DatabaseConnectionConvertor.this.holder));
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    private static final class Handler
    extends DefaultHandler {
        private static final String ELEMENT_DRIVER_CLASS = "driver-class";
        private static final String ELEMENT_DRIVER_NAME = "driver-name";
        private static final String ELEMENT_DATABASE_URL = "database-url";
        private static final String ELEMENT_SCHEMA = "schema";
        private static final String ELEMENT_USER = "user";
        private static final String ATTR_PROPERTY_VALUE = "value";
        String driverClass;
        String driverName;
        String connectionUrl;
        String schema;
        String user;

        private Handler() {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            String value = attrs.getValue(ATTR_PROPERTY_VALUE);
            if (ELEMENT_DRIVER_CLASS.equals(qName)) {
                this.driverClass = value;
            } else if (ELEMENT_DRIVER_NAME.equals(qName)) {
                this.driverName = value;
            } else if (ELEMENT_DATABASE_URL.equals(qName)) {
                this.connectionUrl = value;
            } else if (ELEMENT_SCHEMA.equals(qName)) {
                this.schema = value;
            } else if (ELEMENT_USER.equals(qName)) {
                this.user = value;
            }
        }
    }

    private static final class AtomicWriter
    implements FileSystem.AtomicAction {
        DatabaseConnection instance;
        MultiDataObject holder;
        String fileName;
        DataFolder parent;

        AtomicWriter(DatabaseConnection instance, MultiDataObject holder) {
            this.instance = instance;
            this.holder = holder;
        }

        AtomicWriter(DatabaseConnection instance, DataFolder parent, String fileName) {
            this.instance = instance;
            this.fileName = fileName;
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            FileLock lck;
            FileObject data;
            if (this.holder != null) {
                data = this.holder.getPrimaryEntry().getFile();
                lck = this.holder.getPrimaryEntry().takeLock();
            } else {
                FileObject folder = this.parent.getPrimaryFile();
                String fn = FileUtil.findFreeFileName((FileObject)folder, (String)this.fileName, (String)"xml");
                data = folder.createData(fn, "xml");
                lck = data.lock();
            }
            try {
                OutputStream ostm = data.getOutputStream(lck);
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(ostm, "UTF8"));
                this.write(writer);
                writer.flush();
                writer.close();
                ostm.close();
            }
            finally {
                lck.releaseLock();
            }
            if (this.holder == null) {
                newlyCreated = data;
                newlyCreatedInstance = this.instance;
                this.holder = (MultiDataObject)DataObject.find((FileObject)data);
                this.holder.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = DatabaseConnectionConvertor.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                newlyCreated = null;
                newlyCreatedInstance = null;
            }
        }

        void write(PrintWriter pw) throws IOException {
            pw.println("<?xml version='1.0'?>");
            pw.println("<!DOCTYPE connection PUBLIC '-//NetBeans//DTD Database Connection 1.0//EN' 'http://www.netbeans.org/dtds/connection-1_0.dtd'>");
            pw.println("<connection>");
            pw.println("  <driver-class value='" + XMLUtil.toAttributeValue((String)this.instance.getDriver()) + "'/>");
            pw.println("  <driver-name value='" + XMLUtil.toAttributeValue((String)this.instance.getDriverName()) + "'/>");
            pw.println("  <database-url value='" + XMLUtil.toAttributeValue((String)this.instance.getDatabase()) + "'/>");
            if (this.instance.getSchema() != null) {
                pw.println("  <schema value='" + XMLUtil.toAttributeValue((String)this.instance.getSchema()) + "'/>");
            }
            if (this.instance.getUser() != null) {
                pw.println("  <user value='" + XMLUtil.toAttributeValue((String)this.instance.getUser()) + "'/>");
            }
            pw.println("</connection>");
        }
    }
}

