/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.GrabTableProgressPanel;
import org.netbeans.modules.db.explorer.infos.ColumnNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.WindowManager;

public class GrabTableAction
extends DatabaseAction {
    static final long serialVersionUID = -7685449970256732671L;

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes != null && activatedNodes.length == 1;
    }

    public void performAction(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return;
        }
        Node node = activatedNodes[0];
        try {
            DatabaseNodeInfo info = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
            DatabaseNodeInfo nfo = info.getParent(this.nodename);
            Specification spec = (Specification)nfo.getSpecification();
            String tablename = (String)nfo.get("table");
            CreateTable cmd = spec.createCommandCreateTable(tablename);
            GrabTableWorker run = new GrabTableWorker(nfo);
            Enumeration enu = run.execute();
            while (enu.hasMoreElements()) {
                Object element = enu.nextElement();
                if (!(element instanceof ColumnNodeInfo)) continue;
                cmd.getColumns().add(((ColumnNodeInfo)element).getColumnSpecification());
            }
            JFileChooser chooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
            chooser.setDialogType(1);
            chooser.setDialogTitle(GrabTableAction.bundle().getString("GrabTableFileSaveDialogTitle"));
            chooser.setSelectedFile(new File(tablename + ".grab"));
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".grab");
                }

                public String getDescription() {
                    return DatabaseAction.bundle().getString("GrabTableFileTypeDescription");
                }
            });
            Frame par = WindowManager.getDefault().getMainWindow();
            boolean noResult = true;
            File file = null;
            while (noResult) {
                if (chooser.showSaveDialog(par) == 0) {
                    file = chooser.getSelectedFile();
                    if (file == null) continue;
                    if (file.exists()) {
                        JButton yesOption = new JButton(GrabTableAction.bundle().getString("Yes"));
                        JButton noOption = new JButton(GrabTableAction.bundle().getString("No"));
                        Object result = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)MessageFormat.format(GrabTableAction.bundle().getString("MSG_ReplaceFileOrNot"), file.getName()), GrabTableAction.bundle().getString("GrabTableFileSaveDialogTitle"), 0, 3, new Object[]{yesOption, noOption}, (Object)yesOption));
                        if (!result.equals(yesOption)) continue;
                        noResult = false;
                        continue;
                    }
                    noResult = false;
                    continue;
                }
                return;
            }
            FileOutputStream fstream = new FileOutputStream(file);
            ObjectOutputStream ostream = new ObjectOutputStream(fstream);
            cmd.setSpecification(null);
            ostream.writeObject(cmd);
            ostream.flush();
            ostream.close();
        }
        catch (Exception exc) {
            String message = MessageFormat.format(GrabTableAction.bundle().getString("ERR_UnableToGrabTable"), exc.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
        }
    }

    private static final class GrabTableWorker {
        private DatabaseNodeInfo nfo;
        private Task task;
        private Dialog dialog;
        private ProgressHandle progressHandle;
        private Enumeration enumeration;
        private DatabaseException exception;

        public GrabTableWorker(DatabaseNodeInfo nfo) {
            this.nfo = nfo;
        }

        public Enumeration execute() throws DatabaseException {
            this.progressHandle = ProgressHandleFactory.createHandle(null);
            GrabTableProgressPanel progressPanel = new GrabTableProgressPanel();
            progressPanel.setProgressComponent(ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progressHandle));
            String dialogTitle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("GrabTableProgressDialogTitle");
            DialogDescriptor desc = new DialogDescriptor((Object)progressPanel, dialogTitle, true, new Object[0], DialogDescriptor.NO_OPTION, 0, null, null);
            this.dialog = DialogDisplayer.getDefault().createDialog(desc);
            this.dialog.setResizable(false);
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setDefaultCloseOperation(0);
            }
            this.progressHandle.start();
            this.task = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        GrabTableWorker.this.enumeration = GrabTableWorker.this.nfo.getChildren().elements();
                    }
                    catch (DatabaseException e) {
                        GrabTableWorker.this.exception = e;
                    }
                }
            });
            this.task.addTaskListener(new TaskListener(){

                public void taskFinished(Task t) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            GrabTableWorker.this.dialog.setVisible(false);
                        }
                    });
                }
            });
            if (!this.task.isFinished()) {
                this.dialog.setVisible(true);
            }
            this.dialog.dispose();
            this.progressHandle.finish();
            if (this.exception != null) {
                throw this.exception;
            }
            return this.enumeration;
        }
    }
}

