/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DatabaseProductNotFoundException;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.SpecificationFactory;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DerbyConectionEventListener;
import org.netbeans.modules.db.explorer.infos.ConnectionOperations;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class ConnectionNodeInfo
extends DatabaseNodeInfo
implements ConnectionOperations {
    static final long serialVersionUID = -8322295510950137669L;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo;

    private void connect(String dbsys) throws DatabaseException {
        String drvurl = this.getDriver();
        String dburl = this.getDatabase();
        try {
            DatabaseConnection con = new DatabaseConnection(drvurl, dburl, this.getUser(), this.getPassword());
            Connection connection = con.createJDBCConnection();
            this.finishConnect(dbsys, con, connection);
        }
        catch (Exception e) {
            DatabaseException dbe = new DatabaseException(e.getMessage());
            dbe.initCause(e);
            throw dbe;
        }
    }

    public void connect() throws DatabaseException {
        this.connect((String)null);
    }

    public void connect(DBConnection conn) throws DatabaseException {
        try {
            Specification spec;
            String dbsys = null;
            DatabaseConnection con = (DatabaseConnection)conn;
            Connection connection = con.getConnection();
            SpecificationFactory factory = (SpecificationFactory)this.getSpecificationFactory();
            if (dbsys != null) {
                spec = (Specification)factory.createSpecification(con, dbsys, connection);
            } else {
                this.setReadOnly(false);
                spec = (Specification)factory.createSpecification(con, connection);
            }
            this.put("dbproduct", spec.getProperties().get("dbproduct"));
            this.setSpecification(spec);
            DriverSpecification drvSpec = factory.createDriverSpecification(spec.getMetaData().getDriverName().trim());
            if (spec.getMetaData().getDriverName().trim().equals("jConnect (TM) for JDBC (TM)")) {
                drvSpec.setMetaData(connection.getMetaData());
            } else {
                drvSpec.setMetaData(spec.getMetaData());
            }
            drvSpec.setCatalog(connection.getCatalog());
            drvSpec.setSchema(this.getSchema());
            this.setDriverSpecification(drvSpec);
            this.setConnection(connection);
        }
        catch (DatabaseProductNotFoundException e) {
            this.setReadOnly(false);
            this.connect("GenericDatabaseSystem");
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void finishConnect(String dbsys, DatabaseConnection con, Connection connection) throws DatabaseException {
        try {
            Specification spec;
            SpecificationFactory factory = (SpecificationFactory)this.getSpecificationFactory();
            if (dbsys != null) {
                spec = (Specification)factory.createSpecification(con, dbsys, connection);
            } else {
                this.setReadOnly(false);
                spec = (Specification)factory.createSpecification(con, connection);
            }
            this.put("dbproduct", spec.getProperties().get("dbproduct"));
            this.setSpecification(spec);
            DriverSpecification drvSpec = factory.createDriverSpecification(spec.getMetaData().getDriverName().trim());
            if (spec.getMetaData().getDriverName().trim().equals("jConnect (TM) for JDBC (TM)")) {
                drvSpec.setMetaData(connection.getMetaData());
            } else {
                drvSpec.setMetaData(spec.getMetaData());
            }
            drvSpec.setCatalog(connection.getCatalog());
            drvSpec.setSchema(this.getSchema());
            this.setDriverSpecification(drvSpec);
            this.setConnection(connection);
        }
        catch (DatabaseProductNotFoundException e) {
            this.setReadOnly(false);
            this.connect("GenericDatabaseSystem");
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void disconnect() throws DatabaseException {
        Connection connection = this.getConnection();
        if (connection != null) {
            String message = null;
            try {
                connection.close();
                this.setConnection(null);
            }
            catch (Exception exc) {
                this.setConnection(null);
                message = MessageFormat.format(ConnectionNodeInfo.bundle().getString("EXC_ConnectionIsBroken"), exc.getMessage());
            }
            DerbyConectionEventListener.getDefault().afterDisconnect(this.getDatabaseConnection(), connection);
            if (message != null) {
                throw new DatabaseException(message);
            }
        }
    }

    public void delete() throws IOException {
        try {
            DatabaseConnection cinfo = this.getDatabaseConnection();
            ConnectionList.getDefault().remove(cinfo);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public Object put(Object key, Object obj) {
        if (key.equals("user") || key.equals("driver") || key.equals("db") || key.equals("schema")) {
            String newVal = (String)obj;
            this.updateConnection((String)key, newVal);
        }
        return super.put(key, obj);
    }

    private void updateConnection(String key, String newVal) {
        DatabaseConnection infoConn = this.getDatabaseConnection();
        DatabaseConnection connFromList = ConnectionList.getDefault().getConnection(infoConn);
        if (connFromList != null) {
            if (key.equals("schema")) {
                connFromList.setSchema(newVal);
            } else if (key.equals("user")) {
                connFromList.setUser(newVal);
            } else if (key.equals("driver")) {
                connFromList.setDriver(newVal);
            } else if (key.equals("db")) {
                connFromList.setDatabase(newVal);
            }
        }
        this.setName(infoConn.getName());
    }

    public void refreshChildren() throws DatabaseException {
        Children children = this.getNode().getChildren();
        Node[] nodes = children.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            DatabaseNodeInfo info = (DatabaseNodeInfo)nodes[i].getCookie(class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo == null ? ConnectionNodeInfo.class$("org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo") : class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo);
            info.refreshChildren();
        }
    }
}

