/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.util.Vector;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.ConnectionOwnerOperations;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;

public class RootNodeInfo
extends DatabaseNodeInfo
implements ConnectionOwnerOperations {
    static final long serialVersionUID = -8079386805046070315L;
    static RootNodeInfo rootInfo = null;

    public static RootNodeInfo getInstance() throws DatabaseException {
        if (rootInfo == null) {
            rootInfo = (RootNodeInfo)DatabaseNodeInfo.createNodeInfo(null, "root");
        }
        return rootInfo;
    }

    public void initChildren(Vector children) throws DatabaseException {
        try {
            FileObject adaptorsFolder;
            DataFolder dbdo;
            DatabaseConnection[] cinfos = ConnectionList.getDefault().getConnections();
            for (int i = 0; i < cinfos.length; ++i) {
                DatabaseConnection cinfo = cinfos[i];
                ConnectionNodeInfo ninfo = this.createConnectionNodeInfo(cinfo);
                children.add(ninfo);
            }
            Repository r = Repository.getDefault();
            FileSystem rfs = r.getDefaultFileSystem();
            FileObject rootFolder = rfs.getRoot();
            FileObject databaseFileObject = rootFolder.getFileObject("Database");
            if (databaseFileObject != null && (dbdo = DataFolder.findFolder((FileObject)(adaptorsFolder = databaseFileObject.getFileObject("Adaptors")))) != null) {
                children.add(dbdo.getNodeDelegate());
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    private ConnectionNodeInfo createConnectionNodeInfo(DatabaseConnection dbconn) throws DatabaseException {
        ConnectionNodeInfo ninfo = (ConnectionNodeInfo)RootNodeInfo.createNodeInfo(this, "connection");
        ninfo.setUser(dbconn.getUser());
        ninfo.setDatabase(dbconn.getDatabase());
        ninfo.setSchema(dbconn.getSchema());
        ninfo.setName(dbconn.getName());
        ninfo.setDatabaseConnection(dbconn);
        return ninfo;
    }

    public void refreshChildren() throws DatabaseException {
    }

    public void addConnectionNoConnect(DatabaseConnection dbconn) throws DatabaseException {
        this.getChildren();
        if (ConnectionList.getDefault().contains(dbconn)) {
            return;
        }
        DatabaseNode node = this.getNode();
        DatabaseNodeChildren children = (DatabaseNodeChildren)node.getChildren();
        ConnectionNodeInfo ninfo = this.createConnectionNodeInfo(dbconn);
        ConnectionList.getDefault().add(dbconn);
        children.createSubnode(ninfo, true);
    }

    public void addConnection(DBConnection cinfo) throws DatabaseException {
        DatabaseConnection dbconn = (DatabaseConnection)cinfo;
        this.getChildren();
        if (ConnectionList.getDefault().contains(dbconn)) {
            throw new DatabaseException(RootNodeInfo.bundle().getString("EXC_ConnectionAlreadyExists"));
        }
        DatabaseNode node = this.getNode();
        DatabaseNodeChildren children = (DatabaseNodeChildren)node.getChildren();
        children.getNodes(true);
        ConnectionNodeInfo ninfo = this.createConnectionNodeInfo(dbconn);
        ConnectionList.getDefault().add(dbconn);
        DatabaseNode cnode = children.createSubnode(ninfo, true);
        if (dbconn.getConnection() == null) {
            ((ConnectionNodeInfo)cnode.getInfo()).connect();
        } else {
            ((ConnectionNodeInfo)cnode.getInfo()).connect(dbconn);
        }
    }
}

