/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.bookmarks.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.lib.editor.bookmarks.api.Bookmark;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.openide.util.NbBundle;

public final class GotoBookmarkAction
extends BaseAction {
    public static final String GOTO_NEXT_NAME = "bookmark-next";
    public static final String GOTO_PREVIOUS_NAME = "bookmark-previous";
    static final long serialVersionUID = -5169554640178645108L;
    private final boolean gotoNext;
    private final boolean select;

    public static GotoBookmarkAction createNext() {
        return new GotoBookmarkAction(true);
    }

    public static GotoBookmarkAction createPrevious() {
        return new GotoBookmarkAction(false);
    }

    public GotoBookmarkAction(boolean gotoNext) {
        this(gotoNext, false);
    }

    public GotoBookmarkAction(boolean gotoNext, boolean select) {
        super(gotoNext ? GOTO_NEXT_NAME : GOTO_PREVIOUS_NAME, 30);
        this.gotoNext = gotoNext;
        this.select = select;
        this.putValue("IconResource", gotoNext ? "org/netbeans/modules/editor/bookmarks/resources/next_bookmark.png" : "org/netbeans/modules/editor/bookmarks/resources/previous_bookmark.png");
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        if (target != null) {
            Bookmark bookmark;
            Caret caret = target.getCaret();
            BookmarkList bookmarkList = BookmarkList.get(target.getDocument());
            int dotOffset = caret.getDot();
            Bookmark bookmark2 = bookmark = this.gotoNext ? bookmarkList.getNextBookmark(dotOffset, true) : bookmarkList.getPreviousBookmark(dotOffset, true);
            if (bookmark != null) {
                if (this.select) {
                    caret.moveDot(bookmark.getOffset());
                } else {
                    caret.setDot(bookmark.getOffset());
                }
            }
        }
    }

    protected Object getDefaultShortDescription() {
        return NbBundle.getBundle((Class)GotoBookmarkAction.class).getString((String)this.getValue("Name"));
    }
}

