/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.transform;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.TransformableCookie;
import org.netbeans.modules.xml.core.actions.InputOutputReporter;
import org.netbeans.modules.xml.core.lib.FileUtilities;
import org.netbeans.modules.xml.core.lib.GuiUtil;
import org.netbeans.modules.xsl.settings.TransformHistory;
import org.netbeans.modules.xsl.transform.TransformServlet;
import org.netbeans.modules.xsl.transform.Util;
import org.netbeans.modules.xsl.ui.TransformPanel;
import org.netbeans.modules.xsl.utils.TransformUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.xml.sax.SAXException;

public class TransformPerformer {
    private InputOutputReporter cookieObserver = null;
    private Node[] nodes;
    private volatile boolean stalled = false;
    private volatile boolean active = true;
    static /* synthetic */ Class class$org$netbeans$modules$xsl$actions$TransformAction;

    public TransformPerformer(Node[] nodes) {
        this.nodes = nodes;
    }

    private void saveBeforeTransformation(DataObject dObject) {
        SaveCookie save;
        if (dObject.isModified() && (save = (SaveCookie)dObject.getCookie(SaveCookie.class)) != null) {
            try {
                save.save();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() {
        if (this.stalled) {
            throw new IllegalStateException();
        }
        try {
            if (this.nodes.length == 2) {
                DataObject do1 = (DataObject)this.nodes[0].getCookie(DataObject.class);
                boolean xslt1 = TransformUtil.isXSLTransformation(do1);
                DataObject do2 = (DataObject)this.nodes[1].getCookie(DataObject.class);
                boolean xslt2 = TransformUtil.isXSLTransformation(do2);
                this.saveBeforeTransformation(do1);
                this.saveBeforeTransformation(do2);
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("TransformAction.performAction:");
                    Util.THIS.debug("    do1 [" + xslt1 + "] = " + do1);
                    Util.THIS.debug("    do2 [" + xslt2 + "] = " + do2);
                }
                if (xslt1 != xslt2) {
                    DataObject xslDO;
                    DataObject xmlDO;
                    TransformableCookie transformable;
                    if (xslt1) {
                        transformable = (TransformableCookie)this.nodes[1].getCookie(TransformableCookie.class);
                        xmlDO = do2;
                        xslDO = do1;
                    } else {
                        transformable = (TransformableCookie)this.nodes[0].getCookie(TransformableCookie.class);
                        xmlDO = do1;
                        xslDO = do2;
                    }
                    DoublePerformer performer = new DoublePerformer(transformable, xmlDO, xslDO);
                    performer.perform();
                } else {
                    TransformableCookie transformable1 = (TransformableCookie)this.nodes[0].getCookie(TransformableCookie.class);
                    SinglePerformer performer = new SinglePerformer(transformable1, do1, xslt1);
                    performer.setLastInBatch(false);
                    performer.perform();
                    TransformableCookie transformable2 = (TransformableCookie)this.nodes[1].getCookie(TransformableCookie.class);
                    performer = new SinglePerformer(transformable2, do2, xslt2);
                    performer.perform();
                }
            } else {
                for (int i = 0; i < this.nodes.length; ++i) {
                    DataObject dataObject = (DataObject)this.nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? TransformPerformer.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                    this.saveBeforeTransformation(dataObject);
                    TransformableCookie transformable = null;
                    boolean xslt = TransformUtil.isXSLTransformation(dataObject);
                    if (!xslt) {
                        transformable = (TransformableCookie)this.nodes[i].getCookie(class$org$netbeans$api$xml$cookies$TransformableCookie == null ? TransformPerformer.class$("org.netbeans.api.xml.cookies.TransformableCookie") : class$org$netbeans$api$xml$cookies$TransformableCookie);
                    }
                    SinglePerformer performer = new SinglePerformer(transformable, dataObject, xslt);
                    performer.setLastInBatch(i == this.nodes.length - 1);
                    performer.perform();
                }
            }
        }
        finally {
            this.stalled = true;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private InputOutputReporter getCookieObserver() {
        if (this.cookieObserver == null) {
            String label = Util.THIS.getString("PROP_transformation_io_name");
            this.cookieObserver = new InputOutputReporter(label);
        }
        return this.cookieObserver;
    }

    private class DoublePerformer
    extends AbstractPerformer {
        public DoublePerformer(TransformableCookie transformable, DataObject xmlDO, DataObject xslDO) {
            super(transformable);
            this.xmlDO = xmlDO;
            this.xslDO = xslDO;
        }

        protected void init() throws IOException {
            this.baseFO = this.xmlDO.getPrimaryFile();
            this.baseURL = this.preferFileURL(this.baseFO);
        }

        protected void storeData() {
            this.updateHistory(this.xmlDO, false);
            this.updateHistory(this.xslDO, true);
        }
    }

    private class SinglePerformer
    extends AbstractPerformer {
        private DataObject dataObject;
        private boolean xslt;

        public SinglePerformer(TransformableCookie transformable, DataObject dataObject, boolean xslt) {
            super(transformable);
            this.dataObject = dataObject;
            this.xslt = xslt;
        }

        protected void init() throws IOException {
            this.baseFO = this.dataObject.getPrimaryFile();
            this.baseURL = this.preferFileURL(this.baseFO);
            if (this.xslt) {
                this.xmlDO = null;
                this.xmlStylesheetSource = null;
                this.xslDO = this.dataObject;
            } else {
                this.xmlDO = this.dataObject;
                this.xmlStylesheetSource = TransformUtil.getAssociatedStylesheet(this.baseURL);
                this.xslDO = null;
            }
        }

        protected void storeData() {
            this.updateHistory(this.dataObject, this.xslt);
        }
    }

    private abstract class AbstractPerformer
    extends WindowAdapter
    implements ActionListener {
        private TransformableCookie transformableCookie;
        protected DataObject xmlDO;
        protected Source xmlStylesheetSource;
        protected DataObject xslDO;
        protected FileObject baseFO;
        protected URL baseURL;
        private Source xmlSource;
        private Source xslSource;
        private FileObject resultFO;
        private TransformPanel transformPanel;
        private DialogDescriptor dialogDescriptor;
        private Dialog dialog;
        private TransformPanel.Data data;
        private boolean last = true;
        private boolean workaround31850 = true;

        public AbstractPerformer(TransformableCookie transformable) {
            this.transformableCookie = transformable;
        }

        public final void perform() {
            block3: {
                try {
                    this.init();
                    this.showDialog();
                }
                catch (IOException exc) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug(exc);
                    }
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)exc.getLocalizedMessage(), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (!this.isLastInBatch()) break block3;
                    TransformPerformer.this.active = false;
                }
            }
        }

        protected abstract void init() throws IOException;

        protected abstract void storeData();

        private void showDialog() throws IOException {
            String xmlStylesheetName = null;
            if (this.xmlStylesheetSource != null) {
                xmlStylesheetName = this.xmlStylesheetSource.getSystemId();
            }
            this.transformPanel = new TransformPanel(this.xmlDO, xmlStylesheetName, this.xslDO);
            this.dialogDescriptor = new DialogDescriptor((Object)this.transformPanel, Util.THIS.getString("NAME_transform_panel_title"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(class$org$netbeans$modules$xsl$actions$TransformAction == null ? (class$org$netbeans$modules$xsl$actions$TransformAction = TransformPerformer.class$("org.netbeans.modules.xsl.actions.TransformAction")) : class$org$netbeans$modules$xsl$actions$TransformAction), null);
            this.dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
            this.dialogDescriptor.setButtonListener((ActionListener)this);
            this.dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
            this.dialog.addWindowListener(this);
            this.dialog.show();
        }

        protected void prepareData() throws IOException, FileStateInvalidException, MalformedURLException, ParserConfigurationException, SAXException {
            this.data = this.transformPanel.getData();
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TransformPerformer...performTransformation");
                Util.THIS.debug("    transformable = " + this.transformableCookie);
                Util.THIS.debug("    baseFileObject = " + this.baseFO);
                Util.THIS.debug("    data = " + this.data);
            }
            try {
                this.xmlSource = TransformUtil.createSource(this.baseURL, this.data.getInput());
            }
            catch (IOException ex) {
                ErrorManager.getDefault().annotate((Throwable)ex, Util.THIS.getString("MSG_sourceError"));
                throw ex;
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("    xmlSource = " + this.xmlSource.getSystemId());
            }
            if (this.data.getXSL() != null) {
                try {
                    this.xslSource = TransformUtil.createSource(this.baseURL, this.data.getXSL());
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().annotate((Throwable)ex, Util.THIS.getString("MSG_transError"));
                    throw ex;
                }
            } else {
                this.xslSource = this.xmlStylesheetSource;
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("    xslSource = " + this.xslSource.getSystemId());
            }
            if (this.data.getOutput() != null) {
                String fileName = this.data.getOutput().toString().replace('\\', '/');
                try {
                    this.resultFO = FileUtilities.createFileObject((FileObject)this.baseFO.getParent(), (String)fileName, (boolean)this.data.isOverwriteOutput());
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().annotate((Throwable)ex, Util.THIS.getString("MSG_resultError"));
                    throw ex;
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("    resultFO = " + this.resultFO);
                }
            }
        }

        protected void updateHistory(DataObject dataObject, boolean xslt) {
            FileObject fileObject = dataObject.getPrimaryFile();
            TransformHistory history = (TransformHistory)fileObject.getAttribute("org.netbeans.modules.xsl.settings.TransformHistory");
            if (history == null) {
                history = new TransformHistory();
            }
            String outputStr = null;
            if (this.data.getOutput() != null) {
                outputStr = this.data.getOutput().toString();
            }
            if (xslt) {
                history.addXML(this.data.getInput(), outputStr);
            } else {
                history.addXSL(this.data.getXSL(), outputStr);
            }
            history.setOverwriteOutput(this.data.isOverwriteOutput());
            history.setProcessOutput(this.data.getProcessOutput());
            try {
                fileObject.setAttribute("org.netbeans.modules.xsl.settings.TransformHistory", (Object)history);
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify(1, (Throwable)exc);
            }
        }

        private void previewOutput() throws MalformedURLException, UnknownHostException {
            TransformServlet.prepare(this.transformableCookie, this.xmlSource, this.xslSource);
            this.showURL(TransformServlet.getServletURL());
        }

        private void fileOutput() throws IOException, FileStateInvalidException, TransformerException {
            OutputStream outputStream = null;
            FileLock fileLock = null;
            try {
                fileLock = this.resultFO.lock();
                outputStream = this.resultFO.getOutputStream(fileLock);
                StreamResult outputResult = new StreamResult(outputStream);
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("    resultFO = " + this.resultFO);
                    Util.THIS.debug("    outputResult = " + outputResult);
                }
                String xmlName = this.data.getInput();
                String xslName = this.data.getXSL();
                TransformPerformer.this.getCookieObserver().message(Util.THIS.getString("MSG_transformation_1", xmlName, xslName));
                TransformUtil.transform(this.xmlSource, this.transformableCookie, this.xslSource, outputResult, (CookieObserver)TransformPerformer.this.getCookieObserver());
                try {
                    DataObject dataObject = DataObject.find((FileObject)this.resultFO);
                    dataObject.setValid(false);
                }
                catch (DataObjectNotFoundException dnf) {
                    throw new IllegalStateException();
                }
                catch (PropertyVetoException pve) {
                    ErrorManager.getDefault().log(1, "Cannot invalidate " + this.resultFO);
                }
                if (this.data.getProcessOutput() == 1) {
                    GuiUtil.performDefaultAction((FileObject)this.resultFO);
                    GuiUtil.performDefaultAction((FileObject)this.resultFO);
                } else if (this.data.getProcessOutput() == 2) {
                    this.showURL(this.resultFO.getURL());
                }
            }
            catch (FileAlreadyLockedException exc) {
                throw (FileAlreadyLockedException)ErrorManager.getDefault().annotate((Throwable)exc, Util.THIS.getString("ERR_FileAlreadyLockedException_output"));
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }

        private void showURL(URL url) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            GuiUtil.setStatusText((String)Util.THIS.getString("MSG_opening_browser"));
        }

        public final void actionPerformed(ActionEvent e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("[TransformPerformer::AbstractPerformer] actionPerformed: " + e);
                Util.THIS.debug("    ActionEvent.getSource(): " + e.getSource());
            }
            this.workaround31850 = false;
            if (DialogDescriptor.OK_OPTION.equals(e.getSource())) {
                try {
                    this.prepareData();
                    if (this.data.getOutput() != null && this.resultFO == null) {
                        return;
                    }
                    this.dialog.dispose();
                    this.storeData();
                    this.async();
                }
                catch (Exception exc) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug(exc);
                    }
                    ErrorManager.getDefault().notify(16, (Throwable)exc);
                    if (this.isLastInBatch()) {
                        TransformPerformer.this.active = false;
                    }
                }
            } else {
                TransformPerformer.this.active = false;
            }
        }

        public void windowClosed(WindowEvent e) {
            super.windowClosed(e);
            if (this.workaround31850) {
                TransformPerformer.this.active = false;
            }
        }

        private void async() {
            RequestProcessor rp = RequestProcessor.getDefault();
            rp.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        if (AbstractPerformer.this.data.getOutput() == null) {
                            AbstractPerformer.this.previewOutput();
                        } else {
                            AbstractPerformer.this.fileOutput();
                        }
                    }
                    catch (TransformerException exc) {
                    }
                    catch (Exception exc) {
                        if (Util.THIS.isLoggable()) {
                            Util.THIS.debug(exc);
                        }
                        ErrorManager.getDefault().notify(16, (Throwable)exc);
                    }
                    finally {
                        if (AbstractPerformer.this.isLastInBatch()) {
                            InputOutputReporter cookieObserver = TransformPerformer.this.getCookieObserver();
                            if (cookieObserver != null) {
                                cookieObserver.message(Util.THIS.getString("MSG_transformation_2"));
                                cookieObserver.moveToFront(true);
                            }
                            TransformPerformer.this.active = false;
                        }
                    }
                }
            });
        }

        protected URL preferFileURL(FileObject fileObject) throws MalformedURLException, FileStateInvalidException {
            URL fileURL = null;
            File file = FileUtil.toFile((FileObject)fileObject);
            fileURL = file != null ? file.toURL() : fileObject.getURL();
            return fileURL;
        }

        public final void setLastInBatch(boolean last) {
            this.last = last;
        }

        public final boolean isLastInBatch() {
            return this.last;
        }
    }
}

