/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.EjbJarProjectProperties;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class EjbJarActionProvider
implements ActionProvider {
    private static final String COMMAND_COMPILE = "compile";
    private static final String COMMAND_VERIFY = "verify";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "redeploy", "javadoc", "test", "test.single", "debug.test.single", "debug.fix", "compile", "verify", "delete", "copy", "move", "rename"};
    EjbJarProject project;
    private final AntProjectHelper antProjectHelper;
    private ReferenceHelper refHelper;
    Map commands = new HashMap();
    private static final String SUBST = "Test.java";
    private static final Pattern SRCDIRJAVA = Pattern.compile("\\.java$");

    public EjbJarActionProvider(EjbJarProject project, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
        this.commands.put("build", new String[]{"dist"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"clean", "dist"});
        this.commands.put("compile.single", new String[]{"compile-single"});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("run.single", new String[]{"run-main"});
        this.commands.put("redeploy", new String[]{"run"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put("javadoc", new String[]{"javadoc"});
        this.commands.put("test", new String[]{"test"});
        this.commands.put("test.single", new String[]{"test-single"});
        this.commands.put("debug.test.single", new String[]{"debug-test"});
        this.commands.put("debug.fix", new String[]{"debug-fix"});
        this.commands.put(COMMAND_COMPILE, new String[]{COMMAND_COMPILE});
        this.commands.put(COMMAND_VERIFY, new String[]{COMMAND_VERIFY});
        this.antProjectHelper = antProjectHelper;
        this.project = project;
        this.refHelper = refHelper;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject(this.project.getBuildXmlName());
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public void invokeAction(final String command, final Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(command)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        Runnable action = new Runnable(){

            public void run() {
                Properties p = new Properties();
                String[] targetNames = EjbJarActionProvider.this.getTargetNames(command, context, p);
                if (targetNames == null) {
                    return;
                }
                if (targetNames.length == 0) {
                    targetNames = null;
                }
                if (p.keySet().size() == 0) {
                    p = null;
                }
                try {
                    FileObject buildFo = EjbJarActionProvider.this.findBuildXml();
                    if (buildFo == null || !buildFo.isValid()) {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EjbJarActionProvider.class, (String)"LBL_No_Build_XML_Found"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    } else {
                        ActionUtils.runTarget((FileObject)buildFo, (String[])targetNames, (Properties)p);
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        };
        action.run();
    }

    /*
     * Enabled aggressive block sorting
     */
    String[] getTargetNames(String command, Lookup context, Properties p) throws IllegalArgumentException {
        String[] targetNames = (String[])this.commands.get(command);
        if (command.equals("run.single")) {
            FileObject[] files = this.findTestSources(context, false);
            if (files != null) {
                return this.setupTestSingle(p, files);
            }
            FileObject[] javaFiles = this.findJavaSources(context);
            if (javaFiles == null) return null;
            if (javaFiles.length <= 0) return null;
            FileObject file = javaFiles[0];
            String clazz = FileUtil.getRelativePath((FileObject)this.getRoot(this.project.getSourceRoots().getRoots(), file), (FileObject)file);
            p.setProperty("javac.includes", clazz);
            if (clazz.endsWith(".java")) {
                clazz = clazz.substring(0, clazz.length() - 5);
            }
            clazz = clazz.replace('/', '.');
            if (EjbJarActionProvider.hasMainMethod(file)) {
                p.setProperty("run.class", clazz);
                return (String[])this.commands.get("run.single");
            }
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EjbJarActionProvider.class, (String)"LBL_No_Main_Classs_Found", (Object)clazz), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return null;
        }
        if (command.equals("run") || command.equals("redeploy")) {
            if (!this.isSelectedServer()) {
                return null;
            }
            if (this.isDebugged()) {
                p.setProperty("is.debugged", "true");
            }
            if (command.equals("redeploy")) {
                p.setProperty("forceRedeploy", "true");
                return targetNames;
            }
            p.setProperty("forceRedeploy", "false");
            return targetNames;
        }
        if (command.equals("debug") || command.equals("debug.single")) {
            FileObject[] javaFiles = this.findJavaSources(context);
            if (javaFiles != null && javaFiles.length == 1 && EjbJarActionProvider.hasMainMethod(javaFiles[0])) {
                FileObject javaFile = javaFiles[0];
                String clazz = FileUtil.getRelativePath((FileObject)this.getRoot(this.project.getSourceRoots().getRoots(), javaFile), (FileObject)javaFile);
                p.setProperty("javac.includes", clazz);
                if (clazz.endsWith(".java")) {
                    clazz = clazz.substring(0, clazz.length() - 5);
                }
                clazz = clazz.replace('/', '.');
                p.setProperty("main.class", clazz);
                return new String[]{"debug-single-main"};
            }
            FileObject[] testFiles = this.findTestSources(context, false);
            if (testFiles != null) {
                return this.setupDebugTestSingle(p, testFiles);
            }
            if (!this.isSelectedServer()) {
                return null;
            }
            if (!this.isDebugged()) return targetNames;
            p.setProperty("is.debugged", "true");
            return targetNames;
        }
        if (command.equals("debug.fix")) {
            FileObject[] files = this.findJavaSources(context);
            String path = null;
            if (files != null) {
                path = FileUtil.getRelativePath((FileObject)this.getRoot(this.project.getSourceRoots().getRoots(), files[0]), (FileObject)files[0]);
                targetNames = new String[]{"debug-fix"};
            } else {
                files = this.findTestSources(context, false);
                path = FileUtil.getRelativePath((FileObject)this.getRoot(this.project.getTestSourceRoots().getRoots(), files[0]), (FileObject)files[0]);
                targetNames = new String[]{"debug-fix-test"};
            }
            if (path.endsWith(".java")) {
                path = path.substring(0, path.length() - 5);
            }
            p.setProperty("fix.includes", path);
            return targetNames;
        }
        if (command.equals("compile.single")) {
            boolean recursive;
            FileObject[] sourceRoots = this.project.getSourceRoots().getRoots();
            FileObject[] files = this.findSourcesAndPackages(context, sourceRoots);
            boolean bl = recursive = context.lookup(NonRecursiveFolder.class) == null;
            if (files != null) {
                p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)this.getRoot(sourceRoots, files[0]), (boolean)recursive));
                return targetNames;
            }
            FileObject[] testRoots = this.project.getTestSourceRoots().getRoots();
            files = this.findSourcesAndPackages(context, testRoots);
            p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)this.getRoot(testRoots, files[0]), (boolean)recursive));
            return new String[]{"compile-test-single"};
        }
        if (command.equals("test.single")) {
            FileObject[] files = this.findTestSourcesForSources(context);
            return this.setupTestSingle(p, files);
        }
        if (command.equals("debug.test.single")) {
            FileObject[] files = this.findTestSourcesForSources(context);
            return this.setupDebugTestSingle(p, files);
        }
        if (targetNames != null) return targetNames;
        throw new IllegalArgumentException(command);
    }

    private String[] setupTestSingle(Properties p, FileObject[] files) {
        FileObject[] testSrcPath = this.project.getTestSourceRoots().getRoots();
        FileObject root = this.getRoot(testSrcPath, files[0]);
        p.setProperty("test.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root));
        p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root));
        return new String[]{"test-single"};
    }

    private String[] setupDebugTestSingle(Properties p, FileObject[] files) {
        FileObject[] testSrcPath = this.project.getTestSourceRoots().getRoots();
        FileObject root = this.getRoot(testSrcPath, files[0]);
        String path = FileUtil.getRelativePath((FileObject)root, (FileObject)files[0]);
        p.setProperty("test.class", path.substring(0, path.length() - 5).replace('/', '.'));
        return new String[]{"debug-test"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean hasMainMethod(FileObject fo) {
        if (fo == null) {
            return false;
        }
        boolean has = false;
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            JavaModel.setClassPath((FileObject)fo);
            Resource res = JavaModel.getResource((FileObject)fo);
            assert (res != null) : "Resource found for FileObject " + fo;
            has = !res.getMain().isEmpty();
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
        return has;
    }

    public boolean isActionEnabled(String command, Lookup context) {
        FileObject buildXml = this.findBuildXml();
        if (buildXml == null || !buildXml.isValid()) {
            return false;
        }
        if (command.equals(COMMAND_VERIFY)) {
            return this.project.getEjbModule().hasVerifierSupport();
        }
        if (command.equals("compile.single")) {
            return this.findSourcesAndPackages(context, this.project.getSourceRoots().getRoots()) != null || this.findSourcesAndPackages(context, this.project.getTestSourceRoots().getRoots()) != null;
        }
        if (command.equals("run.single")) {
            FileObject[] javaFiles = this.findTestSources(context, false);
            if (javaFiles != null && javaFiles.length > 0) {
                return true;
            }
            FileObject[] files = this.findJavaSources(context);
            return files != null && files.length == 1;
        }
        if (command.equals("test.single")) {
            return this.findTestSourcesForSources(context) != null;
        }
        if (command.equals("debug.test.single")) {
            FileObject[] files = this.findTestSourcesForSources(context);
            return files != null && files.length == 1;
        }
        if (command.equals("debug.single")) {
            FileObject[] testFiles = this.findTestSources(context, false);
            FileObject[] javaFiles = this.findJavaSources(context);
            return testFiles != null && testFiles.length == 1 || javaFiles != null && javaFiles.length == 1;
        }
        return true;
    }

    private FileObject[] findJavaSources(Lookup context) {
        FileObject[] srcPath = this.project.getSourceRoots().getRoots();
        for (int i = 0; i < srcPath.length; ++i) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcPath[i], (String)".java", (boolean)true);
            if (files == null) continue;
            return files;
        }
        return null;
    }

    private FileObject[] findSourcesAndPackages(Lookup context, FileObject srcDir) {
        if (srcDir != null) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcDir, null, (boolean)true);
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isFolder() || "java".equals(files[i].getExt())) continue;
                    return null;
                }
            }
            return files;
        }
        return null;
    }

    private FileObject[] findSourcesAndPackages(Lookup context, FileObject[] srcRoots) {
        for (int i = 0; i < srcRoots.length; ++i) {
            FileObject[] result = this.findSourcesAndPackages(context, srcRoots[i]);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private FileObject[] findTestSources(Lookup context, boolean checkInSrcDir) {
        FileObject[] files;
        FileObject[] testSrcPath = this.project.getTestSourceRoots().getRoots();
        for (int i = 0; i < testSrcPath.length; ++i) {
            FileObject[] files2 = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)testSrcPath[i], (String)".java", (boolean)true);
            if (files2 == null) continue;
            return files2;
        }
        if (checkInSrcDir && testSrcPath.length > 0 && (files = this.findJavaSources(context)) != null) {
            FileObject srcRoot = this.getRoot(this.project.getSourceRoots().getRoots(), files[0]);
            for (int i = 0; i < testSrcPath.length; ++i) {
                FileObject[] files2 = ActionUtils.regexpMapFiles((FileObject[])files, (FileObject)srcRoot, (Pattern)SRCDIRJAVA, (FileObject)testSrcPath[i], (String)SUBST, (boolean)true);
                if (files2 == null) continue;
                return files2;
            }
        }
        return null;
    }

    private FileObject[] findTestSourcesForSources(Lookup context) {
        FileObject[] sourceFiles = this.findJavaSources(context);
        if (sourceFiles == null) {
            return null;
        }
        FileObject[] testSrcPath = this.project.getTestSourceRoots().getRoots();
        if (testSrcPath.length == 0) {
            return null;
        }
        FileObject[] srcPath = this.project.getSourceRoots().getRoots();
        FileObject srcDir = this.getRoot(srcPath, sourceFiles[0]);
        for (int i = 0; i < testSrcPath.length; ++i) {
            FileObject[] files2 = ActionUtils.regexpMapFiles((FileObject[])sourceFiles, (FileObject)srcDir, (Pattern)SRCDIRJAVA, (FileObject)testSrcPath[i], (String)SUBST, (boolean)true);
            if (files2 == null) continue;
            return files2;
        }
        return null;
    }

    private FileObject getRoot(FileObject[] roots, FileObject file) {
        FileObject srcDir = null;
        for (int i = 0; i < roots.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)roots[i], (FileObject)file) && !roots[i].equals(file)) continue;
            srcDir = roots[i];
            break;
        }
        return srcDir;
    }

    private boolean isDebugged() {
        J2eeModuleProvider jmp = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        ServerDebugInfo sdi = jmp.getServerDebugInfo();
        if (sdi == null) {
            return false;
        }
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessions.length; ++i) {
            Object o;
            Session s = sessions[i];
            if (s == null || (o = s.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            AttachingDICookie attCookie = (AttachingDICookie)o;
            if (!(sdi.getTransport().equals("dt_shmem") ? attCookie.getSharedMemoryName().equalsIgnoreCase(sdi.getShmemName()) : attCookie.getHostName().equalsIgnoreCase(sdi.getHost()) && attCookie.getPortNumber() == sdi.getPort())) continue;
            return true;
        }
        return false;
    }

    private boolean isSelectedServer() {
        String[] servInstIDs;
        String id;
        String instance = this.antProjectHelper.getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        if (instance != null && (id = Deployment.getDefault().getServerID(instance)) != null) {
            return true;
        }
        String serverType = this.antProjectHelper.getStandardPropertyEvaluator().getProperty("j2ee.server.type");
        if (serverType != null && (servInstIDs = Deployment.getDefault().getInstancesOfServer(serverType)).length > 0) {
            this.setServerInstance(servInstIDs[0]);
            return true;
        }
        String msg = NbBundle.getMessage(EjbJarActionProvider.class, (String)"MSG_No_Server_Selected");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
        return false;
    }

    private void setServerInstance(String serverInstanceId) {
        EjbJarProjectProperties.setServerInstance(this.project, this.antProjectHelper, serverInstanceId);
    }
}

