/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarActionProvider;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.SourceRoots;
import org.netbeans.modules.j2ee.ejbjarproject.classpath.EjbJarProjectClassPathExtender;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class EjbJarProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private EjbJarProject project;

    public EjbJarProjectOperations(EjbJarProject project) {
        this.project = project;
    }

    private static void addFile(FileObject projectDirectory, String fileName, List result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList files = new ArrayList();
        EjbJarProjectOperations.addFile(projectDirectory, "nbproject", files);
        EjbJarProjectOperations.addFile(projectDirectory, "build.xml", files);
        EjbJarProjectOperations.addFile(projectDirectory, "catalog.xml", files);
        return files;
    }

    public List getDataFiles() {
        FileObject resourceFO;
        FileObject srcDir;
        FileObject projectDirectory;
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        FileObject metaInf = this.project.getEjbModule().getMetaInf();
        if (metaInf != null) {
            files.add(metaInf);
        }
        SourceRoots src = this.project.getSourceRoots();
        FileObject[] srcRoots = src.getRoots();
        for (int cntr = 0; cntr < srcRoots.length; ++cntr) {
            files.add(srcRoots[cntr]);
        }
        PropertyEvaluator evaluator = this.project.evaluator();
        String prop = evaluator.getProperty("source.root");
        if (prop != null && (projectDirectory = this.project.getProjectDirectory()) != (srcDir = this.project.getAntProjectHelper().resolveFileObject(prop)) && !files.contains(srcDir)) {
            files.add(srcDir);
        }
        SourceRoots test = this.project.getTestSourceRoots();
        FileObject[] testRoots = test.getRoots();
        for (int cntr = 0; cntr < testRoots.length; ++cntr) {
            files.add(testRoots[cntr]);
        }
        File resourceDir = this.project.getEjbModule().getEnterpriseResourceDirectory();
        if (resourceDir != null && (resourceFO = FileUtil.toFileObject((File)resourceDir)) != null) {
            files.add(resourceFO);
        }
        return files;
    }

    public void notifyDeleting() throws IOException {
        EjbJarActionProvider ap = (EjbJarActionProvider)this.project.getLookup().lookup(EjbJarActionProvider.class);
        assert (ap != null);
        Lookup context = Lookups.fixed((Object[])new Object[0]);
        Properties p = new Properties();
        String[] targetNames = ap.getTargetNames("clean", context, p);
        FileObject buildXML = this.project.getProjectDirectory().getFileObject("build.xml");
        assert (targetNames != null);
        assert (targetNames.length > 0);
        ActionUtils.runTarget((FileObject)buildXML, (String[])targetNames, (Properties)p).waitFinished();
        EjbJarProjectClassPathExtender extender = (EjbJarProjectClassPathExtender)this.project.getLookup().lookup(EjbJarProjectClassPathExtender.class);
        extender.notifyDeleting();
    }

    public void notifyDeleted() throws IOException {
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
    }

    public void notifyCopied(Project original, File originalPath, String nueName) {
        if (original == null) {
            return;
        }
        this.project.getReferenceHelper().fixReferences(originalPath);
        this.fixOtherReferences(originalPath);
        this.project.setName(nueName);
    }

    public void notifyMoving() throws IOException {
        this.notifyDeleting();
    }

    public void notifyMoved(Project original, File originalPath, final String newName) {
        if (original == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        final String oldProjectName = this.project.getName();
        this.project.setName(newName);
        this.project.getReferenceHelper().fixReferences(originalPath);
        this.fixOtherReferences(originalPath);
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                AntProjectHelper helper = EjbJarProjectOperations.this.project.getAntProjectHelper();
                EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
                String jarName = (String)projectProps.get((Object)"jar.name");
                String oldName = jarName.substring(0, jarName.length() - 4);
                if (jarName.endsWith(".jar") && oldName.equals(oldProjectName)) {
                    projectProps.put((Object)"jar.name", (Object)(newName + ".jar"));
                }
                helper.putProperties("nbproject/project.properties", projectProps);
            }
        });
    }

    private void fixOtherReferences(final File originalPath) {
        String property = "meta.inf";
        final File projectDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                EditableProperties props = EjbJarProjectOperations.this.project.getAntProjectHelper().getProperties("nbproject/project.properties");
                String path = props.getProperty("meta.inf");
                if (path == null) {
                    return;
                }
                if (path.startsWith(originalPath.getAbsolutePath())) {
                    String relative = PropertyUtils.relativizeFile((File)originalPath, (File)new File(path));
                    String fixedPath = new File(projectDir, relative).getAbsolutePath();
                    props.setProperty("meta.inf", fixedPath);
                    EjbJarProjectOperations.this.project.getAntProjectHelper().putProperties("nbproject/project.properties", props);
                }
            }
        });
    }

    private static boolean isParent(File folder, File fo) {
        if (folder.equals(fo)) {
            return false;
        }
        while (fo != null) {
            if (fo.equals(folder)) {
                return true;
            }
            fo = fo.getParentFile();
        }
        return false;
    }
}

