/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.webservices.DDProvider;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.deployment.common.api.EjbChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.classpath.ClassPathProviderImpl;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.EjbJarProjectProperties;
import org.netbeans.modules.j2ee.metadata.ClassPathSupport;
import org.netbeans.modules.j2ee.metadata.MetadataUnit;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarImplementation;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class EjbJarProvider
extends J2eeModuleProvider
implements EjbJarImplementation,
J2eeModule,
ModuleChangeReporter,
EjbChangeDescriptor,
PropertyChangeListener {
    public static final String FILE_DD = "ejb-jar.xml";
    private final EjbJarProject project;
    private final AntProjectHelper helper;
    private Set versionListeners;
    private MetadataUnit metadataUnit;
    private ClassPath metadataClassPath;
    private long notificationTimeout = 0L;

    EjbJarProvider(EjbJarProject project, AntProjectHelper helper) {
        this.project = project;
        this.helper = helper;
        project.evaluator().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public FileObject getDeploymentDescriptor() {
        FileObject ddFO = null;
        FileObject metaInfFo = this.getMetaInf();
        if (metaInfFo != null) {
            ddFO = metaInfFo.getFileObject(FILE_DD);
        }
        if (ddFO != null || !"1.5".equals(this.getJ2eePlatformVersion())) {
            // empty if block
        }
        return ddFO;
    }

    public ClassPath getClassPath() {
        ClassPathProvider cpp = (ClassPathProvider)this.project.getLookup().lookup(ClassPathProvider.class);
        if (cpp != null) {
            return cpp.findClassPath(this.getFileObject("src.dir"), "classpath/source");
        }
        return null;
    }

    public FileObject[] getJavaSources() {
        return this.project.getSourceRoots().getRoots();
    }

    public FileObject getMetaInf() {
        String version;
        FileObject metaInf = this.getFileObject("meta.inf");
        if (metaInf == null && EjbJarProvider.needConfigurationFolder(version = this.project.getAPIEjbJar().getJ2eePlatformVersion())) {
            String relativePath = this.helper.getStandardPropertyEvaluator().getProperty("meta.inf");
            String path = relativePath != null ? this.helper.resolvePath(relativePath) : "";
            this.showErrorMessage(NbBundle.getMessage(EjbJarProvider.class, (String)"MSG_MetaInfCorrupted", (Object)this.project.getName(), (Object)path));
        }
        return metaInf;
    }

    static boolean needConfigurationFolder(String version) {
        return "1.3".equals(version) || "1.4".equals(version);
    }

    public File getMetaInfAsFile() {
        return this.getFile("meta.inf");
    }

    public File getEnterpriseResourceDirectory() {
        return this.getFile("resource.dir");
    }

    public FileObject findDeploymentConfigurationFile(String name) {
        FileObject metaInf = this.getMetaInf();
        if (metaInf == null) {
            return null;
        }
        return metaInf.getFileObject(name);
    }

    public File getDeploymentConfigurationFile(String name) {
        return new File(this.getMetaInfAsFile(), name);
    }

    public ClassPathProvider getClassPathProvider() {
        return (ClassPathProvider)this.project.getLookup().lookup(ClassPathProvider.class);
    }

    public FileObject getArchive() {
        return this.getFileObject("dist.jar");
    }

    private FileObject getFileObject(String propname) {
        String prop = this.helper.getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return this.helper.resolveFileObject(prop);
        }
        return null;
    }

    private File getFile(String propname) {
        String prop = this.helper.getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return this.helper.resolveFile(prop);
        }
        return null;
    }

    public J2eeModule getJ2eeModule() {
        return this;
    }

    public ModuleChangeReporter getModuleChangeReporter() {
        return this;
    }

    public boolean useDefaultServer() {
        return false;
    }

    public String getServerID() {
        return this.helper.getStandardPropertyEvaluator().getProperty("j2ee.server.type");
    }

    public String getServerInstanceID() {
        return this.helper.getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
    }

    public void setServerInstanceID(String serverInstanceID) {
        assert (serverInstanceID != null) : "passed serverInstanceID cannot be null";
        EjbJarProjectProperties.setServerInstance(this.project, this.helper, serverInstanceID);
    }

    public Iterator getArchiveContents() throws IOException {
        return new IT(this.getContentDirectory());
    }

    public FileObject getContentDirectory() {
        return this.getFileObject("build.classes.dir");
    }

    public FileObject getBuildDirectory() {
        return this.getFileObject("build.dir");
    }

    public File getContentDirectoryAsFile() {
        return this.getFile("build.classes.dir");
    }

    public BaseBean getDeploymentDescriptor(String location) {
        Webservices webServices;
        if ("META-INF/ejb-jar.xml".equals(location)) {
            EjbJar ejbJar = this.getEjbJar();
            if (ejbJar != null) {
                return org.netbeans.modules.j2ee.dd.api.ejb.DDProvider.getDefault().getBaseBean((CommonDDBean)ejbJar);
            }
        } else if ("META-INF/webservices.xml".equals(location) && (webServices = this.getWebservices()) != null) {
            return DDProvider.getDefault().getBaseBean((CommonDDBean)webServices);
        }
        return null;
    }

    private EjbJar getEjbJar() {
        try {
            org.netbeans.modules.j2ee.api.ejbjar.EjbJar apiEjbJar = this.project.getAPIEjbJar();
            if (apiEjbJar.getDeploymentDescriptor() == null && !"1.5".equals(apiEjbJar.getJ2eePlatformVersion())) {
                return null;
            }
            return org.netbeans.modules.j2ee.dd.api.ejb.DDProvider.getDefault().getMergedDDRoot(apiEjbJar.getMetadataUnit());
        }
        catch (IOException e) {
            ErrorManager.getDefault().log(e.getLocalizedMessage());
            return null;
        }
    }

    private Webservices getWebservices() {
        if (Util.isJavaEE5orHigher((Project)this.project)) {
            WebServicesSupport wss = WebServicesSupport.getWebServicesSupport((FileObject)this.project.getProjectDirectory());
            try {
                return DDProvider.getDefault().getMergedDDRoot((MetadataUnit)wss);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        } else {
            FileObject wsdd = this.getDD();
            if (wsdd != null) {
                try {
                    return DDProvider.getDefault().getDDRoot(wsdd);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().log(e.getLocalizedMessage());
                }
            }
        }
        return null;
    }

    public FileObject getDD() {
        FileObject metaInfFo = this.getMetaInf();
        if (metaInfFo == null) {
            return null;
        }
        return metaInfFo.getFileObject("webservices", "xml");
    }

    public EjbChangeDescriptor getEjbChanges(long timestamp) {
        return this;
    }

    public Object getModuleType() {
        return J2eeModule.EJB;
    }

    public String getModuleVersion() {
        EjbJar ejbJar = this.getEjbJar();
        return ejbJar == null ? "2.1" : ejbJar.getVersion().toString();
    }

    private Set versionListeners() {
        if (this.versionListeners == null) {
            this.versionListeners = new HashSet();
            EjbJar ejbJar = this.getEjbJar();
            if (ejbJar != null) {
                PropertyChangeListener l = (PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)ejbJar);
                ejbJar.addPropertyChangeListener(l);
            }
        }
        return this.versionListeners;
    }

    public void addVersionListener(J2eeModule.VersionListener vl) {
        this.versionListeners().add(vl);
    }

    public void removeVersionListener(J2eeModule.VersionListener vl) {
        if (this.versionListeners != null) {
            this.versionListeners.remove(vl);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dd_version")) {
            for (J2eeModule.VersionListener vl : this.versionListeners) {
                String oldVersion = (String)evt.getOldValue();
                String newVersion = (String)evt.getNewValue();
                vl.versionChanged(oldVersion, newVersion);
            }
        } else if (evt.getPropertyName().equals("j2ee.server.instance")) {
            Deployment d = Deployment.getDefault();
            String oldServerID = evt.getOldValue() == null ? null : d.getServerID((String)evt.getOldValue());
            String newServerID = evt.getNewValue() == null ? null : d.getServerID((String)evt.getNewValue());
            this.fireServerChange(oldServerID, newServerID);
        } else if ("resource.dir".equals(evt.getPropertyName())) {
            String oldValue = (String)evt.getOldValue();
            String newValue = (String)evt.getNewValue();
            this.firePropertyChange("resourceDir", oldValue == null ? null : new File(oldValue), newValue == null ? null : new File(newValue));
        }
    }

    public String getUrl() {
        EditableProperties ep = this.helper.getProperties("nbproject/project.properties");
        String name = ep.getProperty("jar.name");
        return name == null ? "" : '/' + name;
    }

    public boolean isManifestChanged(long timestamp) {
        return false;
    }

    public void setUrl(String url) {
        throw new UnsupportedOperationException("Cannot customize URL of EJB module");
    }

    public boolean ejbsChanged() {
        return false;
    }

    public String[] getChangedEjbs() {
        return new String[0];
    }

    public String getJ2eePlatformVersion() {
        return this.helper.getStandardPropertyEvaluator().getProperty("j2ee.platform");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataUnit getMetadataUnit() {
        EjbJarProvider ejbJarProvider = this;
        synchronized (ejbJarProvider) {
            if (this.metadataUnit == null) {
                this.metadataUnit = new MetadataUnitImpl();
            }
            return this.metadataUnit;
        }
    }

    public FileObject[] getSourceRoots() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        LinkedList<FileObject> roots = new LinkedList<FileObject>();
        FileObject metaInf = this.getMetaInf();
        if (metaInf != null) {
            roots.add(metaInf);
        }
        for (int i = 0; i < groups.length; ++i) {
            roots.add(groups[i].getRootFolder());
        }
        FileObject[] rootArray = new FileObject[roots.size()];
        return roots.toArray(rootArray);
    }

    private void showErrorMessage(final String message) {
        if (new Date().getTime() > this.notificationTimeout && this.isProjectOpen()) {
            Runnable r = new Runnable(){

                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                    }
                }
            };
            r.run();
            this.notificationTimeout = new Date().getTime() + 20000L;
        }
    }

    private boolean isProjectOpen() {
        if (OpenProjects.getDefault() != null) {
            Project[] projects = OpenProjects.getDefault().getOpenProjects();
            for (int i = 0; i < projects.length; ++i) {
                if (!projects[i].equals(this.project)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getMetadataClassPath() {
        EjbJarProvider ejbJarProvider = this;
        synchronized (ejbJarProvider) {
            if (this.metadataClassPath == null) {
                ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)this.project.getLookup().lookup(ClassPathProviderImpl.class);
                this.metadataClassPath = ClassPathSupport.createWeakProxyClassPath((ClassPath[])new ClassPath[]{cpProvider.getProjectSourcesClassPath("classpath/source"), cpProvider.getJ2eePlatformClassPath()});
            }
            return this.metadataClassPath;
        }
    }

    private static final class FSRootRE
    implements J2eeModule.RootedEntry {
        FileObject f;
        FileObject root;

        FSRootRE(FileObject root, FileObject f) {
            this.f = f;
            this.root = root;
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public String getRelativePath() {
            return FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.f);
        }
    }

    private static class IT
    implements Iterator {
        Enumeration ch;
        FileObject root;

        private IT(FileObject f) {
            this.ch = f.getChildren(true);
            this.root = f;
        }

        public boolean hasNext() {
            return this.ch.hasMoreElements();
        }

        public Object next() {
            FileObject f = (FileObject)this.ch.nextElement();
            return new FSRootRE(this.root, f);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MetadataUnitImpl
    implements MetadataUnit {
        private MetadataUnitImpl() {
        }

        public ClassPath getClassPath() {
            return EjbJarProvider.this.getMetadataClassPath();
        }

        public FileObject getDeploymentDescriptor() {
            return EjbJarProvider.this.getDeploymentDescriptor();
        }
    }
}

