/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.properties.PropertiesTableModel;
import org.netbeans.modules.properties.TableViewSettings;
import org.openide.util.NbBundle;

public class PropertiesTableCellEditor
extends DefaultCellEditor {
    private boolean isKeyCell;
    static final long serialVersionUID = -5292598860635851664L;
    private DocumentListener listener;
    private JTextComponent valueComponent;
    private JTextComponent commentComponent;
    private final TableViewSettings settings;
    static /* synthetic */ Class class$org$netbeans$modules$properties$PropertyPanel;
    static /* synthetic */ Class class$org$netbeans$modules$properties$BundleEditPanel;

    public PropertiesTableCellEditor(JTextField tf, JTextComponent commentComponent, JTextComponent valueComponent, JLabel valueLabel, DocumentListener listener) {
        super(tf);
        this.clickCountToStart = 1;
        this.listener = listener;
        this.valueComponent = valueComponent;
        this.commentComponent = commentComponent;
        valueComponent.setDocument(tf.getDocument());
        this.delegate = new PropertiesEditorDelegate(commentComponent, valueComponent, valueLabel);
        ((JTextField)this.editorComponent).addActionListener(this.delegate);
        this.settings = TableViewSettings.getDefault();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.isKeyCell = column == 0;
        this.valueComponent.getDocument().removeDocumentListener(this.listener);
        this.commentComponent.getDocument().removeDocumentListener(this.listener);
        JTextField textField = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        this.valueComponent.getDocument().addDocumentListener(this.listener);
        this.commentComponent.getDocument().addDocumentListener(this.listener);
        Caret caret = textField.getCaret();
        caret.setVisible(true);
        caret.setDot(0);
        textField.setFont(this.settings.getFont());
        int[] result = (int[])table.getClientProperty("table.search.result");
        if (result != null && row == result[0] && column == result[1]) {
            table.putClientProperty("table.search.result", null);
            caret.setDot(result[2]);
            caret.moveDot(result[3]);
        }
        return textField;
    }

    private class PropertiesEditorDelegate
    extends DefaultCellEditor.EditorDelegate {
        JTextComponent commentComponent;
        JTextComponent valueComponent;
        JLabel valueLabel;
        static final long serialVersionUID = 9082979978712223677L;

        public PropertiesEditorDelegate(JTextComponent commentComponent, JTextComponent valueComponent, JLabel valueLabel) {
            super(PropertiesTableCellEditor.this);
            this.commentComponent = commentComponent;
            this.valueComponent = valueComponent;
            this.valueLabel = valueLabel;
        }

        public void setValue(Object x) {
            this.value = x;
            PropertiesTableModel.StringPair sp = (PropertiesTableModel.StringPair)x;
            if (sp != null) {
                ((JTextField)PropertiesTableCellEditor.this.getComponent()).setText(sp.getValue());
                this.commentComponent.setText(sp.getComment());
            } else {
                ((JTextField)PropertiesTableCellEditor.this.getComponent()).setText("");
                this.commentComponent.setText("");
            }
        }

        public Object getCellEditorValue() {
            String value = ((JTextField)PropertiesTableCellEditor.this.getComponent()).getText();
            if (PropertiesTableCellEditor.this.isKeyCell) {
                this.valueLabel.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$PropertyPanel == null ? (class$org$netbeans$modules$properties$PropertyPanel = PropertiesTableCellEditor.class$("org.netbeans.modules.properties.PropertyPanel")) : class$org$netbeans$modules$properties$PropertyPanel)).getString("LBL_KeyLabel"));
                this.valueLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$BundleEditPanel == null ? (class$org$netbeans$modules$properties$BundleEditPanel = PropertiesTableCellEditor.class$("org.netbeans.modules.properties.BundleEditPanel")) : class$org$netbeans$modules$properties$BundleEditPanel)).getString("LBL_KeyLabel_Mnem").charAt(0));
            } else {
                this.valueLabel.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$BundleEditPanel == null ? (class$org$netbeans$modules$properties$BundleEditPanel = PropertiesTableCellEditor.class$("org.netbeans.modules.properties.BundleEditPanel")) : class$org$netbeans$modules$properties$BundleEditPanel)).getString("LBL_ValueLabel"));
                this.valueLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$BundleEditPanel == null ? (class$org$netbeans$modules$properties$BundleEditPanel = PropertiesTableCellEditor.class$("org.netbeans.modules.properties.BundleEditPanel")) : class$org$netbeans$modules$properties$BundleEditPanel)).getString("LBL_ValueLabel_Mnem").charAt(0));
            }
            return new PropertiesTableModel.StringPair(this.commentComponent.getText(), value, PropertiesTableCellEditor.this.isKeyCell);
        }
    }
}

