/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderList;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

final class FolderChildren
extends Children.Keys
implements PropertyChangeListener,
ChangeListener {
    private DataFolder folder;
    private final DataFilter filter;
    private PropertyChangeListener listener;
    private ErrorManager err;
    private boolean refresh;
    private RequestProcessor.Task refreshTask;
    private ChildrenRefreshRunnable refreshRunnable;
    private static RequestProcessor refRP = new RequestProcessor("FolderChildren_Refresh");
    static /* synthetic */ Class class$org$openide$loaders$FolderChildren;

    public FolderChildren(DataFolder f) {
        this(f, DataFilter.ALL);
    }

    public FolderChildren(DataFolder f, DataFilter filter) {
        this.folder = f;
        this.filter = filter;
        this.refreshRunnable = new ChildrenRefreshRunnable();
        this.refreshTask = refRP.create((Runnable)this.refreshRunnable);
        this.listener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.folder);
        this.err = ErrorManager.getDefault().getInstance("org.openide.loaders.FolderChildren." + f.getPrimaryFile().getPath().replace('/', '.'));
        if (!this.err.isLoggable(1)) {
            this.err = null;
        }
    }

    DataFilter getFilter() {
        return this.filter;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if ("children".equals(ev.getPropertyName())) {
            if (this.err != null) {
                this.err.log("Got PROP_CHILDREN");
            }
            this.refreshChildren().schedule(0);
            this.postClearTask();
            return;
        }
        if ("sortMode".equals(ev.getPropertyName()) || "order".equals(ev.getPropertyName())) {
            if (this.err != null) {
                this.err.log("Got PROP_SORT_MODE or PROP_ORDER");
            }
            this.refreshChildren().schedule(0);
            this.postClearTask();
            return;
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.refresh = true;
        this.refreshChildren().schedule(0);
        this.postClearTask();
    }

    private void postClearTask() {
        refRP.post(new Runnable(){

            public void run() {
                FolderChildren.this.refreshRunnable.clear();
            }
        });
    }

    RequestProcessor.Task refreshChildren() {
        return this.refreshTask;
    }

    protected Node[] createNodes(Object key) {
        if (this.err != null) {
            this.err.log("createNodes: " + key);
        }
        FileObject fo = ((Pair)key).primaryFile;
        try {
            DataObject obj = DataObject.find(fo);
            if (this.filter == null || this.filter.acceptDataObject(obj)) {
                return new Node[]{obj.getClonedNodeDelegate(this.filter)};
            }
            return new Node[0];
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return new Node[0];
        }
    }

    public Node[] getNodes(boolean optimalResult) {
        Node[] res;
        if (optimalResult) {
            if (FolderChildren.checkChildrenMutex()) {
                FolderList.find(this.folder.getPrimaryFile(), true).waitProcessingFinished();
                RequestProcessor.Task task = this.refreshChildren();
                res = this.getNodes();
                task.schedule(0);
                task.waitFinished();
            } else {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("getNodes(true) called while holding the Children.MUTEX"));
            }
        }
        res = this.getNodes();
        this.postClearTask();
        return res;
    }

    public Node findChild(String name) {
        if (FolderChildren.checkChildrenMutex()) {
            this.getNodes(true);
        }
        return super.findChild(name);
    }

    static boolean checkChildrenMutex() {
        return !Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess();
    }

    protected void addNotify() {
        if (this.err != null) {
            this.err.log("addNotify begin");
        }
        this.folder.addPropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).addChangeListener(this);
        }
        this.refreshChildren().schedule(0);
        if (this.err != null) {
            this.err.log("addNotify end");
        }
    }

    protected void removeNotify() {
        if (this.err != null) {
            this.err.log("removeNotify begin");
        }
        this.folder.removePropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).removeChangeListener(this);
        }
        this.setKeys(Collections.EMPTY_LIST);
        if (this.err != null) {
            this.err.log("removeNotify end");
        }
    }

    public String toString() {
        return this.folder != null ? this.folder.getPrimaryFile().toString() : super.toString();
    }

    private static final class Pair {
        public FileObject primaryFile;
        public int seq;

        public Pair(FileObject primaryFile) {
            this.primaryFile = primaryFile;
            this.seq = DataObjectPool.getPOOL().registrationCount(primaryFile);
        }

        public int hashCode() {
            return this.primaryFile.hashCode() ^ this.seq;
        }

        public boolean equals(Object o) {
            if (o instanceof Pair) {
                Pair p = (Pair)o;
                return this.primaryFile.equals(p.primaryFile) && this.seq == p.seq;
            }
            return false;
        }

        public String toString() {
            return "FolderChildren.Pair[" + this.primaryFile + "," + this.seq + "]";
        }
    }

    private final class ChildrenRefreshRunnable
    implements Runnable {
        private DataObject[] ch;
        static final /* synthetic */ boolean $assertionsDisabled;

        private ChildrenRefreshRunnable() {
        }

        public void run() {
            int i;
            if (!$assertionsDisabled && !refRP.isRequestProcessorThread()) {
                throw new AssertionError();
            }
            FolderList.find(FolderChildren.this.folder.getPrimaryFile(), true).waitProcessingFinished();
            this.ch = FolderChildren.this.folder.getChildren();
            if (FolderChildren.this.err != null) {
                FolderChildren.this.err.log("Children computed");
            }
            Object[] keys = new Object[this.ch.length];
            for (i = 0; i < keys.length; ++i) {
                keys[i] = new Pair(this.ch[i].getPrimaryFile());
            }
            FolderChildren.this.setKeys(Arrays.asList(keys));
            if (FolderChildren.this.refresh) {
                FolderChildren.this.refresh = false;
                for (i = 0; i < keys.length; ++i) {
                    FolderChildren.this.refreshKey(keys[i]);
                }
            }
            if (!FolderChildren.this.isInitialized()) {
                this.clear();
            }
        }

        public void clear() {
            if (!$assertionsDisabled && !refRP.isRequestProcessorThread()) {
                throw new AssertionError();
            }
            if (FolderChildren.this.err != null) {
                FolderChildren.this.err.log("Clearing the reference to children");
            }
            this.ch = null;
        }

        static {
            $assertionsDisabled = !(class$org$openide$loaders$FolderChildren == null ? (class$org$openide$loaders$FolderChildren = FolderChildren.class$("org.openide.loaders.FolderChildren")) : class$org$openide$loaders$FolderChildren).desiredAssertionStatus();
        }
    }
}

