/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageClient;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.StoragePersistentDataException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.persistence.memoryimpl.SinglevaluedIndexImpl;
import org.netbeans.mdr.persistence.memoryimpl.StorageImpl;
import org.netbeans.mdr.persistence.memoryimpl.TransactionLog;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.Logger;

public class PrimaryIndexImpl
extends SinglevaluedIndexImpl {
    private ByteArrayOutputStream baoStrm = new ByteArrayOutputStream();
    private DataOutputStream daoStrm = new DataOutputStream(this.baoStrm);

    public PrimaryIndexImpl(StorageImpl storage) {
        super("PI", storage, Storage.EntryType.MOFID, Storage.EntryType.STREAMABLE);
    }

    public synchronized boolean remove(Object key) throws StorageException {
        Object original = this.table.remove(key);
        if (original != null) {
            PrimaryValueLog valueLog = this.transLog.isLogged(key) ? null : this.createValueLog((Streamable)original);
            this.transLog.logRemove(key, valueLog);
            return true;
        }
        return false;
    }

    public synchronized boolean put(Object key, Object value) throws StorageException {
        Object original = this.table.put(key, value);
        if (original == null) {
            this.transLog.logAdd(key);
        } else {
            PrimaryValueLog valueLog = this.transLog.isLogged(key) ? null : this.createValueLog((Streamable)original);
            this.transLog.logReplace(key, valueLog);
        }
        return original != null;
    }

    public synchronized void replace(Object key, Object value) throws StorageException, StorageBadRequestException {
        Object original = this.table.put(key, value);
        if (original == null) {
            this.table.remove(key);
            throw new StorageBadRequestException("Cannot replace item that does not exist in the index.");
        }
        PrimaryValueLog valueLog = this.transLog.isLogged(key) ? null : this.createValueLog((Streamable)original);
        this.transLog.logReplace(key, valueLog);
    }

    public synchronized void willChange(Object key) throws StorageException {
        if (!this.transLog.isLogged(key)) {
            Object value = this.table.get(key);
            this.transLog.logValue(key, this.createValueLog((Streamable)value));
        }
        this.transLog.setDirty(key);
    }

    public void changed(Object key) {
    }

    private PrimaryValueLog createValueLog(Streamable value) throws StorageException {
        this.baoStrm.reset();
        try {
            value.write(this.daoStrm);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return new PrimaryValueLog(this.baoStrm.toByteArray(), value);
    }

    public void write(OutputStream out) throws StorageException {
        try {
            IOUtils.writeInt(out, this.table.size());
            for (Map.Entry entry : this.table.entrySet()) {
                this.storage.writeMOFID(out, (MOFID)entry.getKey());
                Streamable value = (Streamable)entry.getValue();
                IOUtils.writeString(out, value.getClass().getName());
                value.write(out);
            }
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
    }

    public void read(InputStream is) throws StorageException {
        try {
            int size = IOUtils.readInt(is);
            this.table = new HashMap(size * 4 / 3);
            for (int i = 0; i < size; ++i) {
                MOFID key = this.storage.readMOFID(is);
                Streamable value = (Streamable)Class.forName(IOUtils.readString(is)).newInstance();
                if (value instanceof StorageClient) {
                    ((StorageClient)((Object)value)).setStorage(this.storage);
                }
                value.read(is);
                this.table.put(key, value);
            }
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
        catch (Exception e) {
            throw (StorageException)Logger.getDefault().annotate((Throwable)new StoragePersistentDataException(), (Throwable)e);
        }
    }

    private class PrimaryValueLog
    implements TransactionLog.ValueLog {
        private byte[] bytes;
        private Streamable obj;

        PrimaryValueLog(byte[] bytes, Streamable obj) {
            this.bytes = bytes;
            this.obj = obj;
        }

        public Object resolveOriginalValue() throws StorageException {
            ByteArrayInputStream baiStrm = new ByteArrayInputStream(this.bytes);
            DataInputStream daiStrm = new DataInputStream(baiStrm);
            if (this.obj instanceof StorageClient) {
                ((StorageClient)((Object)this.obj)).setStorage(PrimaryIndexImpl.this.storage);
            }
            this.obj.read(daiStrm);
            return this.obj;
        }
    }
}

