/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jmi.reflect.InvalidCallException;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.PackageProxyHandler;
import org.netbeans.mdr.handlers.gen.TagSupport;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.storagemodel.CachedCollection;
import org.netbeans.mdr.storagemodel.DatatypeDescriptor;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableAssociation;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.Logger;

public class StorablePackage
extends StorableBaseObject
implements Streamable {
    private String context;
    private Map packageProxies;
    private Map assocProxies;
    private Map classProxies;
    private Map datatypes;
    private Class packageSuperclass = null;

    protected void replaceValues(Map table) {
        this.objectWillChange();
        super.replaceValues(table);
        this.objectChanged();
    }

    public StorablePackage() {
    }

    public StorablePackage(MdrStorage mdrStorage, MOFID packageId, MOFID metaId, String mofContext, Map datatypes, String storageId) throws StorageException {
        super(mdrStorage, packageId, metaId, storageId);
        this.objectWillChange();
        this.packageProxies = new HashMap();
        this.assocProxies = new HashMap();
        this.classProxies = new HashMap();
        this.datatypes = datatypes;
        this.getMdrStorage().addObject(this);
        if (packageId == null && mofContext != null) {
            this.context = mofContext;
            this.getMdrStorage().createContext(mofContext, this.getMofId());
        } else {
            this.context = null;
        }
        this.initFinished = true;
        this.objectChanged();
    }

    public StorablePackage(MdrStorage mdrStorage, MOFID packageId, MOFID metaId, String mofContext, Map datatypes) throws StorageException {
        this(mdrStorage, packageId, metaId, mofContext, datatypes, null);
    }

    public synchronized Class getPackageSuperclass() throws StorageException, ClassNotFoundException {
        this.objectWillChange();
        this.packageSuperclass = this.resolvePackageSuperclass();
        this.objectChanged();
        return this.packageSuperclass;
    }

    private Class resolvePackageSuperclass() throws StorageException, ClassNotFoundException {
        try {
            return BaseObjectHandler.resolveImplementation(TagSupport.getImplFullName(this.getMetaObject(), 3));
        }
        catch (ClassNotFoundException e) {
            return PackageProxyHandler.class;
        }
    }

    public Class getPackageCustomImpl() {
        try {
            Class sup = this.getPackageSuperclass();
            return sup == PackageProxyHandler.class ? null : sup;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void clusterPackage(String clusteredMetaName, MOFID clusteredId) throws StorageException {
        this.addPackage(clusteredMetaName, clusteredId);
    }

    public void addPackage(String metaName, MOFID mofId) {
        this.objectWillChange();
        this.packageProxies.put(metaName, mofId);
        this.objectChanged();
    }

    public void addClass(String metaName, MOFID mofId) {
        this.objectWillChange();
        this.classProxies.put(metaName, mofId);
        this.objectChanged();
    }

    public void addAssociation(String metaName, MOFID mofId) {
        this.objectWillChange();
        this.assocProxies.put(metaName, mofId);
        this.objectChanged();
    }

    public StorablePackage getPackage(String metaName) throws StorageException {
        return (StorablePackage)this.getMdrStorage().getObject((MOFID)this.packageProxies.get(metaName));
    }

    public StorableClass getClassProxy(String metaName) throws StorageException {
        return (StorableClass)this.getMdrStorage().getObject((MOFID)this.classProxies.get(metaName));
    }

    public StorableAssociation getAssociation(String metaName) throws StorageException {
        return (StorableAssociation)this.getMdrStorage().getObject((MOFID)this.assocProxies.get(metaName));
    }

    public Collection getAllPackages() throws StorageException {
        return new CachedCollection(this.getMdrStorage(), this.packageProxies.values());
    }

    public Collection getAllClasses() throws StorageException {
        return new CachedCollection(this.getMdrStorage(), this.classProxies.values());
    }

    public Collection getAllAssociations() throws StorageException {
        return new CachedCollection(this.getMdrStorage(), this.assocProxies.values());
    }

    public String getContext() {
        return this.context;
    }

    public DatatypeDescriptor getDatatypeDesc(String name) {
        return (DatatypeDescriptor)this.datatypes.get(name);
    }

    public void delete() throws StorageException {
        if (this.getImmediatePackageId() != null) {
            throw new InvalidCallException((Object)this.getMdrStorage().getRepository().getHandler(this), null, "Not an outermost package.");
        }
        this.getMdrStorage().dropContext(this.context, this.getMofId());
        this.deleteRecursive();
    }

    protected void deleteRecursive() throws StorageException {
        Iterator it = this.packageProxies.values().iterator();
        while (it.hasNext()) {
            StorablePackage sp;
            try {
                sp = (StorablePackage)this.getMdrStorage().getObject((MOFID)it.next());
            }
            catch (StorageBadRequestException e) {
                sp = null;
            }
            if (sp == null) continue;
            sp.deleteRecursive();
        }
        it = this.classProxies.values().iterator();
        while (it.hasNext()) {
            StorableClass sc = (StorableClass)this.getMdrStorage().getObject((MOFID)it.next());
            sc.deleteRecursive();
        }
        it = this.assocProxies.values().iterator();
        while (it.hasNext()) {
            StorableAssociation sa = (StorableAssociation)this.getMdrStorage().getObject((MOFID)it.next());
            sa.deleteRecursive();
        }
        this.packageProxies.clear();
        this.classProxies.clear();
        this.assocProxies.clear();
        super.deleteRecursive();
    }

    public void write(OutputStream outputStream) {
        super.write(outputStream);
        try {
            IOUtils.write(outputStream, this.meta, this);
            IOUtils.write(outputStream, this.immediatePackage, this);
            IOUtils.writeString(outputStream, this.context);
            IOUtils.write(outputStream, this.packageProxies, this);
            IOUtils.write(outputStream, this.classProxies, this);
            IOUtils.write(outputStream, this.assocProxies, this);
            IOUtils.writeInt(outputStream, this.datatypes.size());
            for (String name : this.datatypes.keySet()) {
                IOUtils.writeString(outputStream, name);
                ((DatatypeDescriptor)this.datatypes.get(name)).write(outputStream);
            }
        }
        catch (IOException e) {
            Logger.getDefault().notify(1, (Throwable)e);
        }
    }

    public void read(InputStream inputStream) {
        super.read(inputStream);
        try {
            this.meta = (MOFID)IOUtils.read(inputStream, this);
            this.immediatePackage = (MOFID)IOUtils.read(inputStream, this);
            this.context = IOUtils.readString(inputStream);
            this.packageProxies = (Map)IOUtils.read(inputStream, this);
            this.classProxies = (Map)IOUtils.read(inputStream, this);
            this.assocProxies = (Map)IOUtils.read(inputStream, this);
            int count = IOUtils.readInt(inputStream);
            this.datatypes = new HashMap(count, 1.0f);
            for (int i = 0; i < count; ++i) {
                String name = IOUtils.readString(inputStream);
                this.datatypes.put(name, DatatypeDescriptor.readResolve(inputStream, this));
            }
        }
        catch (IOException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }
}

