/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.wizard;

import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.ServerLocationPanel;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.ServerPropertiesPanel;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class WLInstantiatingIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final String PROP_DISPLAY_NAME = "ServInstWizard_displayName";
    private static final String DEFAULT_DEBUGGER_PORT = "8787";
    private WizardDescriptor wizardDescriptor;
    private String serverRoot;
    private String domainRoot;
    private String isLocal;
    private String host;
    private String port;
    private String username;
    private String password;
    private Vector steps = new Vector();
    private WizardDescriptor.Panel[] panels;
    private ServerLocationPanel serverLocationPanel;
    private ServerPropertiesPanel serverPropertiesPanel;
    private int index;
    private Vector listeners;

    public WLInstantiatingIterator() {
        this.steps.add(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"SERVER_LOCATION_STEP"));
        this.steps.add(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"SERVER_PROPERTIES_STEP"));
        this.index = 0;
        this.listeners = new Vector();
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
    }

    public String name() {
        return "";
    }

    public Set instantiate() throws IOException {
        HashSet<InstanceProperties> result = new HashSet<InstanceProperties>();
        String url = "deployer:WebLogic:http://" + this.host + ":" + this.port + ":" + this.serverRoot;
        String username = this.username;
        String password = this.password;
        String displayName = (String)this.wizardDescriptor.getProperty(PROP_DISPLAY_NAME);
        String serverRoot = this.serverRoot;
        String domainRoot = this.domainRoot;
        String isLocal = this.isLocal;
        InstanceProperties ip = InstanceProperties.createInstanceProperties((String)url, (String)username, (String)password, (String)displayName);
        ip.setProperty("serverRoot", serverRoot);
        ip.setProperty("domainRoot", domainRoot);
        ip.setProperty("isLocal", isLocal);
        ip.setProperty("debuggerPort", DEFAULT_DEBUGGER_PORT);
        result.add(ip);
        return result;
    }

    public void setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
        this.serverPropertiesPanel.updateInstancesList();
    }

    public String getServerRoot() {
        return this.serverRoot;
    }

    public void setDomainRoot(String domainRoot) {
        this.domainRoot = domainRoot;
    }

    public String getDomainRoot() {
        return this.domainRoot;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getIsLocal() {
        return this.isLocal;
    }

    public void setIsLocal(String isLocal) {
        this.isLocal = isLocal;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public WizardDescriptor.Panel current() {
        this.getPanels();
        return this.panels[this.index];
    }

    protected final WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = this.createPanels();
        }
        return this.panels;
    }

    protected WizardDescriptor.Panel[] createPanels() {
        this.serverLocationPanel = new ServerLocationPanel(this.steps.toArray(new String[this.steps.size()]), 0, new IteratorListener(), this);
        this.serverPropertiesPanel = new ServerPropertiesPanel(this.steps.toArray(new String[this.steps.size()]), 1, new IteratorListener(), this);
        return new WizardDescriptor.Panel[]{this.serverLocationPanel, this.serverPropertiesPanel};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener listener) {
        if (this.listeners != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(ChangeEvent event) {
        Vector targetListeners;
        Vector vector = this.listeners;
        synchronized (vector) {
            targetListeners = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < targetListeners.size(); ++i) {
            ChangeListener listener = (ChangeListener)targetListeners.elementAt(i);
            listener.stateChanged(event);
        }
    }

    private class IteratorListener
    implements ChangeListener {
        private IteratorListener() {
        }

        public void stateChanged(ChangeEvent event) {
            WLInstantiatingIterator.this.fireChangeEvent(event);
        }
    }
}

