/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute.ui;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.db.core.SQLOptions;
import org.netbeans.modules.db.sql.execute.ColumnDef;
import org.netbeans.modules.db.sql.execute.FetchLimitHandler;
import org.netbeans.modules.db.sql.execute.ResultSetTableModelSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ResultSetTableModel
extends AbstractTableModel {
    private final List columnDefs;
    private final List rows;
    static /* synthetic */ Class class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel;

    public static ResultSetTableModel create(ResultSet rs) throws SQLException, IOException {
        ResultSetMetaData rsmd = rs.getMetaData();
        List columnDefs = ResultSetTableModelSupport.createColumnDefs(rsmd);
        if (columnDefs == null) {
            return null;
        }
        List rows = ResultSetTableModelSupport.retrieveRows(rs, rsmd, new FetchLimitHandlerImpl());
        if (rows == null) {
            return null;
        }
        return new ResultSetTableModel(columnDefs, rows);
    }

    private ResultSetTableModel(List columnDefs, List rows) {
        this.columnDefs = columnDefs;
        this.rows = rows;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.columnDefs.size();
    }

    public Object getValueAt(int row, int column) {
        List rowData = (List)this.rows.get(row);
        return rowData.get(column);
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public String getColumnName(int column) {
        return this.getColumnDef(column).getName();
    }

    public Class getColumnClass(int column) {
        return this.getColumnDef(column).getDisplayClass();
    }

    private ColumnDef getColumnDef(int column) {
        return (ColumnDef)this.columnDefs.get(column);
    }

    private static final class FetchLimitHandlerImpl
    implements FetchLimitHandler {
        private FetchLimitHandlerImpl() {
        }

        public int fetchLimitReached(int fetchCount) {
            JButton fetchYes = new JButton(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel == null ? (class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel = ResultSetTableModel.class$("org.netbeans.modules.db.sql.execute.ui.SQLResultPanel")) : class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel), (String)"LBL_FetchYes"));
            fetchYes.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel == null ? (class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel = ResultSetTableModel.class$("org.netbeans.modules.db.sql.execute.ui.SQLResultPanel")) : class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel), (String)"ACSD_FetchYes"));
            fetchYes.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel == null ? (class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel = ResultSetTableModel.class$("org.netbeans.modules.db.sql.execute.ui.SQLResultPanel")) : class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel), (String)"MNE_FetchYes").charAt(0));
            JButton fetchAll = new JButton(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel == null ? (class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel = ResultSetTableModel.class$("org.netbeans.modules.db.sql.execute.ui.SQLResultPanel")) : class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel), (String)"LBL_FetchAll"));
            fetchAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel == null ? (class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel = ResultSetTableModel.class$("org.netbeans.modules.db.sql.execute.ui.SQLResultPanel")) : class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel), (String)"ACSD_FetchAll"));
            fetchAll.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel == null ? (class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel = ResultSetTableModel.class$("org.netbeans.modules.db.sql.execute.ui.SQLResultPanel")) : class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel), (String)"MNE_FetchAll").charAt(0));
            JButton fetchNo = new JButton(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel == null ? (class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel = ResultSetTableModel.class$("org.netbeans.modules.db.sql.execute.ui.SQLResultPanel")) : class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel), (String)"LBL_FetchNo"));
            fetchNo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel == null ? (class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel = ResultSetTableModel.class$("org.netbeans.modules.db.sql.execute.ui.SQLResultPanel")) : class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel), (String)"ACSD_FetchNo"));
            fetchNo.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel == null ? (class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel = ResultSetTableModel.class$("org.netbeans.modules.db.sql.execute.ui.SQLResultPanel")) : class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel), (String)"MNE_FetchNo").charAt(0));
            String title = NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel == null ? (class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel = ResultSetTableModel.class$("org.netbeans.modules.db.sql.execute.ui.SQLResultPanel")) : class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel), (String)"LBL_FetchNextTitle");
            Object[] args = new Integer[]{new Integer(fetchCount), new Integer(SQLOptions.getDefault().getFetchStep())};
            String message = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel == null ? (class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel = ResultSetTableModel.class$("org.netbeans.modules.db.sql.execute.ui.SQLResultPanel")) : class$org$netbeans$modules$db$sql$execute$ui$SQLResultPanel), (String)"LBL_FetchNextMessage"), args);
            NotifyDescriptor desc = new NotifyDescriptor((Object)message, title, 1, 3, new Object[]{fetchYes, fetchAll, fetchNo}, NotifyDescriptor.CANCEL_OPTION);
            Object ret = DialogDisplayer.getDefault().notify(desc);
            if (ret instanceof JButton) {
                if (ret == fetchYes) {
                    return fetchCount + SQLOptions.getDefault().getFetchStep();
                }
                if (ret == fetchAll) {
                    return 0;
                }
                return fetchCount;
            }
            return fetchCount;
        }

        public int getFetchLimit() {
            return SQLOptions.getDefault().getFetchStep();
        }
    }
}

