/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Codebase;
import org.netbeans.jmi.javamodel.CodebaseClass;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKind;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.GuardedQuery;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MethodImpl;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.Utilities;

public final class CheckUtils {
    private static boolean is15Enabled;
    private static final boolean[][] assignVals;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Set getAllVariableNames(Feature feature) {
        HashSet<String> names = new HashSet<String>();
        LinkedList<Feature> children = new LinkedList<Feature>();
        children.add(feature);
        while (!children.isEmpty()) {
            VariableAccess varAcc;
            Element el = (Element)children.removeFirst();
            if (el instanceof VariableAccess && (varAcc = (VariableAccess)el).getParentClass() == null && !varAcc.isHasSuper()) {
                names.add(varAcc.getName());
            }
            children.addAll(el.getChildren());
        }
        return names;
    }

    public static boolean isFromLibrary(Resource res) {
        CodebaseClass cbClass = ((JavaModelPackage)res.refImmediatePackage()).getCodebase();
        Codebase cb = (Codebase)cbClass.refAllOfClass().iterator().next();
        return cb.isLibrary();
    }

    public static boolean membersEqual(NamedElement m1, NamedElement m2) {
        if (!m1.getClass().equals(m2.getClass())) {
            return false;
        }
        if (m1 instanceof Method) {
            return ((MethodImpl)m1).signatureEquals((Method)m2);
        }
        return m1.getName().equals(m2.getName());
    }

    public static Collection isOverridden(Method method, String name, List argTypes) {
        HashSet<Method> res = new HashSet<Method>();
        if (!CheckUtils.isVirtual((Feature)method)) {
            return res;
        }
        ClassDefinition jc = method.getDeclaringClass();
        LinkedList subtypes = new LinkedList();
        CheckUtils.addSubtypes(jc, subtypes);
        while (subtypes.size() > 0) {
            jc = (ClassDefinition)subtypes.removeFirst();
            Method m = jc.getMethod(name, argTypes, false);
            if (m != null && CheckUtils.isVirtual((Feature)m)) {
                res.add(m);
            }
            CheckUtils.addSubtypes(jc, subtypes);
        }
        return res;
    }

    public static Collection overrides(Method method, String name, List argTypes, boolean findFinal) {
        HashSet<Method> res = new HashSet<Method>();
        if (!CheckUtils.isVirtual((Feature)method)) {
            return res;
        }
        ClassDefinition jc = method.getDeclaringClass();
        LinkedList<ClassDefinition> supertypes = new LinkedList<ClassDefinition>();
        supertypes.addAll(jc.getInterfaces());
        jc = jc.getSuperClass();
        if (jc != null) {
            supertypes.add(jc);
        }
        while (supertypes.size() > 0) {
            jc = (ClassDefinition)supertypes.removeFirst();
            Method m = jc.getMethod(name, argTypes, false);
            if (m != null && CheckUtils.isVirtual((Feature)m)) {
                if ((m.getModifiers() & 0x10) > 0) {
                    res.add(m);
                    continue;
                }
                if (res == null) {
                    res.add(m);
                    if (!findFinal) continue;
                }
            }
            supertypes.addAll(jc.getInterfaces());
            if ((jc = jc.getSuperClass()) == null) continue;
            supertypes.add(jc);
        }
        return res;
    }

    public static boolean hasVarArgs(CallableFeature callable) {
        Iterator it = callable.getParameters().iterator();
        while (it.hasNext()) {
            if (!((Parameter)it.next()).isVarArg()) continue;
            return true;
        }
        return false;
    }

    public static boolean isVirtual(Feature feature) {
        int mod = feature.getModifiers();
        return !Modifier.isPrivate(mod);
    }

    public static JavaClass getClass(JavaPackage pkg, String clsName) {
        Iterator it = pkg.getResources().iterator();
        while (it.hasNext()) {
            Resource res = (Resource)it.next();
            Iterator it2 = res.getClassifiers().iterator();
            while (it2.hasNext()) {
                Object obj = it2.next();
                if (!(obj instanceof JavaClass) || !clsName.equals(((JavaClass)obj).getName())) continue;
                return (JavaClass)obj;
            }
        }
        return null;
    }

    public static boolean isFolderEmpty(FileObject f) {
        if (f == null || f.isVirtual() || !f.isValid()) {
            return true;
        }
        DataFolder dob = DataFolder.findFolder((FileObject)f);
        DataObject[] children = dob.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof DataFolder) continue;
            return false;
        }
        return true;
    }

    public static boolean isElementReadOnly(Element e) {
        FileObject f;
        if (e == null) {
            throw new IllegalArgumentException("Cannot pass null as an argument");
        }
        Resource res = e.getResource();
        if (res != null && (f = JavaModel.getFileObject((Resource)res)) != null) {
            return !f.canWrite();
        }
        return false;
    }

    public static boolean isValidPackageName(String name) {
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        while (tokenizer.hasMoreTokens()) {
            if (Utilities.isJavaIdentifier((String)tokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    public static boolean isRefactoringElementReadOnly(RefactoringElementImplementation el) {
        Element elem = el.getJavaElement();
        if (elem == null) {
            return !el.getParentFile().canWrite();
        }
        return CheckUtils.isElementReadOnly(elem);
    }

    public static boolean isRefactoringElementGuarded(RefactoringElementImplementation el) {
        PositionBounds pos;
        Resource res;
        Element elem = el.getJavaElement();
        if (elem != null && (res = elem.getResource()) != null && (pos = el.getPosition()) != null) {
            return GuardedQuery.isSectionGuarded((Resource)res, (PositionBounds)pos);
        }
        return false;
    }

    public static boolean isElementInOpenProject(Element el) {
        if (!$assertionsDisabled && el == null) {
            throw new AssertionError();
        }
        Resource r = el.getResource();
        if (!$assertionsDisabled && r == null) {
            throw new AssertionError((Object)("el.getResource() returned null, el = " + el.toString()));
        }
        FileObject f = JavaModel.getFileObject((Resource)r);
        if (!$assertionsDisabled && f == null) {
            throw new AssertionError((Object)("JavaModel.getFileObject(r) returned null, r = " + r.getName()));
        }
        Project p = FileOwnerQuery.getOwner((FileObject)f);
        Project[] opened = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < opened.length; ++i) {
            if (p != opened[i]) continue;
            return true;
        }
        return false;
    }

    public static String htmlize(String input) {
        String temp = Utilities.replaceString((String)input, (String)"<", (String)"&lt;");
        temp = Utilities.replaceString((String)temp, (String)">", (String)"&gt;");
        return temp;
    }

    public static String trimToEnd(String text) {
        int end;
        char[] str = text.toCharArray();
        for (end = str.length; end > 0 && Character.isWhitespace(str[end - 1]); --end) {
        }
        return text.substring(0, end);
    }

    public static boolean hasChildren(DataFolder folder) {
        Enumeration en = folder.children(true);
        while (en.hasMoreElements()) {
            if (en.nextElement() instanceof DataFolder) continue;
            return true;
        }
        return false;
    }

    public static boolean isAccessible(ClassDefinition cls, JavaClass from) {
        if (cls == null) {
            return false;
        }
        if (from == null) {
            return true;
        }
        while (cls instanceof Array) {
            Type typ = ((Array)cls).getType();
            if (typ instanceof ClassDefinition) {
                cls = (ClassDefinition)typ;
                continue;
            }
            return true;
        }
        return ((JavaClass)cls).isInner() ? CheckUtils.isAccessible((Feature)((JavaClass)cls), ((JavaClass)cls).getDeclaringClass(), from) : CheckUtils.isTopLevelClassAccessible((JavaClass)cls, from);
    }

    public static boolean isSubTypeOf(JavaClass thisCls, JavaClass otherCls) {
        if (otherCls instanceof TypeParameter) {
            if (!CheckUtils.isSubTypeOf(thisCls, otherCls.getSuperClass())) {
                return false;
            }
            Iterator it = otherCls.getInterfaces().iterator();
            while (it.hasNext()) {
                if (CheckUtils.isSubTypeOf(thisCls, (JavaClass)it.next())) continue;
                return false;
            }
            return true;
        }
        if (thisCls.isSubTypeOf((ClassDefinition)otherCls)) {
            List otherParams;
            List thisParams = thisCls instanceof ParameterizedType ? ((ParameterizedType)thisCls).getParameters() : new ArrayList();
            List list = otherParams = otherCls instanceof ParameterizedType ? ((ParameterizedType)otherCls).getParameters() : new ArrayList();
            if (thisParams.size() != otherParams.size()) {
                return false;
            }
            Iterator it = thisParams.iterator();
            Iterator itt = otherParams.iterator();
            while (it.hasNext()) {
                if (CheckUtils.isAssignable((Type)it.next(), (Type)itt.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isAssignable(Type from, Type to) {
        if (from == null || to == null) {
            return false;
        }
        if (from.equals(to)) {
            return true;
        }
        if (from instanceof Array && to instanceof Array) {
            return CheckUtils.isAssignable(((Array)from).getType(), ((Array)to).getType());
        }
        if (to instanceof PrimitiveType && (is15Enabled || from instanceof PrimitiveType)) {
            return assignVals[CheckUtils.getPrimitiveTypeIdx(from)][CheckUtils.getPrimitiveTypeIdx(to)];
        }
        if (to.getName().equals("java.lang.Object") && (is15Enabled || !(from instanceof PrimitiveType))) {
            return true;
        }
        if (to instanceof JavaClass && is15Enabled && from instanceof PrimitiveType) {
            return CheckUtils.isAssignable(CheckUtils.getObjectType((PrimitiveType)from), to);
        }
        if (from instanceof JavaClass && to instanceof JavaClass) {
            return CheckUtils.isSubTypeOf((JavaClass)from, (JavaClass)to);
        }
        return false;
    }

    private static void addSubtypes(ClassDefinition cd, List list) {
        if (!(cd instanceof JavaClass)) {
            return;
        }
        JavaClass jc = (JavaClass)cd;
        Collection desc = null;
        desc = jc.isInterface() ? jc.getImplementors() : jc.getSubClasses();
        list.addAll(desc);
    }

    private static boolean isAccessible(Feature feature, ClassDefinition cls, JavaClass from) {
        ClassDefinition decCls = feature.getDeclaringClass();
        AccessibilityDescriptor desc = new AccessibilityDescriptor(decCls, cls, from);
        return desc.isAccessible(feature.getModifiers());
    }

    private static String getPackageName(ClassDefinition jc) {
        String result;
        Resource res;
        if (jc instanceof UnresolvedClass) {
            String name = jc.getName();
            int index = name.lastIndexOf(46);
            return index < 0 ? "" : name.substring(0, index);
        }
        if (jc instanceof JavaClass && (res = jc.getResource()) != null && (result = res.getPackageName()) != null) {
            return result;
        }
        return "";
    }

    private static JavaClass getOutermostClass(JavaClass jc) {
        while (jc.isInner()) {
            JavaClass decl = (JavaClass)jc.getDeclaringClass();
            if (decl == null) {
                return jc;
            }
            jc = decl;
        }
        return jc;
    }

    private static boolean isTopLevelClassAccessible(JavaClass cls, JavaClass from) {
        if (cls == null) {
            return false;
        }
        if (from == null) {
            return true;
        }
        if ((cls.getModifiers() & 1) != 0) {
            return true;
        }
        String pkgName = CheckUtils.getPackageName((ClassDefinition)cls);
        String fromPkgName = CheckUtils.getPackageName((ClassDefinition)from);
        return pkgName.equals(fromPkgName);
    }

    private static Type getObjectType(PrimitiveType type) {
        PrimitiveTypeKind kind = type.getKind();
        if (PrimitiveTypeKindEnum.BOOLEAN.equals((Object)kind)) {
            return CheckUtils.resolveType("java.lang.Boolean");
        }
        if (PrimitiveTypeKindEnum.BYTE.equals((Object)kind)) {
            return CheckUtils.resolveType("java.lang.Byte");
        }
        if (PrimitiveTypeKindEnum.CHAR.equals((Object)kind)) {
            return CheckUtils.resolveType("java.lang.Char");
        }
        if (PrimitiveTypeKindEnum.DOUBLE.equals((Object)kind)) {
            return CheckUtils.resolveType("java.lang.Double");
        }
        if (PrimitiveTypeKindEnum.FLOAT.equals((Object)kind)) {
            return CheckUtils.resolveType("java.lang.Float");
        }
        if (PrimitiveTypeKindEnum.INT.equals((Object)kind)) {
            return CheckUtils.resolveType("java.lang.Integer");
        }
        if (PrimitiveTypeKindEnum.LONG.equals((Object)kind)) {
            return CheckUtils.resolveType("java.lang.Long");
        }
        if (PrimitiveTypeKindEnum.SHORT.equals((Object)kind)) {
            return CheckUtils.resolveType("java.lang.Short");
        }
        return null;
    }

    private static Type resolveType(String typeName) {
        if (!"null".equals(typeName)) {
            return JavaModel.getDefaultExtent().getType().resolve(typeName);
        }
        return null;
    }

    private static byte getPrimitiveTypeIdx(Type type) {
        PrimitiveTypeKind kind;
        PrimitiveTypeKind primitiveTypeKind = kind = type instanceof PrimitiveType ? ((PrimitiveType)type).getKind() : null;
        if ("java.lang.Boolean".equals(type.getName()) || PrimitiveTypeKindEnum.BOOLEAN.equals((Object)kind)) {
            return 0;
        }
        if ("java.lang.Byte".equals(type.getName()) || PrimitiveTypeKindEnum.BYTE.equals((Object)kind)) {
            return 1;
        }
        if ("java.lang.Char".equals(type.getName()) || PrimitiveTypeKindEnum.CHAR.equals((Object)kind)) {
            return 2;
        }
        if ("java.lang.Double".equals(type.getName()) || PrimitiveTypeKindEnum.DOUBLE.equals((Object)kind)) {
            return 3;
        }
        if ("java.lang.Float".equals(type.getName()) || PrimitiveTypeKindEnum.FLOAT.equals((Object)kind)) {
            return 4;
        }
        if ("java.lang.Integer".equals(type.getName()) || PrimitiveTypeKindEnum.INT.equals((Object)kind)) {
            return 5;
        }
        if ("java.lang.Long".equals(type.getName()) || PrimitiveTypeKindEnum.LONG.equals((Object)kind)) {
            return 6;
        }
        if ("java.lang.Short".equals(type.getName()) || PrimitiveTypeKindEnum.SHORT.equals((Object)kind)) {
            return 7;
        }
        return 8;
    }

    static {
        $assertionsDisabled = !CheckUtils.class.desiredAssertionStatus();
        is15Enabled = true;
        assignVals = new boolean[][]{{true, false, false, false, false, false, false, false, false}, {false, true, false, true, true, true, true, true, false}, {false, false, true, true, true, true, true, false, false}, {false, false, false, true, false, false, false, false, false}, {false, false, false, true, true, false, false, false, false}, {false, false, false, true, true, true, true, false, false}, {false, false, false, true, true, false, true, false, false}, {false, false, false, true, true, true, true, true, false}, {false, false, false, false, false, false, false, false, true}};
    }

    private static class AccessibilityDescriptor {
        int mprotected = -1;
        int mpackprivate = -1;
        int mprivate = -1;
        ClassDefinition decCls;
        ClassDefinition cls;
        JavaClass from;

        AccessibilityDescriptor(ClassDefinition decCls, ClassDefinition cls, JavaClass from) {
            if (from == null) {
                this.mprivate = 1;
                this.mpackprivate = 1;
                this.mprotected = 1;
                return;
            }
            if (cls instanceof TypeParameter) {
                cls = decCls;
            }
            if (cls != null && !from.equals(cls) && !CheckUtils.isAccessible(cls, from)) {
                this.mprivate = 0;
                this.mpackprivate = 0;
                this.mprotected = 0;
                return;
            }
            this.decCls = decCls;
            this.cls = cls;
            this.from = from;
        }

        private void computeProtectedAccess() {
        }

        private void computePackagePrivateAccess() {
            String pkgName;
            String fromPkgName = CheckUtils.getPackageName((ClassDefinition)this.from);
            boolean mpackpriv = fromPkgName.equals(pkgName = CheckUtils.getPackageName(this.decCls));
            if (mpackpriv) {
                this.mpackprivate = 1;
                this.mprotected = 1;
            } else {
                this.mpackprivate = 0;
            }
        }

        private void computePrivateAccess() {
            boolean mpriv = CheckUtils.getOutermostClass(this.from).equals(this.decCls instanceof JavaClass ? CheckUtils.getOutermostClass((JavaClass)this.decCls) : null);
            if (mpriv) {
                this.mprivate = 1;
                this.mpackprivate = 1;
                this.mprotected = 1;
            } else {
                this.mprivate = 0;
            }
        }

        private boolean isAccessible(int modifiers) {
            if (Modifier.isPublic(modifiers)) {
                return true;
            }
            if (this.mprivate == -1) {
                this.computePrivateAccess();
            }
            if (this.mprivate == 1) {
                return true;
            }
            if (Modifier.isPrivate(modifiers)) {
                return false;
            }
            if (this.mpackprivate == -1) {
                this.computePackagePrivateAccess();
            }
            if (this.mpackprivate == 1) {
                return true;
            }
            if (!Modifier.isProtected(modifiers)) {
                return false;
            }
            return this.mprotected == 1;
        }
    }
}

