/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.jmi.javamodel.Assignment;
import org.netbeans.jmi.javamodel.AssignmentClass;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.ConstructorClass;
import org.netbeans.jmi.javamodel.ConstructorInvocation;
import org.netbeans.jmi.javamodel.ConstructorInvocationClass;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.ExpressionStatement;
import org.netbeans.jmi.javamodel.ExpressionStatementClass;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.FieldClass;
import org.netbeans.jmi.javamodel.Invocation;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaClassClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.MultipartIdClass;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.NewClassExpression;
import org.netbeans.jmi.javamodel.NewClassExpressionClass;
import org.netbeans.jmi.javamodel.Operator;
import org.netbeans.jmi.javamodel.OperatorEnum;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterClass;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.StatementBlockClass;
import org.netbeans.jmi.javamodel.ThisExpression;
import org.netbeans.jmi.javamodel.ThisExpressionClass;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.jmi.javamodel.VariableAccessClass;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.ProgressEvent;
import org.netbeans.modules.javacore.internalapi.ProgressListener;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.api.AnonymousToInnerRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AnonymousToInnerRefactoringPlugin
extends JavaRefactoringPlugin
implements ProgressListener {
    private ClassDefinition classDefinition;
    private AnonymousToInnerRefactoring refactoring;
    private List outerLocalVars;
    private List constructorParameters;
    private boolean outerClassAccessed;

    public AnonymousToInnerRefactoringPlugin(AnonymousToInnerRefactoring convert) {
        this.refactoring = convert;
        this.classDefinition = convert.getClassDefinition();
    }

    public Problem checkParameters() {
        return this.setParameters(this.refactoring.getName(), this.refactoring.getModifiers(), this.refactoring.getParamTable());
    }

    public Problem fastCheckParameters() {
        String name = this.refactoring.getName();
        if (name == null || name.length() == 0) {
            return new Problem(true, NbBundle.getMessage((Class)AnonymousToInnerRefactoring.class, (String)"ERR_NameNotSet"));
        }
        if (!Utilities.isJavaIdentifier((String)name)) {
            String msg = new MessageFormat(NbBundle.getMessage((Class)AnonymousToInnerRefactoring.class, (String)"ERR_InvalidIdentifier")).format(new Object[]{name});
            return new Problem(true, msg);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 4);
        try {
            if (this.classDefinition == null) {
                String msg = AnonymousToInnerRefactoringPlugin.getString("ERR_AnonymousToInnerNoClassSelected");
                Problem problem = new Problem(true, msg);
                return problem;
            }
            if (!CheckUtils.isElementInOpenProject((Element)this.classDefinition)) {
                Problem msg = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return msg;
            }
            this.fireProgressListenerStep();
            this.collectLocalVariables();
            this.fireProgressListenerStep();
            this.fireProgressListenerStep();
            AnonymousToInnerRefactoring.ParameterInfo[] pinfo = this.computeConstructorParams();
            this.fireProgressListenerStep();
            if (this.refactoring.getParamTable() == null) {
                this.refactoring.setParamTable(pinfo);
            }
        }
        finally {
            this.fireProgressListenerStop();
        }
        return null;
    }

    private Problem checkParameters(String name, int modifiers, AnonymousToInnerRefactoring.ParameterInfo[] pinfo) {
        String msg;
        Problem problem = null;
        JavaClass jc = this.getEnclosingJavaClass((Element)this.classDefinition);
        if (jc.getInnerClass(name, false) != null) {
            msg = new MessageFormat(AnonymousToInnerRefactoringPlugin.getString("ERR_InnerClassExists")).format(new Object[]{name, jc.getSimpleName()});
            problem = new Problem(true, msg);
        }
        if ((modifiers & 8) != 0 && this.outerClassAccessed) {
            msg = AnonymousToInnerRefactoringPlugin.getString("ERR_AnonymousToInnerCannotBeStatic");
            Problem p = new Problem(true, msg);
            p.setNext(problem);
            problem = p;
        }
        for (int x = 0; x < pinfo.length; ++x) {
            String pname = pinfo[x].getName();
            if (Utilities.isJavaIdentifier((String)pname)) continue;
            String msg2 = new MessageFormat(AnonymousToInnerRefactoringPlugin.getString("ERR_AnonymousToInnerInavlidParamName")).format(new Object[]{pname});
            Problem p = new Problem(true, msg2);
            p.setNext(problem);
            problem = p;
        }
        HashSet<String> names = new HashSet<String>(pinfo.length);
        for (int x = 0; x < pinfo.length; ++x) {
            String pname = pinfo[x].getName();
            if (names.contains(pname)) {
                String msg3 = new MessageFormat(AnonymousToInnerRefactoringPlugin.getString("ERR_AnonymousToInnerDuplicateParamName")).format(new Object[]{pname});
                Problem p = new Problem(true, msg3);
                p.setNext(problem);
                problem = p;
                break;
            }
            names.add(pname);
        }
        return problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Problem setParameters(String name, int modifiers, AnonymousToInnerRefactoring.ParameterInfo[] pinfo) {
        this.fireProgressListenerStart(2, 1);
        try {
            Problem result;
            this.fireProgressListenerStep();
            Problem problem = result = this.checkParameters(name, modifiers, pinfo);
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem prepare(RefactoringElementsBag elements) {
        elements.add(this.refactoring, new ConvertToInnerClassElement(this.classDefinition, this.refactoring.getName(), this.refactoring.getModifiers(), this.refactoring.getParamTable()));
        return null;
    }

    private static final String getString(String key) {
        return NbBundle.getMessage((Class)AnonymousToInnerRefactoringPlugin.class, (String)key);
    }

    public void start(ProgressEvent event) {
        this.fireProgressListenerStart(event.getOperationType(), event.getCount());
    }

    public void step(ProgressEvent event) {
        this.fireProgressListenerStep();
    }

    public void stop(ProgressEvent event) {
        this.fireProgressListenerStop();
    }

    private void collectLocalVariables() {
        this.outerLocalVars = new ArrayList();
        HashSet accessedClasses = new HashSet();
        this.collectLocalVariables(this.outerLocalVars, (Element)this.classDefinition, new HashSet(), accessedClasses);
        HashSet supertypes = new HashSet();
        this.collectSupertypes(supertypes, (ClassDefinition)this.getEnclosingJavaClass((Element)this.classDefinition));
        this.outerClassAccessed = false;
        Iterator iter = accessedClasses.iterator();
        while (iter.hasNext()) {
            if (!supertypes.contains(iter.next())) continue;
            this.outerClassAccessed = true;
            break;
        }
    }

    private void collectLocalVariables(List localVars, Element elem, Set localVarNames, Set accessedClasses) {
        block5: {
            Feature bf;
            block3: {
                NamedElement nelem;
                block4: {
                    if (!(elem instanceof VariableAccess)) break block3;
                    nelem = ((VariableAccess)elem).getElement();
                    if (!(nelem instanceof LocalVariable) && !(nelem instanceof Parameter)) break block4;
                    Variable variable = (Variable)nelem;
                    ClassDefinition cd = this.getEnclosingClass((Element)variable);
                    if (cd != this.classDefinition && !localVarNames.contains(variable.getName())) {
                        localVars.add(variable);
                        localVarNames.add(variable.getName());
                    }
                    break block5;
                }
                if (!(nelem instanceof Field) || (((Field)nelem).getModifiers() & 8) != 0) break block5;
                accessedClasses.add(((Field)nelem).getDeclaringClass());
                break block5;
            }
            if (elem instanceof Invocation && (bf = (Feature)((Invocation)elem).getElement()) != null && (bf.getModifiers() & 8) == 0) {
                accessedClasses.add(bf.getDeclaringClass());
            }
            Iterator iter = elem.getChildren().iterator();
            while (iter.hasNext()) {
                this.collectLocalVariables(localVars, (Element)iter.next(), localVarNames, accessedClasses);
            }
        }
    }

    private AnonymousToInnerRefactoring.ParameterInfo[] computeConstructorParams() {
        Iterator iter;
        NewClassExpression newClsExpr;
        Constructor constr;
        this.constructorParameters = new ArrayList();
        HashSet<String> paramNames = new HashSet<String>();
        JavaClass superType = this.getSupertype(this.classDefinition);
        if (!superType.isInterface() && (constr = (Constructor)(newClsExpr = (NewClassExpression)this.classDefinition.refImmediateComposite()).getElement()) != null) {
            iter = constr.getParameters().iterator();
            while (iter.hasNext()) {
                this.constructorParameters.add(iter.next());
            }
        }
        AnonymousToInnerRefactoring.ParameterInfo[] pinfo = new AnonymousToInnerRefactoring.ParameterInfo[this.outerLocalVars.size() + this.constructorParameters.size()];
        int index = 0;
        iter = this.outerLocalVars.iterator();
        while (iter.hasNext()) {
            Variable localVar = (Variable)iter.next();
            paramNames.add(localVar.getName());
            pinfo[index++] = new AnonymousToInnerRefactoring.ParameterInfo(localVar);
        }
        iter = this.constructorParameters.iterator();
        while (iter.hasNext()) {
            String pname;
            Parameter param = (Parameter)iter.next();
            String name = pname = param.getName();
            int x = 1;
            while (paramNames.contains(name)) {
                name = pname + x;
                ++x;
            }
            pinfo[index] = new AnonymousToInnerRefactoring.ParameterInfo((Variable)param);
            pinfo[index].setName(name);
            ++index;
        }
        return pinfo;
    }

    private ClassDefinition getEnclosingClass(Element elem) {
        Element comp;
        for (comp = (Element)elem.refImmediateComposite(); comp != null && !(comp instanceof ClassDefinition); comp = (Element)comp.refImmediateComposite()) {
        }
        return (ClassDefinition)comp;
    }

    private JavaClass getEnclosingJavaClass(Element elem) {
        Element comp;
        for (comp = (Element)elem.refImmediateComposite(); comp != null && !(comp instanceof JavaClass); comp = (Element)comp.refImmediateComposite()) {
        }
        return (JavaClass)comp;
    }

    private JavaClass getSupertype(ClassDefinition cd) {
        List list = cd.getInterfaces();
        if (list.size() > 0) {
            return (JavaClass)list.get(0);
        }
        return cd.getSuperClass();
    }

    private void collectSupertypes(Set supertypes, ClassDefinition jc) {
        if (jc == null) {
            return;
        }
        supertypes.add(jc);
        this.collectSupertypes(supertypes, (ClassDefinition)jc.getSuperClass());
        Iterator iter = jc.getInterfaces().iterator();
        while (iter.hasNext()) {
            this.collectSupertypes(supertypes, (ClassDefinition)iter.next());
        }
    }

    private class ConvertToInnerClassElement
    extends SimpleRefactoringElementImpl {
        private final String text;
        private PositionBounds bounds = null;
        private ClassDefinition classDef;
        private String name;
        private int modifiers;
        private AnonymousToInnerRefactoring.ParameterInfo[] pinfo;

        public ConvertToInnerClassElement(ClassDefinition classDef, String name, int modifiers, AnonymousToInnerRefactoring.ParameterInfo[] pinfo) {
            this.classDef = classDef;
            this.name = name;
            this.modifiers = modifiers;
            this.pinfo = pinfo;
            this.text = MessageFormat.format(AnonymousToInnerRefactoringPlugin.getString("TXT_ConvertAnonymousToInner"), name);
        }

        public String getDisplayText() {
            return this.text;
        }

        public Element getJavaElement() {
            return this.classDef;
        }

        public PositionBounds getPosition() {
            if (this.bounds == null) {
                this.bounds = JavaMetamodel.getManager().getElementPosition((Element)this.classDef);
            }
            return this.bounds;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public void performChange() {
            ClassDefinition jc;
            JavaModelPackage modelPackage = (JavaModelPackage)this.classDef.refOutermostPackage();
            JavaClassClass jcProxy = modelPackage.getJavaClass();
            MultipartIdClass idProxy = modelPackage.getMultipartId();
            FieldClass fieldProxy = modelPackage.getField();
            ConstructorClass constructorProxy = modelPackage.getConstructor();
            ParameterClass parameterProxy = modelPackage.getParameter();
            AssignmentClass assignmentProxy = modelPackage.getAssignment();
            VariableAccessClass varAccessProxy = modelPackage.getVariableAccess();
            ThisExpressionClass thisProxy = modelPackage.getThisExpression();
            ExpressionStatementClass exprStatementProxy = modelPackage.getExpressionStatement();
            StatementBlockClass blockProxy = modelPackage.getStatementBlock();
            ConstructorInvocationClass constrInvocationProxy = modelPackage.getConstructorInvocation();
            NewClassExpressionClass newClassProxy = modelPackage.getNewClassExpression();
            NewClassExpression newClsExpr = (NewClassExpression)this.classDef.refImmediateComposite();
            JavaClass superType = AnonymousToInnerRefactoringPlugin.this.getSupertype(this.classDef);
            MultipartId superClassName = null;
            ArrayList<MultipartId> interfaceNames = null;
            if (superType != null) {
                MultipartId exprSuperTypeName = newClsExpr.getClassName();
                MultipartId superTypeName = (MultipartId)exprSuperTypeName.duplicate();
                if (!superType.isInterface()) {
                    superClassName = superTypeName;
                } else {
                    interfaceNames = new ArrayList<MultipartId>();
                    interfaceNames.add(superTypeName);
                }
            }
            JavaClass innerClass = jcProxy.createJavaClass(this.name, null, this.modifiers, null, null, null, superClassName, interfaceNames, null);
            List contents = innerClass.getContents();
            Iterator iter = this.classDef.getContents().iterator();
            while (iter.hasNext()) {
                Element elem = (Element)iter.next();
                contents.add(elem.duplicate());
            }
            ArrayList<Object> statements = new ArrayList<Object>();
            int featureIndex = 0;
            HashMap<Variable, String> paramToName = new HashMap<Variable, String>();
            for (int x = 0; x < this.pinfo.length; ++x) {
                paramToName.put(this.pinfo[x].getVariable(), this.pinfo[x].getName());
            }
            if (AnonymousToInnerRefactoringPlugin.this.outerLocalVars.size() > 0) {
                Iterator iter2 = AnonymousToInnerRefactoringPlugin.this.outerLocalVars.iterator();
                while (iter2.hasNext()) {
                    Variable localVar = (Variable)iter2.next();
                    String varName = localVar.getName();
                    Field field = fieldProxy.createField(varName, null, 2, null, null, true, (TypeReference)localVar.getTypeName().duplicate(), localVar.getDimCount(), null, null);
                    contents.add(featureIndex, field);
                    ++featureIndex;
                    ThisExpression thisExpr = thisProxy.createThisExpression(null);
                    VariableAccess leftSide = varAccessProxy.createVariableAccess(varName, (PrimaryExpression)thisExpr, false);
                    VariableAccess rightSide = varAccessProxy.createVariableAccess((String)paramToName.get(localVar), null, false);
                    Assignment assignment = assignmentProxy.createAssignment((PrimaryExpression)leftSide, (Operator)OperatorEnum.ASSIGN, (Expression)rightSide);
                    ExpressionStatement exprSt = exprStatementProxy.createExpressionStatement((Expression)assignment);
                    statements.add(exprSt);
                }
            }
            if (this.pinfo.length > 0) {
                ArrayList<VariableAccess> paramsToDelegate = new ArrayList<VariableAccess>();
                boolean index = false;
                Iterator iter3 = AnonymousToInnerRefactoringPlugin.this.constructorParameters.iterator();
                while (iter3.hasNext()) {
                    Parameter par = (Parameter)iter3.next();
                    String pname = (String)paramToName.get(par);
                    paramsToDelegate.add(varAccessProxy.createVariableAccess(pname, null, false));
                }
                ConstructorInvocation cinv = constrInvocationProxy.createConstructorInvocation(null, paramsToDelegate, true, null);
                statements.add(0, cinv);
                StatementBlock stBlock = blockProxy.createStatementBlock(statements);
                ArrayList<Parameter> constrParams = new ArrayList<Parameter>();
                for (int x = 0; x < this.pinfo.length; ++x) {
                    String pName = this.pinfo[x].getName();
                    Variable var = this.pinfo[x].getVariable();
                    Parameter param = parameterProxy.createParameter(pName, null, false, (TypeReference)var.getTypeName().duplicate(), var.getDimCount(), false);
                    constrParams.add(param);
                }
                Constructor constr = constructorProxy.createConstructor(this.name, null, 1, null, null, stBlock, null, null, constrParams, null);
                contents.add(featureIndex, constr);
            }
            for (jc = this.classDef; jc != null && !(jc instanceof JavaClass); jc = (Element)jc.refImmediateComposite()) {
            }
            if (jc != null) {
                ((JavaClass)jc).getContents().add(innerClass);
            }
            HashMap<Object, Object> paramToValue = new HashMap<Object, Object>(this.pinfo.length);
            Iterator parIter = AnonymousToInnerRefactoringPlugin.this.constructorParameters.iterator();
            Iterator iter4 = newClsExpr.getParameters().iterator();
            while (iter4.hasNext()) {
                Expression expr = (Expression)iter4.next();
                paramToValue.put(parIter.next(), expr.duplicate());
            }
            iter4 = AnonymousToInnerRefactoringPlugin.this.outerLocalVars.iterator();
            while (iter4.hasNext()) {
                Variable locVar = (Variable)iter4.next();
                VariableAccess vacc = varAccessProxy.createVariableAccess(locVar.getName(), null, false);
                paramToValue.put(locVar, vacc);
            }
            ArrayList values = new ArrayList(this.pinfo.length);
            for (int x = 0; x < this.pinfo.length; ++x) {
                values.add(paramToValue.get(this.pinfo[x].getVariable()));
            }
            NewClassExpression newClassEpr2 = newClassProxy.createNewClassExpression(this.name, values, null, null, null);
            Element composite = (Element)newClsExpr.refImmediateComposite();
            composite.replaceChild((Element)newClsExpr, (Element)newClassEpr2);
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.classDef.getResource());
        }
    }
}

