/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.Codebase;
import org.netbeans.jmi.javamodel.CodebaseClass;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.internalapi.ProgressEvent;
import org.netbeans.modules.javacore.internalapi.ProgressListener;
import org.netbeans.modules.refactoring.CommentFinder;
import org.netbeans.modules.refactoring.WhereUsedElement;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.util.NbBundle;

public class WhereUsedQueryPlugin
extends JavaRefactoringPlugin
implements ProgressListener {
    private RefObject jmiObject;
    private boolean baseClass;
    private boolean overriders;
    private boolean subclasses;
    private boolean directOnly;
    private boolean findUsages = true;
    private WhereUsedQuery refactoring;

    public WhereUsedQueryPlugin(WhereUsedQuery refactoring) {
        this.refactoring = refactoring;
        this.jmiObject = (RefObject)refactoring.getRefactoredObject();
    }

    public Problem preCheck() {
        Problem p = WhereUsedQueryPlugin.isElementAvail((Element)this.jmiObject);
        if (p != null) {
            return p;
        }
        if (this.jmiObject instanceof UnresolvedClass) {
            return new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"DSC_ElNotAvail"));
        }
        if (!(this.jmiObject instanceof Feature || this.jmiObject instanceof Variable || this.jmiObject instanceof JavaPackage || this.jmiObject instanceof TypeParameter)) {
            return new Problem(true, NbBundle.getMessage((Class)WhereUsedQuery.class, (String)"ERR_WhereUsedWrongType"));
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag elements) {
        CommentFinder docFinder = null;
        JavaMetamodel.getManager().getProgressSupport().addProgressListener((ProgressListener)this);
        try {
            boolean searchComments;
            long startT = 0L;
            if (JMManager.PERF_DEBUG) {
                startT = System.currentTimeMillis();
            }
            if (searchComments = this.refactoring.isFindUsages() && this.refactoring.isSearchInComments()) {
                Resource newRsc = this.convertResource();
                docFinder = new CommentFinder((Element)this.jmiObject);
                if (newRsc != null) {
                    elements.addAll(this.refactoring, docFinder.searchCommentsInResource(newRsc));
                }
            }
            this.referencesIterator = this.jmiObject instanceof Method ? ((Method)this.jmiObject).findDependencies(this.findUsages, false, this.overriders).iterator() : (this.jmiObject instanceof JavaClass && (this.subclasses || this.directOnly) ? ((JavaClass)this.jmiObject).findSubTypes(!this.directOnly).iterator() : ((NamedElement)this.jmiObject).getReferences().iterator());
            while (this.referencesIterator.hasNext()) {
                Element element = (Element)this.referencesIterator.next();
                Resource rsc = element.getResource();
                if ((rsc.getStatus() & Integer.MIN_VALUE) != 0) continue;
                if (this.cancelRequest) {
                    Problem problem = null;
                    return problem;
                }
                if (searchComments) {
                    elements.addAll(this.refactoring, docFinder.searchCommentsInResource(rsc));
                }
                elements.add(this.refactoring, new WhereUsedElement(this.jmiObject, element));
            }
            if (JMManager.PERF_DEBUG) {
                long finishT = System.currentTimeMillis();
                long deltaT = finishT - startT;
                System.out.print("PERF: Collecting usages of '");
                if (this.jmiObject instanceof NamedElement) {
                    System.out.print(((NamedElement)this.jmiObject).getName());
                } else {
                    System.out.print("unknown");
                }
                System.out.println("' takes " + deltaT + " ms.");
            }
            Problem problem = null;
            return problem;
        }
        finally {
            this.referencesIterator = null;
            JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
        }
    }

    public Problem fastCheckParameters() {
        if (this.jmiObject instanceof Method) {
            return this.checkParametersForMethod(this.refactoring.isSearchFromBaseClass(), this.refactoring.isFindOverridingMethods(), this.refactoring.isFindUsages());
        }
        if (this.jmiObject instanceof JavaClass) {
            return this.checkParametersForClass(this.refactoring.isFindSubclasses(), this.refactoring.isFindDirectSubclassesOnly());
        }
        return null;
    }

    public Problem checkParameters() {
        if (this.jmiObject instanceof Method) {
            return this.setParametersForMethod(this.refactoring.isSearchFromBaseClass(), this.refactoring.isFindOverridingMethods(), this.refactoring.isFindUsages());
        }
        if (this.jmiObject instanceof JavaClass) {
            return this.setParametersForClass(this.refactoring.isFindSubclasses(), this.refactoring.isFindDirectSubclassesOnly());
        }
        return null;
    }

    private Problem checkParametersForMethod(boolean baseClass, boolean overriders, boolean usages) {
        if (!usages && !overriders) {
            return new Problem(true, NbBundle.getMessage((Class)WhereUsedQuery.class, (String)"MSG_NothingToFind"));
        }
        return null;
    }

    private Problem setParametersForMethod(boolean baseClass, boolean overriders, boolean usages) {
        Collection c;
        this.baseClass = baseClass;
        this.overriders = overriders;
        this.findUsages = usages;
        if (baseClass && !(c = JavaModelUtil.getOverriddenMethods((Method)((Method)this.jmiObject))).isEmpty()) {
            this.jmiObject = (Method)c.iterator().next();
        }
        return null;
    }

    private Resource convertResource() {
        JavaClass jcls;
        JavaModelPackage pck;
        Type newJcls;
        Iterator classIt;
        Resource rsc = ((Element)this.jmiObject).getResource();
        if (rsc != null && (classIt = rsc.getClassifiers().iterator()).hasNext() && (newJcls = (pck = (JavaModelPackage)(jcls = (JavaClass)classIt.next()).refImmediatePackage()).getType().resolve(jcls.getName())) != null) {
            Resource newRsc = newJcls.getResource();
            CodebaseClass cbClass = ((JavaModelPackage)newRsc.refImmediatePackage()).getCodebase();
            Codebase cb = (Codebase)cbClass.refAllOfClass().iterator().next();
            if (newRsc != null && newRsc.getName().endsWith(".java") && !cb.isLibrary()) {
                return newRsc;
            }
        }
        return null;
    }

    private Problem checkParametersForClass(boolean subclasses, boolean transitively) {
        return null;
    }

    private Problem setParametersForClass(boolean subclasses, boolean directOnly) {
        this.subclasses = subclasses;
        this.directOnly = directOnly;
        return null;
    }

    public void start(ProgressEvent event) {
        this.fireProgressListenerStart(event.getOperationType(), event.getCount());
    }

    public void step(ProgressEvent event) {
        this.fireProgressListenerStep();
    }

    public void stop(ProgressEvent event) {
        this.fireProgressListenerStop();
    }
}

