/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.ErrorPanel;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;

public abstract class PanelView
extends JPanel {
    private Node root;
    transient boolean sectionHeaderClicked;
    transient PopupAdapter popupListener;
    private transient ExplorerManager manager;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    transient ErrorPanel errorPanel;

    public PanelView() {
        this.initComponents();
    }

    public void initComponents() {
    }

    void attachErrorPanel(ErrorPanel errorPanel) {
        this.errorPanel = errorPanel;
    }

    public ErrorPanel getErrorPanel() {
        return this.errorPanel;
    }

    protected abstract Error validateView();

    public final void checkValidity() {
        Error error = this.validateView();
        if (error != null) {
            this.errorPanel.setError(error);
        } else {
            this.errorPanel.clearError();
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node r) {
        this.root = r;
    }

    public void setSectionHeaderClicked(boolean value) {
        this.sectionHeaderClicked = value;
    }

    public boolean isSectionHeaderClicked() {
        return this.sectionHeaderClicked;
    }

    public void setPopupAllowed(boolean value) {
        if (this.popupListener == null && value) {
            this.popupListener = new PopupAdapter();
            this.addMouseListener((MouseListener)((Object)this.popupListener));
            return;
        }
        if (this.popupListener != null && !value) {
            this.removeMouseListener((MouseListener)((Object)this.popupListener));
            this.popupListener = null;
            return;
        }
    }

    public abstract void showSelection(Node[] var1);

    public boolean setManagerExploredContextAndSelection(Node value, Node[] nodes) {
        try {
            this.getExplorerManager().setExploredContextAndSelection(value, nodes);
        }
        catch (PropertyVetoException e) {
            return false;
        }
        return true;
    }

    public boolean setManagerSelection(Node[] nodes) {
        try {
            this.getExplorerManager().setSelectedNodes(nodes);
        }
        catch (PropertyVetoException e) {
            return false;
        }
        return true;
    }

    protected boolean selectionAccept(Node[] nodes) {
        return true;
    }

    public void open() {
    }

    public boolean canClose() {
        return true;
    }

    public void addNotify() {
        super.addNotify();
    }

    public ExplorerManager getExplorerManager() {
        return ExplorerManager.find((Component)this);
    }

    private class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        PopupAdapter() {
        }

        protected void showPopup(MouseEvent e) {
            JPopupMenu popup = PanelView.this.getRoot().getContextMenu();
            popup.show(PanelView.this, e.getX(), e.getY());
        }
    }
}

