/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.run.Hyperlink;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.OutputListener;

public final class StandardLogger
extends AntLogger {
    private static final ErrorManager ERR;
    private static final boolean LOGGABLE;
    private static final Pattern CARET_SHOWING_COLUMN;
    private final long mockTotalTime;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StandardLogger() {
        this.mockTotalTime = 0L;
    }

    StandardLogger(long mockTotalTime) {
        this.mockTotalTime = mockTotalTime;
    }

    public boolean interestedInSession(AntSession session) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession session) {
        return true;
    }

    public String[] interestedInTargets(AntSession session) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession session) {
        return AntLogger.ALL_TASKS;
    }

    public int[] interestedInLogLevels(AntSession session) {
        int verb = session.getVerbosity();
        if (!($assertionsDisabled || verb >= 0 && verb <= 4)) {
            throw new AssertionError(verb);
        }
        int[] levels = new int[verb + 1];
        for (int i = 0; i <= verb; ++i) {
            levels[i] = i;
        }
        return levels;
    }

    private SessionData getSessionData(AntSession session) {
        SessionData data = (SessionData)session.getCustomData(this);
        if (data == null) {
            data = new SessionData();
            session.putCustomData(this, data);
        }
        return data;
    }

    public void buildInitializationFailed(AntEvent event) {
        if (event.isConsumed()) {
            return;
        }
        Throwable t = event.getException();
        if (event.getSession().getVerbosity() >= 3) {
            StandardLogger.deliverStackTrace(t, event);
        } else {
            event.getSession().println(t.toString(), true, null);
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)StandardLogger.class, (String)"FMT_target_failed_status", (Object)event.getSession().getDisplayName()));
        event.consume();
    }

    private static void deliverBlockOfTextAsLines(String lines, AntEvent originalEvent, int level) {
        StringTokenizer tok = new StringTokenizer(lines, "\r\n");
        while (tok.hasMoreTokens()) {
            String line = tok.nextToken();
            originalEvent.getSession().deliverMessageLogged(originalEvent, line, level);
        }
    }

    private static void deliverStackTrace(Throwable t, AntEvent originalEvent) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        StandardLogger.deliverBlockOfTextAsLines(sw.toString(), originalEvent, 0);
    }

    public void buildStarted(AntEvent event) {
        if (event.isConsumed()) {
            return;
        }
        this.getSessionData((AntSession)event.getSession()).startTime = System.currentTimeMillis();
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)StandardLogger.class, (String)"FMT_running_ant", (Object)event.getSession().getDisplayName()));
        event.consume();
    }

    public void buildFinished(AntEvent event) {
        if (event.isConsumed()) {
            return;
        }
        AntSession session = event.getSession();
        Throwable t = event.getException();
        long time = System.currentTimeMillis() - this.getSessionData((AntSession)session).startTime;
        if (this.mockTotalTime != 0L) {
            time = this.mockTotalTime;
        }
        if (t == null) {
            session.println(StandardLogger.formatMessageWithTime("FMT_finished_target_printed", time), false, null);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)StandardLogger.class, (String)"FMT_finished_target_status", (Object)session.getDisplayName()));
        } else {
            if (!session.isExceptionConsumed(t)) {
                session.consumeException(t);
                if (t.getClass().getName().equals("org.apache.tools.ant.BuildException") && session.getVerbosity() < 3) {
                    String msg = t.toString();
                    StandardLogger.deliverBlockOfTextAsLines(msg, event, 0);
                } else if (!(t instanceof ThreadDeath) || event.getSession().getVerbosity() >= 3) {
                    StandardLogger.deliverStackTrace(t, event);
                }
            }
            event.getSession().println(StandardLogger.formatMessageWithTime("FMT_target_failed_printed", time), true, null);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)StandardLogger.class, (String)"FMT_target_failed_status", (Object)event.getSession().getDisplayName()));
        }
        event.consume();
    }

    private static String formatMessageWithTime(String key, long millis) {
        int secs = (int)(millis / 1000L);
        int minutes = secs / 60;
        int seconds = secs % 60;
        return NbBundle.getMessage((Class)StandardLogger.class, (String)key, (Object)new Integer(minutes), (Object)new Integer(seconds));
    }

    public void targetStarted(AntEvent event) {
        if (event.isConsumed()) {
            return;
        }
        String name = event.getTargetName();
        if (name != null) {
            int minlevel;
            int n = minlevel = name.length() > 0 && name.charAt(0) == '-' ? 3 : 2;
            if (event.getSession().getVerbosity() >= minlevel) {
                event.getSession().println(NbBundle.getMessage((Class)StandardLogger.class, (String)"MSG_target_started_printed", (Object)name), false, null);
            }
        }
        event.consume();
    }

    public void messageLogged(AntEvent event) {
        OutputListener hyperlink;
        if (event.isConsumed()) {
            return;
        }
        event.consume();
        AntSession session = event.getSession();
        String line = event.getMessage();
        if (LOGGABLE) {
            ERR.log("Received message: " + line);
        }
        if (line.indexOf(10) != -1) {
            StandardLogger.deliverBlockOfTextAsLines(line, event, event.getLogLevel());
            return;
        }
        Matcher m = CARET_SHOWING_COLUMN.matcher(line);
        if (m.matches()) {
            if (LOGGABLE) {
                ERR.log("Looks like a special caret line");
            }
            SessionData data = this.getSessionData(session);
            if (data.lastHyperlink != null) {
                data.lastHyperlink.setColumn1(m.group(1).length() + 1);
                data.lastHyperlink = null;
                return;
            }
        }
        if ((hyperlink = StandardLogger.findHyperlink(session, line)) instanceof Hyperlink) {
            this.getSessionData((AntSession)session).lastHyperlink = (Hyperlink)hyperlink;
        }
        event.getSession().println(line, event.getLogLevel() <= 1, hyperlink);
    }

    public void taskFinished(AntEvent event) {
        this.getSessionData((AntSession)event.getSession()).lastHyperlink = null;
    }

    private static OutputListener findHyperlink(AntSession session, String line) {
        String message;
        int colon1;
        if (line.startsWith("file:///")) {
            line = line.substring(7);
            if (LOGGABLE) {
                ERR.log("removing file:///");
            }
        } else if (line.startsWith("file:")) {
            line = line.substring(5);
            if (LOGGABLE) {
                ERR.log("removing file:");
            }
        } else if (line.length() > 0 && line.charAt(0) == '/') {
            if (LOGGABLE) {
                ERR.log("result: looks like Unix file");
            }
        } else if (line.length() > 2 && line.charAt(1) == ':' && line.charAt(2) == '\\') {
            if (LOGGABLE) {
                ERR.log("result: looks like Windows file");
            }
        } else {
            if (LOGGABLE) {
                ERR.log("result: not a file");
            }
            return null;
        }
        if ((colon1 = line.indexOf(58)) == -1) {
            if (LOGGABLE) {
                ERR.log("result: no colon found");
            }
            return null;
        }
        String fileName = line.substring(0, colon1);
        File file = FileUtil.normalizeFile((File)new File(fileName));
        if (!file.exists()) {
            if (LOGGABLE) {
                ERR.log("result: no FO for " + fileName);
            }
            if ((colon1 = line.indexOf(58, colon1 + 1)) == -1) {
                if (LOGGABLE) {
                    ERR.log("result: no second colon found");
                }
                return null;
            }
            fileName = line.substring(0, colon1);
            file = FileUtil.normalizeFile((File)new File(fileName));
            if (!file.exists()) {
                if (LOGGABLE) {
                    ERR.log("result: no FO for " + fileName);
                }
                return null;
            }
        }
        int line1 = -1;
        int col1 = -1;
        int line2 = -1;
        int col2 = -1;
        int start = colon1 + 1;
        int colon2 = line.indexOf(58, colon1 + 1);
        if (colon2 != -1) {
            try {
                line1 = Integer.parseInt(line.substring(colon1 + 1, colon2).trim());
                start = colon2 + 1;
                int colon3 = line.indexOf(58, colon2 + 1);
                if (colon3 != -1) {
                    col1 = Integer.parseInt(line.substring(colon2 + 1, colon3).trim());
                    start = colon3 + 1;
                    int colon4 = line.indexOf(58, colon3 + 1);
                    if (colon4 != -1) {
                        line2 = Integer.parseInt(line.substring(colon3 + 1, colon4).trim());
                        start = colon4 + 1;
                        int colon5 = line.indexOf(58, colon4 + 1);
                        if (colon5 != -1) {
                            col2 = Integer.parseInt(line.substring(colon4 + 1, colon5).trim());
                            if (col2 == col1) {
                                col2 = -1;
                            }
                            start = colon5 + 1;
                        }
                    }
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((message = line.substring(start).trim()).length() == 0) {
            message = null;
        }
        if (LOGGABLE) {
            ERR.log("Hyperlink: [" + file + "," + line1 + "," + col1 + "," + line2 + "," + col2 + "," + message + "]");
        }
        try {
            return session.createStandardHyperlink(file.toURI().toURL(), message, line1, col1, line2, col2);
        }
        catch (MalformedURLException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)e);
            }
            return null;
        }
    }

    static {
        $assertionsDisabled = !StandardLogger.class.desiredAssertionStatus();
        ERR = ErrorManager.getDefault().getInstance(StandardLogger.class.getName());
        LOGGABLE = ERR.isLoggable(1);
        CARET_SHOWING_COLUMN = Pattern.compile("^( *)\\^$");
    }

    private static final class SessionData {
        public long startTime;
        public Hyperlink lastHyperlink;
    }
}

