/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.awt.Image;
import org.netbeans.modules.tasklist.client.SuggestionPerformer;
import org.netbeans.modules.tasklist.client.SuggestionPriority;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.suggestions.SuggestionChildren;
import org.netbeans.modules.tasklist.suggestions.SuggestionList;
import org.netbeans.modules.tasklist.suggestions.SuggestionNode;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.Line;

public class SuggestionImpl
extends Task
implements Node.Cookie {
    private Object seed = null;
    private SuggestionType stype = null;

    protected SuggestionImpl() {
    }

    public SuggestionImpl(FileObject fo, String summary, SuggestionType stype, SuggestionPerformer action, Object data) {
        super(summary, null);
        this.setFileObject(fo);
        this.seed = data;
        this.stype = stype;
        this.setAction(action);
        if (stype != null) {
            this.setType(stype.getName());
        }
    }

    public String getFileBaseName() {
        DataObject dobj;
        Line l = this.getLine();
        if (l != null && (dobj = (DataObject)l.getLookup().lookup(DataObject.class)) != null) {
            return dobj.getPrimaryFile().getNameExt();
        }
        return "";
    }

    public int getLineNumber() {
        Line l = this.getLine();
        if (l == null) {
            return 0;
        }
        return l.getLineNumber() + 1;
    }

    public Location getLocation() {
        DataObject dobj;
        Line l = this.getLine();
        if (l != null && (dobj = (DataObject)l.getLookup().lookup(DataObject.class)) != null) {
            return new Location(dobj.getPrimaryFile().getPath(), l.getLineNumber());
        }
        return null;
    }

    public String toString() {
        return "SuggestionImpl#" + System.identityHashCode((Object)this) + "[\"" + this.getSummary() + "\", " + this.getFileBaseName() + ":" + this.getLineNumber() + "]";
    }

    public Node[] createNode() {
        if (this.hasSubtasks()) {
            return new Node[]{new SuggestionNode(this, (Children)new SuggestionChildren(this))};
        }
        return new Node[]{new SuggestionNode(this)};
    }

    protected Object clone() {
        SuggestionImpl t = new SuggestionImpl();
        t.copyFrom(this);
        return t;
    }

    protected void copyFrom(SuggestionImpl from) {
        super.copyFrom((Task)from);
        this.seed = from.seed;
        this.stype = from.stype;
    }

    public String getCategory() {
        if (this.stype != null) {
            return this.stype.getLocalizedName();
        }
        return "";
    }

    public int getPriorityNumber() {
        return this.getPriority().intValue();
    }

    protected void setType(String type) {
        super.setType(type);
    }

    public SuggestionType getSType() {
        return this.stype;
    }

    void setSType(SuggestionType stype) {
        this.stype = stype;
        this.setType(stype.getName());
    }

    public Image getIcon() {
        if (super.getIcon() != null) {
            return super.getIcon();
        }
        if (this.stype != null && this.stype.getIconImage() != null) {
            return this.stype.getIconImage();
        }
        return null;
    }

    public Object getSeed() {
        return this.seed;
    }

    public SuggestionPriority getPriority() {
        if (this.seed == SuggestionList.CATEGORY_NODE_SEED) {
            return null;
        }
        return super.getPriority();
    }

    public void setIcon(Image image) {
        super.setIcon(image);
    }

    public static class Location
    implements Comparable {
        public String filename;
        public int line;

        public Location(String filename, int line) {
            this.filename = filename;
            this.line = line;
        }

        public int compareTo(Object o) {
            Location rhs = (Location)o;
            int c1 = this.filename.compareTo(rhs.filename);
            if (c1 != 0) {
                return c1;
            }
            return this.line < rhs.line ? -1 : (this.line == rhs.line ? 0 : 1);
        }

        public String toString() {
            return this.filename + ":" + (this.line + 1);
        }
    }
}

