/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.derby.RegisterDerby;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class DerbyOptions
extends SystemOption {
    private static final long serialVersionUID = 1101894610105398924L;
    public static final String NETBEANS_DERBY_SYSTEM_HOME = "netbeans.derby.system.home";
    static final String PROP_DERBY_LOCATION = "location";
    static final String PROP_DERBY_SYSTEM_HOME = "systemHome";
    static final String INST_DIR = "db-derby-10.1.1.0";
    public static final String DRIVER_CLASS_NET = "org.apache.derby.jdbc.ClientDriver";
    public static final String DRIVER_CLASS_EMBEDDED = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String DRIVER_PATH_NET = "lib/derbyclient.jar";
    private static final String DRIVER_PATH_EMBEDDED = "lib/derby.jar";
    public static final String DRIVER_DISP_NAME_NET = "Java DB (Network)";
    public static final String DRIVER_DISP_NAME_EMBEDDED = "Java DB (Embedded)";
    private static final String DRIVER_NAME_NET = "apache_derby_net";
    private static final String DRIVER_NAME_EMBEDDED = "apache_derby_embedded";

    public static DerbyOptions getDefault() {
        return (DerbyOptions)SharedClassObject.findObject((Class)DerbyOptions.class, (boolean)true);
    }

    public String displayName() {
        return NbBundle.getMessage((Class)DerbyOptions.class, (String)"LBL_DerbyOptions");
    }

    public String getLocation() {
        String location = (String)this.getProperty(PROP_DERBY_LOCATION);
        if (location == null) {
            location = "";
        }
        return location;
    }

    public boolean isLocationNull() {
        return this.getProperty(PROP_DERBY_LOCATION) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(String location) {
        if (location != null && location.length() > 0) {
            File locationFile = new File(location).getAbsoluteFile();
            if (!locationFile.exists()) {
                String message = NbBundle.getMessage((Class)DerbyOptions.class, (String)"ERR_DirectoryDoesNotExist", (Object)locationFile);
                IllegalArgumentException e = new IllegalArgumentException(message);
                ErrorManager.getDefault().annotate((Throwable)e, 256, message, message, null, null);
                throw e;
            }
            if (!DerbyOptions.isDerbyInstallLocation(locationFile)) {
                String message = NbBundle.getMessage((Class)DerbyOptions.class, (String)"ERR_InvalidDerbyLocation", (Object)locationFile);
                IllegalArgumentException e = new IllegalArgumentException(message);
                ErrorManager.getDefault().annotate((Throwable)e, 256, message, message, null, null);
                throw e;
            }
        }
        Object object = this.getLock();
        synchronized (object) {
            if (!this.isReadExternal()) {
                DerbyOptions.stopDerbyServer();
            }
            if (location != null && location.length() <= 0) {
                location = DerbyOptions.getDefaultInstallLocation();
            }
            if (!this.isReadExternal()) {
                DerbyOptions.registerDrivers(location);
            }
            this.putProperty(PROP_DERBY_LOCATION, location, true);
        }
    }

    public String getSystemHome() {
        String systemHome = (String)this.getProperty(PROP_DERBY_SYSTEM_HOME);
        if (systemHome == null) {
            systemHome = System.getProperty(NETBEANS_DERBY_SYSTEM_HOME);
        }
        if (systemHome == null) {
            systemHome = "";
        }
        return systemHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemHome(String derbySystemHome) {
        if (derbySystemHome != null && derbySystemHome.length() > 0) {
            File derbySystemHomeFile = new File(derbySystemHome).getAbsoluteFile();
            if (!derbySystemHomeFile.exists() || !derbySystemHomeFile.isDirectory()) {
                String message = NbBundle.getMessage((Class)DerbyOptions.class, (String)"ERR_DirectoryDoesNotExist", (Object)derbySystemHomeFile);
                IllegalArgumentException e = new IllegalArgumentException(message);
                ErrorManager.getDefault().annotate((Throwable)e, 256, message, message, null, null);
                throw e;
            }
            if (!derbySystemHomeFile.canWrite()) {
                String message = NbBundle.getMessage((Class)DerbyOptions.class, (String)"ERR_DirectoryIsNotWritable", (Object)derbySystemHomeFile);
                IllegalArgumentException e = new IllegalArgumentException(message);
                ErrorManager.getDefault().annotate((Throwable)e, 256, message, message, null, null);
                throw e;
            }
        }
        Object object = this.getLock();
        synchronized (object) {
            if (!this.isReadExternal()) {
                DerbyOptions.stopDerbyServer();
            }
            this.putProperty(PROP_DERBY_SYSTEM_HOME, derbySystemHome, true);
        }
    }

    static String getDefaultInstallLocation() {
        File location = InstalledFileLocator.getDefault().locate(INST_DIR, null, false);
        if (location == null) {
            return null;
        }
        if (!DerbyOptions.isDerbyInstallLocation(location)) {
            return null;
        }
        return location.getAbsolutePath();
    }

    private static boolean isDerbyInstallLocation(File location) {
        File libDir = new File(location, "lib");
        if (!libDir.exists()) {
            return false;
        }
        File[] libs = libDir.listFiles();
        return libs != null && libs.length > 0;
    }

    private static void stopDerbyServer() {
        DatabaseConnection[] dbconn = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < dbconn.length; ++i) {
            if (!RegisterDerby.getDefault().acceptsDatabaseURL(dbconn[i].getDatabaseURL())) continue;
            ConnectionManager.getDefault().disconnect(dbconn[i]);
        }
        RegisterDerby.getDefault().stop();
    }

    private static void registerDrivers(final String newLocation) {
        try {
            Repository.getDefault().getDefaultFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    DerbyOptions.registerDriver(DerbyOptions.DRIVER_NAME_NET, DerbyOptions.DRIVER_DISP_NAME_NET, DerbyOptions.DRIVER_CLASS_NET, DerbyOptions.DRIVER_PATH_NET, newLocation);
                    DerbyOptions.registerDriver(DerbyOptions.DRIVER_NAME_EMBEDDED, DerbyOptions.DRIVER_DISP_NAME_EMBEDDED, DerbyOptions.DRIVER_CLASS_EMBEDDED, DerbyOptions.DRIVER_PATH_EMBEDDED, newLocation);
                }
            });
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private static void registerDriver(String driverName, String driverDisplayName, String driverClass, String driverRelativeFile, String newLocation) {
        File newDriverFile;
        JDBCDriver[] drivers = JDBCDriverManager.getDefault().getDrivers(driverClass);
        for (int i = 0; i < drivers.length; ++i) {
            JDBCDriver driver = drivers[i];
            URL[] urls = driver.getURLs();
            String currentLocation = DerbyOptions.getDefault().getLocation();
            if (currentLocation == null) continue;
            boolean fromCurrentLocation = true;
            for (int j = 0; j < urls.length; ++j) {
                String driverFile;
                File file;
                FileObject fo = URLMapper.findFileObject((URL)urls[j]);
                if (fo != null && (file = FileUtil.toFile((FileObject)fo)) != null && (driverFile = file.getAbsolutePath()).startsWith(currentLocation)) continue;
                fromCurrentLocation = false;
                break;
            }
            if (!fromCurrentLocation) continue;
            try {
                JDBCDriverManager.getDefault().removeDriver(driver);
                continue;
            }
            catch (DatabaseException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        if (newLocation != null && newLocation.length() >= 0 && (newDriverFile = new File(newLocation, driverRelativeFile)).exists()) {
            try {
                JDBCDriver newDriver = JDBCDriver.create((String)driverName, (String)driverDisplayName, (String)driverClass, (URL[])new URL[]{newDriverFile.toURI().toURL()});
                JDBCDriverManager.getDefault().addDriver(newDriver);
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (DatabaseException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }
}

