/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.actions.Presenter;

public class GoToSourceAction
extends AbstractAction
implements Presenter.Popup {
    private String className;
    private ClassPath classPath;
    private String actionName;

    public GoToSourceAction(ClassPath classPath, String className, String actionName) {
        this.classPath = classPath;
        this.className = className;
        this.actionName = actionName;
    }

    public void actionPerformed(ActionEvent e) {
        this.openSourceFO(this.getFileObject());
    }

    public Object getValue(String key) {
        if ("Name".equals(key)) {
            return this.actionName;
        }
        return super.getValue(key);
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem(this);
    }

    private FileObject getFileObject() {
        assert (this.className != null) : "cannot find null className";
        return this.classPath.findResource(this.className.replace('.', '/') + ".java");
    }

    private void openSourceFO(FileObject fo) {
        DataObject dob;
        if (fo == null) {
            return;
        }
        try {
            dob = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            dob = null;
        }
        if (dob != null) {
            EditCookie ec = (EditCookie)dob.getCookie(EditCookie.class);
            if (ec != null) {
                ec.edit();
            } else {
                OpenCookie oc = (OpenCookie)dob.getCookie(OpenCookie.class);
                if (oc != null) {
                    oc.open();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }
}

