/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.rename;

import java.text.MessageFormat;
import java.util.List;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.refactoring.EntityAnnotationReference;
import org.netbeans.modules.j2ee.refactoring.EntityAssociationResolver;
import org.netbeans.modules.j2ee.refactoring.PersistenceRefactoringUtil;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.rename.AbstractRenameRefactoringElement;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class EntityRenameRefactoring {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, String newName, RefactoringElementsBag refactoringElements) {
        if (!(refObject instanceof Feature)) {
            return null;
        }
        JMIUtils.beginJmiTransaction();
        boolean rollback = true;
        try {
            Feature property = (Feature)refObject;
            JavaClass jc = null;
            if (property.refImmediateComposite() instanceof JavaClass) {
                jc = (JavaClass)property.refImmediateComposite();
            }
            if (jc != null && PersistenceRefactoringUtil.isEntity((AnnotableElement)jc)) {
                List<JavaClass> allEntities = PersistenceRefactoringUtil.getEntitiesInProject(jc);
                EntityAssociationResolver resolver = new EntityAssociationResolver(jc, allEntities);
                List<EntityAnnotationReference> references = resolver.getMappedByReferences(property);
                for (EntityAnnotationReference elem : references) {
                    Resource res = elem.getReferring().getResource();
                    FileObject fo = JavaModel.getFileObject((Resource)res);
                    EntityRenameRefactoringElement refactoringElem = new EntityRenameRefactoringElement(elem, property.getName(), newName, fo);
                    refactoringElements.add(refactoring, (RefactoringElementImplementation)refactoringElem);
                }
            }
            rollback = false;
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
        return null;
    }

    private static class EntityRenameRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        private EntityAnnotationReference reference;
        private String newPropertyName;

        public EntityRenameRefactoringElement(EntityAnnotationReference reference, String oldName, String newName, FileObject parentFile) {
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
            this.reference = reference;
            this.newPropertyName = Utility.getPropertyName(newName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getOldValue() {
            JMIUtils.beginJmiTransaction();
            boolean rollback = true;
            String oldValue = null;
            try {
                oldValue = ((StringLiteral)this.reference.getAttributeValue().getValue()).getValue();
                rollback = false;
            }
            finally {
                JMIUtils.endJmiTransaction((boolean)rollback);
            }
            return oldValue;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.getOldValue(), this.newPropertyName};
            return MessageFormat.format(NbBundle.getMessage(EntityRenameRefactoring.class, (String)"TXT_EntityAnnotationRename"), args);
        }

        public void performExternalChange() {
        }

        public void undoExternalChange() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performChange() {
            JMIUtils.beginJmiTransaction((boolean)true);
            boolean rollback = true;
            StringLiteral stringLiteral = null;
            try {
                String newPropertyName = Utility.getPropertyName(this.newName);
                stringLiteral = ((JavaModelPackage)this.reference.getAnnotation().refImmediatePackage()).getStringLiteral().createStringLiteral(newPropertyName);
                this.reference.getAttributeValue().setValue((InitialValue)stringLiteral);
                rollback = false;
            }
            finally {
                JMIUtils.endJmiTransaction((boolean)rollback);
            }
        }
    }
}

