/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.webservices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.ServiceImplBean;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.dd.impl.webservices.CommonDDAccess;
import org.netbeans.modules.j2ee.metadata.NNModelBuilder;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsAnnotationListener
extends NNModelBuilder {
    private static final String JAVAX_EJB_WEBSERVICE = "javax.jws.WebService";
    private static final Collection<String> primaryAnnotations = Arrays.asList("javax.jws.WebService");
    private Map<String, String> nn2ModelMapping;
    private Webservices ws;
    private ClassPath cp;

    public WsAnnotationListener(Webservices ws, ClassPath cp) {
        super((BaseBean)ws);
        this.ws = ws;
        this.cp = cp;
        this.initNN2ModelMapping();
    }

    protected Map<String, String> getAnnotation2ModelMapping() {
        return this.nn2ModelMapping;
    }

    public ClassPath getClassPath() {
        return this.cp;
    }

    public Collection<String> getPrimaryAnnotations() {
        return primaryAnnotations;
    }

    public void classRemoved(String fqn) {
        WebserviceDescription wsd = this.findWebserviceByServiceEndpointInterface(fqn);
        if (wsd != null) {
            this.ws.removeWebserviceDescription(wsd);
        }
    }

    public void removeClassAnnotation(JavaClass javaClass, Annotation nn, AnnotationType at) {
        String wsName;
        WebserviceDescription wsd;
        String annotationClass;
        FileObject fo = JavaModel.getFileObject((Resource)javaClass.getResource());
        if (this.isInSourceGroup(fo) && JAVAX_EJB_WEBSERVICE.equals(annotationClass = at.getName()) && (wsd = this.getWebservice(wsName = this.getWSName(javaClass, nn))) != null) {
            this.ws.removeWebserviceDescription(wsd);
        }
    }

    public void addClassAnnotation(JavaClass javaClass, Annotation annotation, AnnotationType annotationType) {
        String annotationClass;
        FileObject fo = JavaModel.getFileObject((Resource)javaClass.getResource());
        if (this.isInSourceGroup(fo) && JAVAX_EJB_WEBSERVICE.equals(annotationClass = annotationType.getName())) {
            EjbJar apiEjbJar;
            String wsName = this.getWSName(javaClass, annotation);
            WebserviceDescription wsd = this.getWebservice(wsName);
            if (wsd == null) {
                wsd = this.ws.newWebserviceDescription();
                wsd.setWebserviceDescriptionName(wsName);
                this.ws.addWebserviceDescription(wsd);
            }
            boolean isNewPortComponent = false;
            PortComponent pc = (PortComponent)CommonDDAccess.findBeanByName((BaseBean)wsd, "PortComponent", "PortComponentName", wsName);
            if (pc == null) {
                pc = wsd.newPortComponent();
                pc.setPortComponentName(this.getPCName(javaClass, annotation));
                isNewPortComponent = true;
            }
            pc.setServiceEndpointInterface(javaClass.getName());
            boolean isNewServiceImplBean = false;
            ServiceImplBean sib = pc.getServiceImplBean();
            if (sib == null) {
                sib = pc.newServiceImplBean();
                isNewServiceImplBean = true;
            }
            if ((apiEjbJar = EjbJar.getEjbJar((FileObject)fo)) != null) {
                Session session;
                EnterpriseBeans ebs;
                org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = null;
                try {
                    ejbJar = DDProvider.getDefault().getMergedDDRoot(apiEjbJar.getMetadataUnit());
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                if (ejbJar != null && (ebs = ejbJar.getEnterpriseBeans()) != null && (session = (Session)ebs.findBeanByName("Session", "EjbClass", javaClass.getName())) != null) {
                    sib.setEjbLink(session.getEjbName());
                }
            }
            if (sib.getEjbLink() == null) {
                sib.setServletLink(javaClass.getSimpleName());
            }
            if (isNewServiceImplBean) {
                pc.setServiceImplBean(sib);
            }
            if (isNewPortComponent) {
                wsd.addPortComponent(pc);
            }
        }
    }

    private String getWSName(JavaClass javaClass, Annotation annotation) {
        InitialValue o;
        AttributeValue nameAV = WsAnnotationListener.findAttribute(annotation, "serviceName");
        String wsName = null;
        if (nameAV != null && (o = nameAV.getValue()) instanceof StringLiteral) {
            wsName = ((StringLiteral)o).getValue();
        }
        if (wsName == null) {
            wsName = javaClass.getSimpleName() + "Service";
        }
        return wsName;
    }

    private String getPCName(JavaClass javaClass, Annotation annotation) {
        InitialValue o;
        AttributeValue nameAV = WsAnnotationListener.findAttribute(annotation, "name");
        String wsName = null;
        if (nameAV != null && (o = nameAV.getValue()) instanceof StringLiteral) {
            wsName = ((StringLiteral)o).getValue();
        }
        if (wsName == null) {
            wsName = javaClass.getSimpleName();
        }
        return wsName;
    }

    private boolean isInSourceGroup(FileObject fo) {
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        assert (project != null);
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        for (int i = 0; i < sourceGroups.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sourceGroups[i].getRootFolder(), (FileObject)fo)) continue;
            return true;
        }
        return false;
    }

    private WebserviceDescription getWebservice(String name) {
        return (WebserviceDescription)this.ws.findBeanByName("WebserviceDescription", "WebserviceDescriptionName", name);
    }

    private WebserviceDescription findWebserviceByServiceEndpointInterface(String fqn) {
        if (fqn == null) {
            return null;
        }
        for (WebserviceDescription wsd : this.ws.getWebserviceDescription()) {
            for (PortComponent pc : wsd.getPortComponent()) {
                if (!fqn.equals(pc.getServiceEndpointInterface())) continue;
                return wsd;
            }
        }
        return null;
    }

    private void initNN2ModelMapping() {
        this.nn2ModelMapping = new HashMap<String, String>();
        HashMap imaps = new HashMap();
        this.nn2ModelMapping.put(JAVAX_EJB_WEBSERVICE, "WebserviceDescription#!serviceName=WebserviceDescriptionName;WebserviceDescriptionName=$JAVACLASS_SIMPLE");
    }

    private static AttributeValue findAttribute(Annotation a, String attributeName) {
        List attributeValues = a.getAttributeValues();
        for (AttributeValue av : attributeValues) {
            if (!av.getName().equals(attributeName)) continue;
            return av;
        }
        return null;
    }
}

