/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class SpecificationVersion
implements Comparable {
    private static final Map parseCache = new HashMap(200);
    private final int[] digits;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpecificationVersion(String version) throws NumberFormatException {
        Map map = parseCache;
        synchronized (map) {
            int[] d = (int[])parseCache.get(version);
            if (d == null) {
                d = SpecificationVersion.parse(version);
                parseCache.put(version.intern(), d);
            }
            this.digits = d;
        }
    }

    private static int[] parse(String version) throws NumberFormatException {
        StringTokenizer tok = new StringTokenizer(version, ".", true);
        int len = tok.countTokens();
        if (len % 2 == 0) {
            throw new NumberFormatException("Even number of pieces in a spec version: `" + version + "'");
        }
        int[] digits = new int[len / 2 + 1];
        int i = 0;
        boolean expectingNumber = true;
        while (tok.hasMoreTokens()) {
            if (expectingNumber) {
                expectingNumber = false;
                int piece = Integer.parseInt(tok.nextToken());
                if (piece < 0) {
                    throw new NumberFormatException("Spec version component <0: " + piece);
                }
                digits[i++] = piece;
                continue;
            }
            if (!".".equals(tok.nextToken())) {
                throw new NumberFormatException("Expected dot in spec version: `" + version + "'");
            }
            expectingNumber = true;
        }
        return digits;
    }

    public int compareTo(Object o) {
        int[] od = ((SpecificationVersion)o).digits;
        int len1 = this.digits.length;
        int len2 = od.length;
        int max = Math.max(len1, len2);
        for (int i = 0; i < max; ++i) {
            int d2;
            int d1 = i < len1 ? this.digits[i] : 0;
            int n = d2 = i < len2 ? od[i] : 0;
            if (d1 == d2) continue;
            return d1 - d2;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SpecificationVersion)) {
            return false;
        }
        int len = this.digits.length;
        int[] d = ((SpecificationVersion)o).digits;
        if (len != d.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.digits[i] == d[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 925295;
        int len = this.digits.length;
        for (int i = 0; i < len; ++i) {
            hash ^= this.digits[i] << i;
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.digits.length * 3 + 1);
        for (int i = 0; i < this.digits.length; ++i) {
            if (i > 0) {
                buf.append('.');
            }
            buf.append(this.digits[i]);
        }
        return buf.toString();
    }
}

