/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.jsploader.JspParserAccess;
import org.netbeans.modules.web.core.jsploader.TimeReference;
import org.netbeans.modules.web.core.jsploader.api.TagLibParseCookie;
import org.netbeans.modules.web.core.syntax.spi.ErrorAnnotation;
import org.netbeans.modules.web.core.syntax.spi.JSPColoringData;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.JspParserFactory;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class TagLibParseSupport
implements Node.Cookie,
TagLibParseCookie {
    private FileObject jspFile;
    private boolean documentDirty;
    private RequestProcessor.Task parsingTask = null;
    private static RequestProcessor requestProcessor;
    private Object openedLock = new Object();
    private boolean opened;
    private static final int WAIT_FOR_EDITOR_TIMEOUT = 15000;
    private WeakReference jspColoringDataRef;
    private TimeReference jspOpenInfoRef;
    private SoftReference parseResultRef;
    private SoftReference parseResultSuccessfulRef;
    private Object parseResultLock = new Object();
    private Object openInfoLock = new Object();
    private Object parseResultSuccessfulRefStrongReference = null;
    private boolean wasAnEditorPaneChangeEvent = false;
    private boolean parsingTaskCancelled = false;
    private ErrorAnnotation annotations;
    private boolean hasError = false;

    public TagLibParseSupport(FileObject jspFile) {
        this.jspFile = jspFile;
        if (requestProcessor == null) {
            requestProcessor = new RequestProcessor("background jsp parsing", 10);
        }
        this.annotations = new ErrorAnnotation(jspFile);
    }

    public JSPColoringData getJSPColoringData() {
        return this.getJSPColoringData(true);
    }

    private WebModule getWebModule(FileObject fo) {
        FileObject wmRoot;
        WebModule wm = WebModule.getWebModule((FileObject)fo);
        if (wm != null && (wmRoot = wm.getDocumentBase()) != null && (fo == wmRoot || FileUtil.isParentOf((FileObject)wmRoot, (FileObject)fo))) {
            return wm;
        }
        return null;
    }

    JSPColoringData getJSPColoringData(boolean prepare) {
        Object o;
        if (this.jspColoringDataRef != null && (o = this.jspColoringDataRef.get()) != null) {
            return (JSPColoringData)o;
        }
        JSPColoringData jcd = new JSPColoringData((Object)this);
        this.jspColoringDataRef = new WeakReference<JSPColoringData>(jcd);
        if (prepare) {
            this.prepare();
        }
        return jcd;
    }

    void setDocumentDirty(boolean b) {
        this.documentDirty = b;
    }

    boolean isDocumentDirty() {
        return this.documentDirty;
    }

    RequestProcessor.Task autoParse() {
        if (!this.isDocumentDirty()) {
            return requestProcessor.post(new Runnable(){

                public void run() {
                }
            });
        }
        return this.parseObject(1);
    }

    public RequestProcessor.Task prepare() {
        return this.parseObject(9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestProcessor.Task parseObject(int priority) {
        this.parsingTaskCancelled = false;
        if (!this.wasAnEditorPaneChangeEvent) {
            ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(), "The TagLibParseSupport.parseObject() is called before editor supoort is created!");
        }
        Object object = this.parseResultLock;
        synchronized (object) {
            RequestProcessor.Task t = this.parsingTask;
            if (t != null) {
                t.setPriority(Math.max(t.getPriority(), priority));
                return t;
            }
            this.setDocumentDirty(false);
            this.parsingTask = t = requestProcessor.post((Runnable)new ParsingRunnable(), 0, priority);
            return this.parsingTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEditorOpened(boolean state) {
        this.wasAnEditorPaneChangeEvent = true;
        Object object = this.openedLock;
        synchronized (object) {
            this.opened = state;
            if (this.opened) {
                this.openedLock.notifyAll();
            } else {
                this.parseResultSuccessfulRefStrongReference = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelParsingTask() {
        if (this.parsingTask != null) {
            boolean removed = this.parsingTask.cancel();
            this.parsingTask = null;
            this.jspColoringDataRef = null;
        }
        this.parsingTaskCancelled = true;
        Object object = this.openedLock;
        synchronized (object) {
            this.openedLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JspParserAPI.JspOpenInfo getCachedOpenInfo(boolean preferCurrent, boolean useEditor) {
        Object object = this.openInfoLock;
        synchronized (object) {
            JspParserAPI.JspOpenInfo info;
            if (preferCurrent) {
                this.jspOpenInfoRef = null;
            }
            long timestamp = this.jspFile.lastModified().getTime();
            if (this.jspOpenInfoRef == null) {
                this.jspOpenInfoRef = new TimeReference();
            }
            if ((info = (JspParserAPI.JspOpenInfo)this.jspOpenInfoRef.get(timestamp)) == null) {
                info = JspParserFactory.getJspParser().getJspOpenInfo(this.jspFile, JspParserAccess.getJspParserWM(this.getWebModule(this.jspFile)), useEditor);
                this.jspOpenInfoRef.put(info, timestamp);
            }
            return info;
        }
    }

    public JspParserAPI.ParseResult getCachedParseResult(boolean successfulOnly, boolean preferCurrent) {
        return this.getCachedParseResult(successfulOnly, preferCurrent, false);
    }

    public JspParserAPI.ParseResult getCachedParseResult(boolean successfulOnly, boolean preferCurrent, boolean forceParse) {
        SoftReference myRef;
        boolean needToParse = forceParse;
        if (preferCurrent && this.isDocumentDirty()) {
            needToParse = true;
        }
        if (this.parseResultRef == null) {
            needToParse = true;
        }
        JspParserAPI.ParseResult ret = null;
        SoftReference softReference = myRef = successfulOnly ? this.parseResultSuccessfulRef : this.parseResultRef;
        if (myRef != null) {
            ret = (JspParserAPI.ParseResult)myRef.get();
        }
        if (ret == null && !successfulOnly) {
            needToParse = true;
        }
        if (needToParse) {
            RequestProcessor.Task t = this.prepare();
            t.waitFinished();
            SoftReference softReference2 = myRef = successfulOnly ? this.parseResultSuccessfulRef : this.parseResultRef;
            if (myRef != null) {
                ret = (JspParserAPI.ParseResult)myRef.get();
            }
        }
        return ret;
    }

    private class ParsingRunnable
    implements Runnable {
        JspParserAPI.ParseResult locResult = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = TagLibParseSupport.this.openedLock;
            synchronized (object) {
                if (!TagLibParseSupport.this.opened) {
                    try {
                        TagLibParseSupport.this.openedLock.wait(15000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Thread.currentThread().setPriority(4);
                }
            }
            long a = System.currentTimeMillis();
            if (!TagLibParseSupport.this.parsingTaskCancelled && TagLibParseSupport.this.getWebModule(TagLibParseSupport.this.jspFile) != null) {
                JspParserAPI parser = JspParserFactory.getJspParser();
                if (parser == null) {
                    throw new InternalError();
                }
                TagLibParseSupport.this.getJSPColoringData(false).parsingStarted();
                this.locResult = parser.analyzePage(TagLibParseSupport.this.jspFile, JspParserAccess.getJspParserWM(TagLibParseSupport.this.getWebModule(TagLibParseSupport.this.jspFile)), 1);
                assert (this.locResult != null);
                Object object2 = TagLibParseSupport.this.parseResultLock;
                synchronized (object2) {
                    TagLibParseSupport.this.parseResultRef = new SoftReference<JspParserAPI.ParseResult>(this.locResult);
                    if (this.locResult.isParsingSuccess()) {
                        TagLibParseSupport.this.parseResultSuccessfulRef = new SoftReference<JspParserAPI.ParseResult>(this.locResult);
                        TagLibParseSupport.this.parseResultSuccessfulRefStrongReference = this.locResult;
                        if (TagLibParseSupport.this.hasError) {
                            TagLibParseSupport.this.annotations.annotate(new ErrorAnnotation.ErrorInfo[0]);
                            TagLibParseSupport.this.hasError = false;
                        }
                    }
                    if (!this.locResult.isParsingSuccess()) {
                        for (int i = 0; i < this.locResult.getErrors().length; ++i) {
                            JspParserAPI.ErrorDescriptor err = this.locResult.getErrors()[i];
                            TagLibParseSupport.this.annotations.annotate(new ErrorAnnotation.ErrorInfo[]{new ErrorAnnotation.ErrorInfo(this.translate(err.getErrorMessage()), err.getLine(), err.getColumn(), 1)});
                        }
                        if (!TagLibParseSupport.this.hasError) {
                            TagLibParseSupport.this.hasError = true;
                        }
                    }
                    PageInfo pageInfo = this.locResult.getPageInfo();
                    TagLibParseSupport.this.parsingTask = null;
                    if (pageInfo == null) {
                        return;
                    }
                    Map prefixMapper = null;
                    if (pageInfo.getXMLPrefixMapper().size() > 0) {
                        prefixMapper = pageInfo.getApproxXmlPrefixMapper();
                        if (prefixMapper.size() == 0) {
                            prefixMapper = pageInfo.getXMLPrefixMapper();
                        }
                        prefixMapper.putAll(pageInfo.getJspPrefixMapper());
                    } else {
                        prefixMapper = pageInfo.getJspPrefixMapper();
                    }
                    TagLibParseSupport.this.getJSPColoringData(false).applyParsedData(pageInfo.getTagLibraries(), prefixMapper, pageInfo.isELIgnored(), TagLibParseSupport.this.getCachedOpenInfo(false, false).isXmlSyntax(), this.locResult.isParsingSuccess());
                }
            }
        }

        private String translate(String text) {
            String value = text.replaceAll("&lt;", "<");
            value = value.replaceAll("&gt;", ">");
            return value;
        }
    }
}

