/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mdr;

import java.io.IOException;
import org.netbeans.modules.mdr.MDRDataObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;

public class MDRLoader
extends UniFileLoader {
    private static final String MDR_EXTENSION = "mdr";

    public MDRLoader() {
        super("org.netbeans.modules.mdr.MDRDataObject");
        ExtensionList mdrExt = new ExtensionList();
        mdrExt.addExtension(MDR_EXTENSION);
        this.setExtensions(mdrExt);
    }

    public MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new MDRDataObject(primaryFile, (MultiFileLoader)this);
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        FileObject result = super.findPrimaryFile(fo);
        if (result == null) {
            return null;
        }
        String fileName = result.getName();
        if (fileName.indexOf(91) == -1 || fileName.indexOf(93) == -1) {
            return null;
        }
        return result;
    }
}

