/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mdr;

import java.util.Enumeration;
import java.util.HashMap;
import org.netbeans.api.mdr.MDRManager;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.ClassLoaderProvider;
import org.netbeans.modules.mdr.MDRDataObject;
import org.netbeans.modules.mdr.MDRDescriptor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

public class MDRManagerImpl
extends MDRManager
implements FileChangeListener,
NBMDRepositoryImpl.ShutdownListener {
    private static final String FOLDER_REPOSITORY = "MDRepositories";
    private static final String DEFAULT_REPOSITORY = "Default";
    private HashMap repositoryMap = null;
    private FileObject repFolder = null;
    private static MDRManagerImpl instance = null;
    private ProgressListener progress = null;
    private boolean stopFired = false;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    static synchronized void uninstall() {
        if (instance != null) {
            instance.uninstallMe();
        }
    }

    private void uninstallMe() {
        this.repositoryMap = null;
        if (this.repFolder != null) {
            this.repFolder.removeFileChangeListener((FileChangeListener)this);
        }
        this.repFolder = null;
    }

    private void refreshChildren() {
        if (this.repFolder == null) {
            this.repFolder = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject(FOLDER_REPOSITORY);
            this.repFolder.addFileChangeListener((FileChangeListener)this);
        }
        this.repositoryMap.clear();
        if (this.repFolder != null) {
            Enumeration en = this.repFolder.getData(false);
            while (en.hasMoreElements()) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)((FileObject)en.nextElement()));
                    if (!(dataObject instanceof MDRDataObject)) continue;
                    this.repositoryMap.put(dataObject.getName(), dataObject);
                    ErrorManager.getDefault().log("found repository: " + dataObject.getName());
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {}
            }
        }
    }

    private void init() {
        if (this.repositoryMap == null) {
            this.repositoryMap = new HashMap();
            this.refreshChildren();
        }
    }

    public MDRManagerImpl() {
        instance = this;
    }

    public void shutdownAll() {
        int i;
        String[] names = this.getRepositoryNames();
        MDRepository[] repos = new MDRepository[names.length];
        int stepCount = 0;
        for (i = 0; i < names.length; ++i) {
            repos[i] = this.getRepository(names[i]);
            if (repos[i] instanceof NBMDRepositoryImpl) {
                stepCount += ((NBMDRepositoryImpl)repos[i]).getShutdownSteps();
                continue;
            }
            ++stepCount;
        }
        this.fireProgressListenerStart(stepCount);
        for (i = 0; i < names.length; ++i) {
            ((NBMDRepositoryImpl)repos[i]).addShutdownListener(this);
            repos[i].shutdown();
            ((NBMDRepositoryImpl)repos[i]).removeShutdownListener(this);
        }
        this.fireProgressListenerStop();
    }

    public void shutdown() {
    }

    public void stepFinished() {
        this.fireProgressListenerStep();
    }

    public boolean setProgressListener(ProgressListener pl) {
        boolean shutdownListenerRegistered = false;
        if (this.progress == null) {
            this.progress = pl;
            shutdownListenerRegistered = true;
        }
        return shutdownListenerRegistered && !this.stopFired;
    }

    private void fireProgressListenerStart(int count) {
        if (this.progress == null) {
            return;
        }
        this.progress.start(count);
    }

    private void fireProgressListenerInitialize() {
        if (this.progress == null) {
            return;
        }
        this.progress.init();
    }

    public void fireProgressListenerStep() {
        if (this.progress == null) {
            return;
        }
        this.progress.step();
    }

    private void fireProgressListenerStop() {
        if (this.progress == null) {
            this.stopFired = true;
            return;
        }
        this.progress.stop();
    }

    public MDRepository getRepository(String name) {
        this.init();
        MDRDataObject dataObject = (MDRDataObject)((Object)this.repositoryMap.get(name));
        if (dataObject == null) {
            return null;
        }
        MDRDescriptor repository = dataObject.getDescriptor();
        return repository.getMDRInstance();
    }

    public MDRepository getDefaultRepository() {
        return this.getRepository(DEFAULT_REPOSITORY);
    }

    public String[] getRepositoryNames() {
        this.init();
        String[] result = new String[]{};
        result = this.repositoryMap.keySet().toArray(result);
        return result;
    }

    public void fileFolderCreated(FileEvent fe) {
        this.refreshChildren();
    }

    public void fileDataCreated(FileEvent fe) {
        this.refreshChildren();
    }

    public void fileChanged(FileEvent fe) {
        this.refreshChildren();
    }

    public void fileDeleted(FileEvent fe) {
        this.refreshChildren();
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.refreshChildren();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        this.refreshChildren();
    }

    void preShutdownAll() {
        this.fireProgressListenerInitialize();
    }

    static {
        BaseObjectHandler.setClassLoaderProvider(new CLProviderImpl());
    }

    public static interface ProgressListener {
        public void init();

        public void start(int var1);

        public void step();

        public void stop();
    }

    private static class CLProviderImpl
    implements ClassLoaderProvider {
        private CLProviderImpl() {
        }

        public ClassLoader getClassLoader() {
            return (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = MDRManagerImpl.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
        }

        public Class defineClass(String className, byte[] classFile) {
            return null;
        }
    }
}

