/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.ChicletWrapper;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

final class AquaEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final AquaTabPainter AquaTabPainter = new AquaTabPainter();
    static final int TOP_INSET = 0;
    static final int LEFT_INSET = 3;
    static final int RIGHT_INSET = 6;
    static final int BOTTOM_INSET = 2;
    private static final ChicletWrapper chiclet = new ChicletWrapper();

    public AquaEditorTabCellRenderer() {
        super(AquaTabPainter, AquaTabPainter, AquaTabPainter, new Dimension(23, 8));
    }

    protected int getCaptionYAdjustment() {
        return 0;
    }

    protected int getIconYAdjustment() {
        return -1;
    }

    public Dimension getPadding() {
        Dimension d = super.getPadding();
        d.width = this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton") ? 23 : 13;
        return d;
    }

    private static class AquaTabPainter
    implements TabPainter {
        private static Insets insets = new Insets(0, 3, 2, 6);

        public Insets getBorderInsets(Component c) {
            boolean leftmost = ((AquaEditorTabCellRenderer)c).isLeftmost();
            if (leftmost) {
                return new Insets(0, 7, 2, 6);
            }
            return insets;
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            boolean notSupported;
            boolean rightClip = ((AquaEditorTabCellRenderer)jc).isClipRight();
            boolean leftClip = ((AquaEditorTabCellRenderer)jc).isClipLeft();
            boolean bl = notSupported = !((AbstractTabCellRenderer)jc).isShowCloseButton();
            if (leftClip || rightClip || notSupported) {
                rect.x = -100;
                rect.y = -100;
                rect.width = 0;
                rect.height = 0;
            } else {
                int centerY = (bounds.height - 2) / 2 + 0 - 1;
                rect.x = bounds.x + bounds.width - 9;
                rect.y = centerY - 2;
                rect.height = 10;
                rect.width = 10;
                if (((AquaEditorTabCellRenderer)jc).isRightmost()) {
                    rect.x -= 2;
                }
            }
        }

        private void paintCloseButton(Graphics g, JComponent c) {
            if (((AbstractTabCellRenderer)c).isShowCloseButton()) {
                Rectangle r = new Rectangle(0, 0, c.getWidth(), c.getHeight());
                Rectangle cbRect = new Rectangle();
                this.getCloseButtonRectangle(c, cbRect, r);
                cbRect.width -= 5;
                cbRect.height -= 5;
                g.setColor(Color.darkGray);
                g.drawLine(cbRect.x, cbRect.y, cbRect.x + cbRect.width, cbRect.y + cbRect.height);
                g.drawLine(cbRect.x, cbRect.y + cbRect.height, cbRect.x + cbRect.width, cbRect.y);
            }
        }

        public Polygon getInteriorPolygon(Component c) {
            return new Polygon(new int[]{0, c.getWidth(), c.getWidth(), 0}, new int[]{0, 0, c.getHeight(), c.getHeight()}, 4);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if ((((AquaEditorTabCellRenderer)c).getState() & 0x1000) != 0) {
                this.paintCloseButton(g, (JComponent)c);
            }
        }

        public void paintInterior(Graphics g, Component c) {
            float rightarc;
            Rectangle bds = c.getBounds();
            boolean rightmost = ((AquaEditorTabCellRenderer)c).isRightmost();
            boolean rightClip = ((AquaEditorTabCellRenderer)c).isClipRight();
            boolean sel = ((AquaEditorTabCellRenderer)c).isSelected();
            boolean active = ((AquaEditorTabCellRenderer)c).isActive();
            boolean pressed = ((AquaEditorTabCellRenderer)c).isPressed();
            boolean leftClip = ((AquaEditorTabCellRenderer)c).isClipLeft();
            boolean leftmost = ((AquaEditorTabCellRenderer)c).isLeftmost();
            boolean closing = pressed && ((AquaEditorTabCellRenderer)c).inCloseButton();
            boolean attention = !pressed && !closing && ((AquaEditorTabCellRenderer)c).isAttention();
            chiclet.setBounds(0, 0, bds.width, bds.height);
            chiclet.setNotch(rightClip, leftClip);
            int state = 0;
            float leftarc = leftmost && !leftClip ? 0.5f : 0.0f;
            float f = rightarc = rightmost && !rightClip ? 0.5f : 0.0f;
            if (pressed && (rightClip || leftClip)) {
                state |= 1;
            }
            if (active) {
                state |= 4;
            }
            if (sel) {
                state |= 2;
            }
            if (closing) {
                state |= 8;
            }
            if (attention) {
                state |= 0x10;
            }
            chiclet.setArcs(leftarc, rightarc, leftarc, rightarc);
            chiclet.setState(state);
            chiclet.draw((Graphics2D)g);
        }

        public boolean supportsCloseButton(JComponent c) {
            boolean leftClip = ((AquaEditorTabCellRenderer)c).isClipLeft();
            boolean rightClip = ((AquaEditorTabCellRenderer)c).isClipRight();
            boolean supported = ((AquaEditorTabCellRenderer)c).isShowCloseButton();
            return !leftClip && !rightClip && supported;
        }
    }
}

