/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.apache.catalina.cluster.io.ObjectReader;
import org.apache.catalina.cluster.tcp.ClusterReceiverBase;
import org.apache.catalina.cluster.tcp.TcpReplicationThread;
import org.apache.catalina.cluster.tcp.ThreadPool;

public class ReplicationListener
extends ClusterReceiverBase {
    private static final String info = "ReplicationListener/1.2";
    private ThreadPool pool = null;
    private int tcpThreadCount;
    private long tcpSelectorTimeout;
    private Selector selector = null;
    private Object interestOpsMutex = new Object();
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$TcpReplicationThread;

    public String getInfo() {
        return info;
    }

    public long getTcpSelectorTimeout() {
        return this.tcpSelectorTimeout;
    }

    public void setTcpSelectorTimeout(long tcpSelectorTimeout) {
        this.tcpSelectorTimeout = tcpSelectorTimeout;
    }

    public int getTcpThreadCount() {
        return this.tcpThreadCount;
    }

    public void setTcpThreadCount(int tcpThreadCount) {
        this.tcpThreadCount = tcpThreadCount;
    }

    public Object getInterestOpsMutex() {
        return this.interestOpsMutex;
    }

    public void start() {
        try {
            this.pool = new ThreadPool(this.tcpThreadCount, class$org$apache$catalina$cluster$tcp$TcpReplicationThread == null ? (class$org$apache$catalina$cluster$tcp$TcpReplicationThread = ReplicationListener.class$("org.apache.catalina.cluster.tcp.TcpReplicationThread")) : class$org$apache$catalina$cluster$tcp$TcpReplicationThread, this.interestOpsMutex);
        }
        catch (Exception e) {
            log.error((Object)"ThreadPool can initilzed. Listener not started", (Throwable)e);
            return;
        }
        super.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void listen() throws Exception {
        if (this.doListen) {
            log.warn((Object)"ServerSocketChannel allready started");
            return;
        }
        this.doListen = true;
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        ServerSocket serverSocket = serverChannel.socket();
        this.selector = Selector.open();
        serverSocket.bind(new InetSocketAddress(this.getBind(), this.getTcpListenPort()));
        serverChannel.configureBlocking(false);
        serverChannel.register(this.selector, 16);
        while (this.doListen && this.selector != null) {
            try {
                int n = this.selector.select(this.tcpSelectorTimeout);
                if (n == 0) {
                    Object object = this.interestOpsMutex;
                    // MONITORENTER : object
                    // MONITOREXIT : object
                    continue;
                }
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    if (key.isAcceptable()) {
                        ServerSocketChannel server = (ServerSocketChannel)key.channel();
                        SocketChannel channel = server.accept();
                        ObjectReader attach = new ObjectReader(channel, this.selector, this);
                        this.registerChannel(this.selector, channel, 1, attach);
                    }
                    if (key.isReadable()) {
                        this.readDataFromSocket(key);
                    } else {
                        key.interestOps(key.interestOps() & 0xFFFFFFFB);
                    }
                    it.remove();
                }
            }
            catch (ClosedSelectorException cse) {
            }
            catch (CancelledKeyException nx) {
                log.warn((Object)"Replication client disconnected, error when polling key. Ignoring client.");
            }
            catch (Exception x) {
                log.error((Object)"Unable to process request in ReplicationListener", (Throwable)x);
            }
        }
        serverChannel.close();
        if (this.selector == null) return;
        this.selector.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopListening() {
        this.doListen = false;
        if (this.selector != null) {
            try {
                for (int i = 0; i < this.getTcpThreadCount(); ++i) {
                    this.selector.wakeup();
                }
                this.selector.close();
            }
            catch (Exception x) {
                log.error((Object)"Unable to close cluster receiver selector.", (Throwable)x);
            }
            finally {
                this.selector = null;
            }
        }
    }

    protected void registerChannel(Selector selector, SelectableChannel channel, int ops, Object attach) throws Exception {
        if (channel == null) {
            return;
        }
        channel.configureBlocking(false);
        channel.register(selector, ops, attach);
    }

    protected void readDataFromSocket(SelectionKey key) throws Exception {
        TcpReplicationThread worker = (TcpReplicationThread)this.pool.getWorker();
        if (worker == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No TcpReplicationThread available");
            }
        } else {
            worker.serviceChannel(key, this.isSendAck());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

