/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.log;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandUtils;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class LogBuilder
implements Builder {
    private static final String LOGGING_DIR = ": Logging ";
    private static final String RCS_FILE = "RCS file: ";
    private static final String WORK_FILE = "Working file: ";
    private static final String REV_HEAD = "head: ";
    private static final String BRANCH = "branch: ";
    private static final String LOCKS = "locks: ";
    private static final String ACCESS_LIST = "access list: ";
    private static final String SYM_NAME = "symbolic names:";
    private static final String KEYWORD_SUBST = "keyword substitution: ";
    private static final String TOTAL_REV = "total revisions: ";
    private static final String SEL_REV = ";\tselected revisions: ";
    private static final String DESCRIPTION = "description:";
    private static final String REVISION = "revision ";
    private static final String DATE = "date: ";
    private static final String BRANCHES = "branches: ";
    private static final String AUTHOR = "author: ";
    private static final String STATE = "state: ";
    private static final String LINES = "lines: ";
    private static final String COMMITID = "commitid: ";
    private static final String SPLITTER = "----------------------------";
    private static final String FINAL_SPLIT = "=============================================================================";
    private static final String ERROR = ": nothing known about ";
    private static final String NO_FILE = "no file";
    protected EventManager eventManager;
    protected BasicCommand logCommand;
    protected LogInformation logInfo;
    protected LogInformation.Revision revision;
    protected String fileDirectory;
    private boolean addingSymNames;
    private boolean addingDescription;
    private boolean addingLogMessage;
    private StringBuffer tempBuffer = null;
    private List messageList;

    public LogBuilder(EventManager eventMan, BasicCommand command) {
        this.logCommand = command;
        this.eventManager = eventMan;
        this.addingSymNames = false;
        this.addingDescription = false;
        this.addingLogMessage = false;
        this.logInfo = null;
        this.revision = null;
        this.messageList = new ArrayList(500);
    }

    public void outputDone() {
        if (this.logInfo != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.logInfo));
            this.logInfo = null;
            this.messageList = null;
        }
    }

    public void parseLine(String line, boolean isErrorMessage) {
        if (line.equals(FINAL_SPLIT)) {
            if (this.addingDescription) {
                this.addingDescription = false;
                this.logInfo.setDescription(this.tempBuffer.toString());
            }
            if (this.addingLogMessage) {
                this.addingLogMessage = false;
                this.revision.setMessage(CommandUtils.findUniqueString(this.tempBuffer.toString(), this.messageList));
            }
            if (this.revision != null) {
                this.logInfo.addRevision(this.revision);
                this.revision = null;
            }
            if (this.logInfo != null) {
                this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.logInfo));
                this.logInfo = null;
                this.tempBuffer = null;
            }
            return;
        }
        if (this.addingLogMessage) {
            if (line.startsWith(BRANCHES)) {
                this.processBranches(line.substring(BRANCHES.length()));
            } else {
                this.processLogMessage(line);
                return;
            }
        }
        if (this.addingSymNames) {
            this.processSymbolicNames(line);
        }
        if (this.addingDescription) {
            this.processDescription(line);
        }
        if (line.startsWith(REVISION)) {
            this.processRevisionStart(line);
        }
        if (line.startsWith(DATE)) {
            this.processRevisionDate(line);
        }
        if (line.startsWith(KEYWORD_SUBST)) {
            this.logInfo.setKeywordSubstitution(line.substring(KEYWORD_SUBST.length()).trim().intern());
            this.addingSymNames = false;
            return;
        }
        if (line.startsWith(DESCRIPTION)) {
            this.tempBuffer = new StringBuffer(line.substring(DESCRIPTION.length()));
            this.addingDescription = true;
        }
        if (line.indexOf(LOGGING_DIR) >= 0) {
            this.fileDirectory = line.substring(line.indexOf(LOGGING_DIR) + LOGGING_DIR.length()).trim();
            return;
        }
        if (line.startsWith(RCS_FILE)) {
            this.processRcsFile(line.substring(RCS_FILE.length()));
            return;
        }
        if (line.startsWith(WORK_FILE)) {
            this.processWorkingFile(line.substring(WORK_FILE.length()));
            return;
        }
        if (line.startsWith(REV_HEAD)) {
            this.logInfo.setHeadRevision(line.substring(REV_HEAD.length()).trim().intern());
            return;
        }
        if (line.startsWith(BRANCH)) {
            this.logInfo.setBranch(line.substring(BRANCH.length()).trim().intern());
        }
        if (line.startsWith(LOCKS)) {
            this.logInfo.setLocks(line.substring(LOCKS.length()).trim().intern());
        }
        if (line.startsWith(ACCESS_LIST)) {
            this.logInfo.setAccessList(line.substring(ACCESS_LIST.length()).trim().intern());
        }
        if (line.startsWith(SYM_NAME)) {
            this.addingSymNames = true;
        }
        if (line.startsWith(TOTAL_REV)) {
            int ind = line.indexOf(59);
            if (ind < 0) {
                this.logInfo.setTotalRevisions(line.substring(TOTAL_REV.length()).trim().intern());
                this.logInfo.setSelectedRevisions("0");
            } else {
                String total = line.substring(0, ind);
                String select = line.substring(ind, line.length());
                this.logInfo.setTotalRevisions(total.substring(TOTAL_REV.length()).trim().intern());
                this.logInfo.setSelectedRevisions(select.substring(SEL_REV.length()).trim().intern());
            }
        }
    }

    private String findUniqueString(String name, List list) {
        if (name == null) {
            return null;
        }
        int index = list.indexOf(name);
        if (index >= 0) {
            return (String)list.get(index);
        }
        String newName = name;
        list.add(newName);
        return newName;
    }

    private void processRcsFile(String line) {
        if (this.logInfo != null) {
            // empty if block
        }
        this.logInfo = new LogInformation();
        this.logInfo.setRepositoryFilename(line.trim());
    }

    private void processWorkingFile(String line) {
        String fileName = line.trim();
        if (fileName.startsWith(NO_FILE)) {
            fileName = fileName.substring(8);
        }
        this.logInfo.setFile(this.createFile(line));
    }

    private void processBranches(String line) {
        int ind = line.lastIndexOf(59);
        if (ind > 0) {
            line = line.substring(0, ind);
        }
        this.revision.setBranches(line.trim());
    }

    private void processLogMessage(String line) {
        if (line.startsWith(SPLITTER)) {
            this.addingLogMessage = false;
            this.revision.setMessage(this.findUniqueString(this.tempBuffer.toString(), this.messageList));
            return;
        }
        this.tempBuffer.append(line + "\n");
    }

    private void processSymbolicNames(String line) {
        int index;
        if (!line.startsWith(KEYWORD_SUBST) && (index = (line = line.trim()).indexOf(58)) > 0) {
            String symName = line.substring(0, index).trim();
            String revName = line.substring(index + 1, line.length()).trim();
            this.logInfo.addSymbolicName(symName.intern(), revName.intern());
        }
    }

    private void processDescription(String line) {
        if (line.startsWith(SPLITTER)) {
            this.addingDescription = false;
            this.logInfo.setDescription(this.tempBuffer.toString());
            return;
        }
        this.tempBuffer.append(line);
    }

    private void processRevisionStart(String line) {
        if (this.revision != null) {
            this.logInfo.addRevision(this.revision);
        }
        this.revision = this.logInfo.createNewRevision(line.substring(REVISION.length()).intern());
    }

    private void processRevisionDate(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, ";", false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.startsWith(DATE)) {
                this.revision.setDateString(token.substring(DATE.length()));
                continue;
            }
            if (token.startsWith(AUTHOR)) {
                this.revision.setAuthor(token.substring(AUTHOR.length()));
                continue;
            }
            if (token.startsWith(STATE)) {
                this.revision.setState(token.substring(STATE.length()));
                continue;
            }
            if (token.startsWith(LINES)) {
                this.revision.setLines(token.substring(LINES.length()));
                continue;
            }
            if (!token.startsWith(COMMITID)) continue;
            this.revision.setCommitID(token.substring(COMMITID.length()));
        }
        this.addingLogMessage = true;
        this.tempBuffer = new StringBuffer();
    }

    protected File createFile(String fileName) {
        StringBuffer path = new StringBuffer();
        path.append(this.logCommand.getLocalDirectory());
        path.append(File.separator);
        path.append(fileName.replace('/', File.separatorChar));
        return new File(path.toString());
    }

    public void parseEnhancedMessage(String key, Object value) {
    }
}

