/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.mapping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.jmi.model.AliasType;
import javax.jmi.model.Association;
import javax.jmi.model.Classifier;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofException;
import javax.jmi.model.MofPackage;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Namespace;
import javax.jmi.model.Parameter;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.StructureType;
import javax.jmi.model.TypedElement;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import org.netbeans.lib.jmi.util.TagProvider;

public abstract class GenericMapper {
    protected static String PACKAGE_POSTFIX = "Package";
    protected static String CLASS_POSTFIX = "Class";
    protected static String ENUM_POSTFIX = "Enum";
    protected static final String DT_EXCEPTION = "javax.jmi.reflect.RefException";
    protected static final String DT_PACKAGE = "javax.jmi.reflect.RefPackage";
    protected static final String DT_ASSOCIATION = "javax.jmi.reflect.RefAssociation";
    protected static final String DT_CLASS = "javax.jmi.reflect.RefClass";
    protected static final String DT_INSTANCE = "javax.jmi.reflect.RefObject";
    protected static final String DT_STRUCTURE = "javax.jmi.reflect.RefStruct";
    protected static final String DT_ENUMERATION = "javax.jmi.reflect.RefEnum";
    protected static final String DT_MULTIVALUED = "java.util.Collection";
    protected static final String DT_ORDERED = "java.util.List";
    protected static final String DT_ANY = "java.lang.Object";
    protected final TagProvider tagProvider = new TagProvider();
    protected final Set visited = new HashSet();
    protected static final HashMap objectToPrimitive = new HashMap(7);
    protected static final int GENERIC_STYLE_NONE = 0;
    protected static final int GENERIC_STYLE_FAKE = 1;
    protected static final int GENERIC_STYLE_REAL = 2;
    protected final Hashtable aliasesCache = new Hashtable(100);
    protected final Hashtable typeNameCache = new Hashtable(100);
    private boolean streamOpen = false;

    protected static String firstUpper(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() < 2) {
            return text.toUpperCase(Locale.US);
        }
        return text.substring(0, 1).toUpperCase(Locale.US) + text.substring(1);
    }

    protected static String firstLower(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() < 2) {
            return text.toLowerCase(Locale.US);
        }
        return text.substring(0, 1).toLowerCase(Locale.US) + text.substring(1);
    }

    protected static String removeUnderscores(String text) {
        StringBuffer result = new StringBuffer(text.length());
        int pos = 0;
        int oldPos = 0;
        while (oldPos <= text.length()) {
            pos = text.indexOf(95, oldPos);
            if (pos == -1) {
                pos = text.length() + 1;
            }
            if (pos - oldPos > 1) {
                String firstChar = text.substring(oldPos, oldPos + 1);
                if (oldPos > 0) {
                    firstChar = firstChar.toUpperCase(Locale.US);
                }
                result.append(firstChar);
                if (pos > text.length()) {
                    result.append(text.substring(oldPos + 1));
                } else {
                    result.append(text.substring(oldPos + 1, pos));
                }
            }
            oldPos = pos + 1;
        }
        return result.toString();
    }

    private static List parseDots(String packageName) {
        int position;
        String name = packageName;
        ArrayList<String> result = new ArrayList<String>();
        while ((position = name.indexOf(46)) > 0) {
            result.add(name.substring(0, position));
            name = name.substring(position + 1);
        }
        if (position != 0) {
            result.add(name);
        }
        return result;
    }

    protected Classifier getAttrType(TypedElement attr) {
        Classifier curType = attr.getType();
        Classifier attrType = (Classifier)this.aliasesCache.get(curType);
        if (attrType == null) {
            attrType = curType;
            if (curType instanceof AliasType) {
                attrType = this.getAttrType((TypedElement)curType);
            }
            this.aliasesCache.put(curType, attrType);
        }
        return attrType;
    }

    protected String getTypeName(StructuralFeature f) {
        return this.getTypeName(f, 0);
    }

    protected String getTypeName(StructuralFeature f, int genericStyle) {
        return this.getTypeName((TypedElement)f, f.getMultiplicity(), genericStyle);
    }

    protected String getTypeName(Parameter p) {
        return this.getTypeName(p, 0);
    }

    protected String getTypeName(Parameter p, int genericStyle) {
        return this.getTypeName((TypedElement)p, p.getMultiplicity(), genericStyle);
    }

    private String getTypeName(TypedElement te, MultiplicityType mp, int genericStyle) {
        String n = this.getTypeName(this.getAttrType(te));
        if (n == null || n.equals("null")) {
            throw new IllegalStateException("No type name for " + te);
        }
        if (mp.getUpper() > 1 || mp.getUpper() == -1) {
            String rawname = mp.isOrdered() ? DT_ORDERED : DT_MULTIVALUED;
            switch (genericStyle) {
                case 0: {
                    return rawname;
                }
                case 1: {
                    return rawname + "/*<" + n + ">*/";
                }
                case 2: {
                    return rawname + "<" + n + ">";
                }
            }
            throw new IllegalArgumentException("Bad genericStyle: " + genericStyle);
        }
        if (mp.getLower() < 1) {
            return n;
        }
        return this.getPrimitiveName(n);
    }

    protected String getTypeName2(TypedElement te) {
        return this.getPrimitiveName(this.getTypeName(this.getAttrType(te)));
    }

    protected String getTypeName(Classifier type) {
        String result = (String)this.typeNameCache.get(type);
        if (result == null) {
            result = this.tagProvider.getDataTypeName(type);
            this.typeNameCache.put(type, result);
        }
        return result;
    }

    protected String getPrimitiveName(String typeName) {
        String name = (String)objectToPrimitive.get(typeName);
        return name == null ? typeName : name;
    }

    protected static boolean canBePrimitive(String typeName) {
        return objectToPrimitive.get(typeName) != null;
    }

    protected abstract void classInstanceTemplate(MofClass var1) throws IOException;

    protected abstract void classProxyTemplate(MofClass var1) throws IOException;

    protected abstract void associationTemplate(Association var1) throws IOException;

    protected abstract void packageTemplate(MofPackage var1) throws IOException;

    protected abstract void exceptionTemplate(MofException var1) throws IOException;

    protected abstract void enumerationInterfaceTemplate(EnumerationType var1) throws IOException;

    protected abstract void enumerationClassTemplate(EnumerationType var1) throws IOException;

    protected abstract void structureTemplate(StructureType var1) throws IOException;

    protected abstract boolean createStream(List var1, String var2) throws IOException;

    protected abstract void closeStream() throws IOException;

    private boolean switchStream(ModelElement me, String suffix) throws IOException {
        if (this.streamOpen) {
            this.streamOpen = false;
            this.closeStream();
        }
        this.streamOpen = this.createStream(GenericMapper.parseDots(this.tagProvider.getTypePrefix(me)), this.tagProvider.getSubstName(me) + suffix);
        return this.streamOpen;
    }

    public void visitRefAssociation(RefAssociation refAssociation) throws IOException {
        this.visitRefObject(refAssociation.refMetaObject());
    }

    public void visitRefClass(RefClass refClass) throws IOException {
        if (refClass.refImmediatePackage() instanceof ModelPackage) {
            Iterator it = refClass.refAllOfClass().iterator();
            while (it.hasNext()) {
                this.visitRefObject((RefObject)it.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitRefObject(RefObject refObject) throws IOException {
        Namespace container;
        if (this.visited.contains(refObject) || !(refObject instanceof Namespace)) {
            return;
        }
        Namespace outermost = (Namespace)refObject;
        while ((container = outermost.getContainer()) != null) {
            outermost = container;
        }
        if (!(outermost instanceof MofPackage)) {
            return;
        }
        boolean ignoreLifecycle = false;
        String ignoreLifecycleString = this.tagProvider.getTagValue((ModelElement)outermost, "javax.jmi.ignoreLifecycle");
        if (ignoreLifecycleString != null && ignoreLifecycleString.equals("true")) {
            ignoreLifecycle = true;
        }
        try {
            if (refObject instanceof Association) {
                if (!ignoreLifecycle && this.switchStream((ModelElement)((Association)refObject), "")) {
                    this.associationTemplate((Association)refObject);
                }
            } else if (refObject instanceof MofClass || refObject instanceof MofPackage) {
                GeneralizableElement elm = (GeneralizableElement)refObject;
                this.visited.add(elm);
                Iterator it = elm.getSupertypes().iterator();
                while (it.hasNext()) {
                    this.visitRefObject((RefObject)it.next());
                }
                List contents = elm.getContents();
                Iterator it2 = contents.iterator();
                while (it2.hasNext()) {
                    this.visitRefObject((RefObject)it2.next());
                }
                if (elm instanceof MofPackage) {
                    if (!ignoreLifecycle && this.switchStream((ModelElement)elm, PACKAGE_POSTFIX)) {
                        this.packageTemplate((MofPackage)elm);
                    }
                } else {
                    if (this.switchStream((ModelElement)elm, "")) {
                        this.classInstanceTemplate((MofClass)elm);
                    }
                    if (!ignoreLifecycle && this.switchStream((ModelElement)elm, CLASS_POSTFIX)) {
                        this.classProxyTemplate((MofClass)elm);
                    }
                }
            } else if (refObject instanceof EnumerationType) {
                EnumerationType et = (EnumerationType)refObject;
                if (this.switchStream((ModelElement)et, "")) {
                    this.enumerationInterfaceTemplate(et);
                }
                if (this.switchStream((ModelElement)et, ENUM_POSTFIX)) {
                    this.enumerationClassTemplate(et);
                }
            } else if (refObject instanceof StructureType) {
                if (this.switchStream((ModelElement)((StructureType)refObject), "")) {
                    this.structureTemplate((StructureType)refObject);
                }
            } else if (refObject instanceof MofException && this.switchStream((ModelElement)((MofException)refObject), "")) {
                this.exceptionTemplate((MofException)refObject);
            }
        }
        finally {
            if (this.streamOpen) {
                this.streamOpen = false;
                this.closeStream();
            }
        }
    }

    public void visitRefPackage(RefPackage refPackage) throws IOException {
        if (refPackage instanceof ModelPackage) {
            ModelPackage pkg = (ModelPackage)refPackage;
            Iterator it = pkg.getMofPackage().refAllOfClass().iterator();
            while (it.hasNext()) {
                ModelElement element = (ModelElement)it.next();
                if (element.getContainer() != null) continue;
                this.visitRefObject((RefObject)element);
            }
        }
    }

    public void visitRefBaseObject(RefBaseObject object) throws IOException {
        if (object instanceof RefPackage) {
            this.visitRefPackage((RefPackage)object);
        } else if (object instanceof RefObject) {
            this.visitRefObject((RefObject)object);
        } else if (object instanceof RefAssociation) {
            this.visitRefAssociation((RefAssociation)object);
        } else if (object instanceof RefClass) {
            this.visitRefClass((RefClass)object);
        }
    }

    static {
        objectToPrimitive.put("java.lang.Short", "short");
        objectToPrimitive.put("java.lang.Integer", "int");
        objectToPrimitive.put("java.lang.Float", "float");
        objectToPrimitive.put("java.lang.Double", "double");
        objectToPrimitive.put("java.lang.Boolean", "boolean");
        objectToPrimitive.put("java.lang.Character", "char");
        objectToPrimitive.put("java.lang.Long", "long");
    }
}

