/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.j2ee.archive.project.ArchiveProjectProperties;
import org.openide.ErrorManager;

public final class VisualPropertySupport {
    private static final String WRONG_TYPE = ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/customizer/Bundle").getString("WrongType");
    private ArchiveProjectProperties apProperties;
    private HashMap component2property;
    private ComponentListener componentListener;
    private int comboType;
    private String[] comboValues;

    public VisualPropertySupport(ArchiveProjectProperties apProperties) {
        this.apProperties = apProperties;
        this.component2property = new HashMap(10);
        this.componentListener = new ComponentListener();
    }

    public void register(JComboBox component, String[] displayNames, String[] values, String propertyName) {
        this.comboType = 1;
        this.comboValues = (String[])values.clone();
        String value = (String)this.getAsType(propertyName, String.class);
        this.component2property.put(component, propertyName);
        component.removeAllItems();
        int selectedIndex = 0;
        for (int i = 0; i < displayNames.length; ++i) {
            component.addItem(displayNames[i]);
            if (!values[i].equals(value)) continue;
            selectedIndex = i;
        }
        if (selectedIndex < component.getItemCount()) {
            component.setSelectedIndex(selectedIndex);
        }
        component.removeActionListener(this.componentListener);
        component.addActionListener(this.componentListener);
    }

    private static Boolean readValue(JCheckBox checkBox) {
        return checkBox.isSelected() ? Boolean.TRUE : Boolean.FALSE;
    }

    private static String readValue(Document document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return "";
        }
    }

    private static String readValue(JComboBox comboBox) {
        return (String)comboBox.getSelectedItem();
    }

    private Object getAsType(String propertyName, Class expectedType) {
        return this.getAsType(propertyName, expectedType, true);
    }

    private Object getAsType(String propertyName, Class expectedType, boolean throwException) {
        Object value = this.apProperties.get(propertyName);
        if (value == null || expectedType.isInstance(value)) {
            return value;
        }
        if (throwException) {
            throw new IllegalArgumentException("Value of property: " + propertyName + " exbected to be: " + expectedType.getName() + " but was: " + value.getClass().getName() + "!");
        }
        return WRONG_TYPE;
    }

    private class ComponentListener
    implements ActionListener,
    DocumentListener {
        private ComponentListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            String propertyName = (String)VisualPropertySupport.this.component2property.get(source);
            if (propertyName != null) {
                if (source instanceof JCheckBox) {
                    VisualPropertySupport.this.apProperties.put(propertyName, VisualPropertySupport.readValue((JCheckBox)source));
                } else if (source instanceof JComboBox) {
                    if (((JComboBox)source).getItemCount() == 0) {
                        return;
                    }
                    switch (VisualPropertySupport.this.comboType) {
                        case 0: {
                            VisualPropertySupport.this.apProperties.put(propertyName, VisualPropertySupport.readValue((JComboBox)source));
                            break;
                        }
                        case 1: {
                            VisualPropertySupport.this.apProperties.put(propertyName, VisualPropertySupport.this.comboValues[((JComboBox)source).getSelectedIndex()]);
                        }
                    }
                }
            }
        }

        public void changedUpdate(DocumentEvent e) {
            Document document = e.getDocument();
            String propertyName = (String)VisualPropertySupport.this.component2property.get(document);
            if (propertyName != null) {
                VisualPropertySupport.this.apProperties.put(propertyName, VisualPropertySupport.readValue(document));
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }
    }
}

