/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.AppServerAdmin;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.LocalStringsManager;

public class InstanceTask
extends AppServerAdmin {
    private String action = null;
    private static final String ACTION_START = "start";
    private static final String ACTION_STOP = "stop";
    private static final String ACTION_RESTART = "restart";
    private static final String ACTION_CREATE = "create";
    private static final String ACTION_DELETE = "delete";
    private static final Map ACTION_MAP = new HashMap(5);
    LocalStringsManager lsm = new LocalStringsManager();

    static {
        ACTION_MAP.put(ACTION_START, "start-instance");
        ACTION_MAP.put(ACTION_STOP, "stop-instance");
        ACTION_MAP.put(ACTION_RESTART, "restart-instance");
        ACTION_MAP.put(ACTION_CREATE, "create-instance");
        ACTION_MAP.put(ACTION_DELETE, "delete-instance");
    }

    protected void checkConfiguration() throws BuildException {
        if (this.action == null) {
            String msg = this.lsm.getString("ActionCommandMustBeSpecified");
            throw new BuildException(msg, this.getLocation());
        }
        if (!ACTION_MAP.containsKey(this.action)) {
            String msg = this.lsm.getString("InvalidActionCommand", new Object[]{this.action});
            throw new BuildException(msg, this.getLocation());
        }
        super.checkConfiguration();
    }

    public void setInstanceport(int instanceport) {
        String msg = this.lsm.getString("AttributeNotSupported", new Object[]{"instanceport"});
        this.log(msg, 1);
    }

    public void setDebug(boolean debug) {
        String msg = this.lsm.getString("AttributeNotSupported", new Object[]{"debug"});
        this.log(msg, 1);
    }

    public void setLocal(boolean local) {
        String msg = this.lsm.getString("AttributeNotSupported", new Object[]{"local"});
        this.log(msg, 1);
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setCluster(String cluster) {
        ((InstanceServer)this.server).setCluster(cluster);
    }

    public void setConfig(String config) {
        ((InstanceServer)this.server).setConfig(config);
    }

    public void setDomain(String domain) {
        String msg = this.lsm.getString("AttributeNotSupported", new Object[]{"domain"});
        this.log(msg, 1);
    }

    public void setNodeagent(String nodeagent) {
        ((InstanceServer)this.server).setNodeagent(nodeagent);
    }

    public void setProperty(String property) {
        ((InstanceServer)this.server).setProperty(property);
    }

    protected AppServerAdmin.Server getNewServer() {
        return new InstanceServer(this.server);
    }

    protected void checkConfiguration(AppServerAdmin.Server aServer) throws BuildException {
        if (aServer.getInstance() == null) {
            String msg = this.lsm.getString("InstanceAttributeRequired");
            throw new BuildException(msg, this.getLocation());
        }
        InstanceServer instanceSvr = (InstanceServer)aServer;
        if (!instanceSvr.hasPassword()) {
            String msg = this.lsm.getString("PasswordAttributeNotSpecified");
            throw new BuildException(msg, this.getLocation());
        }
        if (this.action.equals(ACTION_CREATE) && instanceSvr.getNodeagent() == null) {
            String msg = this.lsm.getString("AttributeMustBeSpecified", new Object[]{"nodeagent"});
            throw new BuildException(msg, this.getLocation());
        }
    }

    protected void execute(AppServerAdmin.Server aServer) throws BuildException {
        InstanceServer instanceSvr = (InstanceServer)aServer;
        if (instanceSvr.getConfig() != null && instanceSvr.getCluster() != null) {
            String msg = this.lsm.getString("MutuallyExclusivelyAttribute", new Object[]{"config", "cluster"});
            throw new BuildException(msg, this.getLocation());
        }
        StringBuffer cmd = new StringBuffer((String)ACTION_MAP.get(this.action));
        cmd.append(instanceSvr.getCommandParameters(false));
        if (this.action.equals(ACTION_CREATE)) {
            cmd.append(" --nodeagent " + instanceSvr.getNodeagent());
            if (instanceSvr.getConfig() != null) {
                cmd.append(" --config " + instanceSvr.getConfig());
            }
            if (instanceSvr.getCluster() != null) {
                cmd.append(" --cluster " + instanceSvr.getCluster());
            }
            if (instanceSvr.getProperty() != null) {
                cmd.append(" --property " + instanceSvr.getProperty());
            }
        } else if (this.action.equals(ACTION_START)) {
            // empty if block
        }
        cmd.append(' ').append(instanceSvr.getInstance());
        this.execAdminCommand(cmd.toString());
    }

    public class InstanceServer
    extends AppServerAdmin.Server {
        private boolean debug;
        private boolean local;
        private String domain;
        private int instanceport;
        private String nodeagent;
        private String config;
        private String cluster;
        private String property;
        private boolean debugIsSet;
        private boolean localIsSet;
        private static final boolean DEFAULT_DEBUG = false;
        private static final boolean DEFAULT_LOCAL = false;

        protected int getInstanceport() {
            InstanceServer theParent = (InstanceServer)this.getParent();
            if (this.instanceport == 0 && theParent != null) {
                return theParent.getInstanceport();
            }
            return this.instanceport;
        }

        protected boolean isDebug() {
            InstanceServer theParent = (InstanceServer)this.getParent();
            if (!this.debugIsSet) {
                return theParent == null ? false : theParent.isDebug();
            }
            return this.debug;
        }

        protected boolean isLocal() {
            InstanceServer theParent = (InstanceServer)this.getParent();
            if (!this.localIsSet) {
                return theParent == null ? false : theParent.isLocal();
            }
            return this.local;
        }

        public void setInstanceport(int instanceport) {
            this.instanceport = instanceport;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
            this.debugIsSet = true;
        }

        public void setLocal(boolean local) {
            this.local = local;
            this.localIsSet = true;
        }

        protected String getCluster() {
            InstanceServer theParent = (InstanceServer)this.getParent();
            return this.cluster;
        }

        protected String getConfig() {
            return this.config;
        }

        protected String getDomain() {
            InstanceServer theParent = (InstanceServer)this.getParent();
            if (this.domain == null) {
                return theParent == null ? null : theParent.getDomain();
            }
            return this.domain;
        }

        protected String getNodeagent() {
            InstanceServer theParent = (InstanceServer)this.getParent();
            return this.nodeagent;
        }

        protected String getProperty() {
            return this.property;
        }

        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public void setConfig(String config) {
            this.config = config;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setNodeagent(String nodeagent) {
            this.nodeagent = nodeagent;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public InstanceServer() {
            this(null);
        }

        public InstanceServer(AppServerAdmin.Server theParent) {
            super(theParent);
            this.debugIsSet = false;
            this.localIsSet = false;
        }
    }
}

