/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import org.netbeans.api.debugger.jpda.JPDABreakpoint;

public final class ExceptionBreakpoint
extends JPDABreakpoint {
    public static final String PROP_EXCEPTION_CLASS_NAME = "exceptionClassName";
    public static final String PROP_CATCH_TYPE = "catchType";
    public static final String PROP_CONDITION = "condition";
    public static final int TYPE_EXCEPTION_CATCHED = 1;
    public static final int TYPE_EXCEPTION_UNCATCHED = 2;
    public static final int TYPE_EXCEPTION_CATCHED_UNCATCHED = 3;
    private String exceptionClassName = "";
    private int catchType = 2;
    private String condition = "";

    private ExceptionBreakpoint() {
    }

    public static ExceptionBreakpoint create(String exceptionClassName, int catchType) {
        ExceptionBreakpoint b = new ExceptionBreakpoint();
        b.setExceptionClassName(exceptionClassName);
        b.setCatchType(catchType);
        return b;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public void setExceptionClassName(String cn) {
        if (cn != null) {
            cn = cn.trim();
        }
        if (cn == this.exceptionClassName || cn != null && this.exceptionClassName != null && this.exceptionClassName.equals(cn)) {
            return;
        }
        String old = this.exceptionClassName;
        this.exceptionClassName = cn;
        this.firePropertyChange(PROP_EXCEPTION_CLASS_NAME, old, this.exceptionClassName);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String cond) {
        if (cond != null) {
            cond = cond.trim();
        }
        String old = this.condition;
        this.condition = cond;
        this.firePropertyChange(PROP_CONDITION, old, cond);
    }

    public int getCatchType() {
        return this.catchType;
    }

    public void setCatchType(int catchType) {
        if (catchType == this.catchType) {
            return;
        }
        if ((catchType & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int old = this.catchType;
        this.catchType = catchType;
        this.firePropertyChange(PROP_CATCH_TYPE, new Integer(old), new Integer(catchType));
    }

    public String toString() {
        return "ExceptionBreakpoint" + this.exceptionClassName;
    }
}

