/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.generator;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.ws.ToolVersion;
import com.sun.tools.ws.processor.ProcessorAction;
import com.sun.tools.ws.processor.config.Configuration;
import com.sun.tools.ws.processor.config.WSDLModelInfo;
import com.sun.tools.ws.processor.generator.GeneratorConstants;
import com.sun.tools.ws.processor.generator.GeneratorException;
import com.sun.tools.ws.processor.generator.JAXBTypeGenerator;
import com.sun.tools.ws.processor.generator.Names;
import com.sun.tools.ws.processor.model.AbstractType;
import com.sun.tools.ws.processor.model.Block;
import com.sun.tools.ws.processor.model.Fault;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.ModelObject;
import com.sun.tools.ws.processor.model.ModelVisitor;
import com.sun.tools.ws.processor.model.Operation;
import com.sun.tools.ws.processor.model.Parameter;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Request;
import com.sun.tools.ws.processor.model.Response;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.model.jaxb.JAXBType;
import com.sun.tools.ws.processor.model.jaxb.JAXBTypeVisitor;
import com.sun.tools.ws.processor.model.jaxb.RpcLitStructure;
import com.sun.tools.ws.processor.util.DirectoryUtil;
import com.sun.tools.ws.processor.util.GeneratedFileInfo;
import com.sun.tools.ws.processor.util.IndentingWriter;
import com.sun.tools.ws.processor.util.ProcessorEnvironment;
import com.sun.xml.ws.encoding.soap.SOAPVersion;
import com.sun.xml.ws.util.localization.Localizable;
import com.sun.xml.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jws.HandlerChain;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratorBase
implements GeneratorConstants,
ProcessorAction,
ModelVisitor,
JAXBTypeVisitor {
    protected File sourceDir;
    protected File destDir;
    protected File nonclassDestDir;
    protected ProcessorEnvironment env;
    protected Model model;
    protected Service service;
    protected SOAPVersion curSOAPVersion;
    protected String targetVersion;
    protected boolean donotOverride;
    protected String servicePackage;
    protected JCodeModel cm;
    protected boolean printStackTrace;
    protected String wsdlLocation;
    private LocalizableMessageFactory messageFactory;

    public GeneratorBase() {
        this.sourceDir = null;
        this.destDir = null;
        this.nonclassDestDir = null;
        this.env = null;
        this.model = null;
    }

    @Override
    public void perform(Model model, Configuration config, Properties properties) {
        GeneratorBase generator = this.getGenerator(model, config, properties);
        generator.doGeneration();
    }

    public abstract GeneratorBase getGenerator(Model var1, Configuration var2, Properties var3);

    public abstract GeneratorBase getGenerator(Model var1, Configuration var2, Properties var3, SOAPVersion var4);

    protected GeneratorBase(Model model, Configuration config, Properties properties) {
        this.model = model;
        this.cm = model.getJAXBModel().getS2JJAXBModel() != null ? model.getJAXBModel().getS2JJAXBModel().generateCode(null, new JAXBTypeGenerator.JAXBErrorListener()) : new JCodeModel();
        this.env = config.getEnvironment();
        String key = "destinationDirectory";
        String dirPath = properties.getProperty(key);
        this.destDir = new File(dirPath);
        key = "sourceDirectory";
        String sourcePath = properties.getProperty(key);
        this.sourceDir = new File(sourcePath);
        key = "nonclassDestinationDirectory";
        String nonclassDestPath = properties.getProperty(key);
        this.nonclassDestDir = new File(nonclassDestPath);
        if (this.nonclassDestDir == null) {
            this.nonclassDestDir = this.destDir;
        }
        this.messageFactory = new LocalizableMessageFactory("com.sun.tools.ws.resources.generator");
        this.targetVersion = properties.getProperty("sourceVersion");
        key = "doNotOverWrite";
        this.donotOverride = Boolean.valueOf(properties.getProperty(key));
        this.printStackTrace = Boolean.valueOf(properties.getProperty("printStackTrace"));
        this.wsdlLocation = properties.getProperty("wsdllocation");
    }

    protected void doGeneration() {
        try {
            this.model.accept(this);
        }
        catch (Exception e) {
            if (this.env.verbose()) {
                e.printStackTrace();
            }
            throw new GeneratorException("generator.nestedGeneratorError", e);
        }
    }

    @Override
    public void visit(Model model) throws Exception {
        this.preVisitModel(model);
        this.visitModel(model);
        this.postVisitModel(model);
    }

    protected void preVisitModel(Model model) throws Exception {
    }

    protected void visitModel(Model model) throws Exception {
        this.env.getNames().resetPrefixFactory();
        for (Service service : model.getServices()) {
            service.accept(this);
        }
    }

    protected void postVisitModel(Model model) throws Exception {
    }

    @Override
    public void visit(Service service) throws Exception {
        this.preVisitService(service);
        this.visitService(service);
        this.postVisitService(service);
    }

    protected void preVisitService(Service service) throws Exception {
        this.servicePackage = Names.getPackageName(service);
    }

    protected void visitService(Service service) throws Exception {
        this.service = service;
        for (Port port : service.getPorts()) {
            port.accept(this);
        }
        this.service = null;
    }

    protected void postVisitService(Service service) throws Exception {
        Iterator extraTypes = this.model.getExtraTypes();
        while (extraTypes.hasNext()) {
            AbstractType abstractType = (AbstractType)extraTypes.next();
        }
        this.servicePackage = null;
    }

    @Override
    public void visit(Port port) throws Exception {
        this.preVisitPort(port);
        this.visitPort(port);
        this.postVisitPort(port);
    }

    protected void preVisitPort(Port port) throws Exception {
        this.curSOAPVersion = port.getSOAPVersion();
    }

    protected void visitPort(Port port) throws Exception {
        for (Operation operation : port.getOperations()) {
            operation.accept(this);
        }
    }

    protected void postVisitPort(Port port) throws Exception {
        this.curSOAPVersion = null;
    }

    @Override
    public void visit(Operation operation) throws Exception {
        this.preVisitOperation(operation);
        this.visitOperation(operation);
        this.postVisitOperation(operation);
    }

    protected void preVisitOperation(Operation operation) throws Exception {
    }

    protected void visitOperation(Operation operation) throws Exception {
        Iterator<Fault> faults;
        operation.getRequest().accept(this);
        if (operation.getResponse() != null) {
            operation.getResponse().accept(this);
        }
        if ((faults = operation.getFaultsSet().iterator()) != null) {
            while (faults.hasNext()) {
                Fault fault = faults.next();
                fault.accept(this);
            }
        }
    }

    protected void postVisitOperation(Operation operation) throws Exception {
    }

    @Override
    public void visit(Parameter param) throws Exception {
        this.preVisitParameter(param);
        this.visitParameter(param);
        this.postVisitParameter(param);
    }

    protected void preVisitParameter(Parameter param) throws Exception {
    }

    protected void visitParameter(Parameter param) throws Exception {
    }

    protected void postVisitParameter(Parameter param) throws Exception {
    }

    @Override
    public void visit(Block block) throws Exception {
        this.preVisitBlock(block);
        this.visitBlock(block);
        this.postVisitBlock(block);
    }

    protected void preVisitBlock(Block block) throws Exception {
    }

    protected void visitBlock(Block block) throws Exception {
    }

    protected void postVisitBlock(Block block) throws Exception {
    }

    @Override
    public void visit(Response response) throws Exception {
        this.preVisitResponse(response);
        this.visitResponse(response);
        this.postVisitResponse(response);
    }

    protected void preVisitResponse(Response response) throws Exception {
    }

    protected void visitResponse(Response response) throws Exception {
        AbstractType type;
        Block block;
        Iterator<ModelObject> iter = response.getParameters();
        while (iter.hasNext()) {
            iter.next().accept(this);
        }
        iter = response.getBodyBlocks();
        while (iter.hasNext()) {
            block = (Block)iter.next();
            type = block.getType();
            if (type instanceof JAXBType) {
                ((JAXBType)type).accept(this);
            } else if (type instanceof RpcLitStructure) {
                ((RpcLitStructure)type).accept(this);
            }
            this.responseBodyBlock(block);
        }
        iter = response.getHeaderBlocks();
        while (iter.hasNext()) {
            block = (Block)iter.next();
            type = block.getType();
            if (type instanceof JAXBType) {
                ((JAXBType)type).accept(this);
            }
            this.responseHeaderBlock(block);
        }
        iter = response.getAttachmentBlocks();
        while (iter.hasNext()) {
            block = (Block)iter.next();
            type = block.getType();
            if (type instanceof JAXBType) {
                ((JAXBType)type).accept(this);
            }
            this.responseAttachmentBlock(block);
        }
    }

    protected void responseBodyBlock(Block block) throws Exception {
    }

    protected void responseHeaderBlock(Block block) throws Exception {
    }

    protected void responseAttachmentBlock(Block block) throws Exception {
    }

    protected void postVisitResponse(Response response) throws Exception {
    }

    @Override
    public void visit(Request request) throws Exception {
        this.preVisitRequest(request);
        this.visitRequest(request);
        this.postVisitRequest(request);
    }

    protected void preVisitRequest(Request request) throws Exception {
    }

    protected void visitRequest(Request request) throws Exception {
        AbstractType type;
        Block block;
        Iterator<ModelObject> iter = request.getParameters();
        while (iter.hasNext()) {
            iter.next().accept(this);
        }
        iter = request.getBodyBlocks();
        while (iter.hasNext()) {
            block = (Block)iter.next();
            type = block.getType();
            if (type instanceof JAXBType) {
                ((JAXBType)type).accept(this);
            } else if (type instanceof RpcLitStructure) {
                ((RpcLitStructure)type).accept(this);
            }
            this.requestBodyBlock(block);
        }
        iter = request.getHeaderBlocks();
        while (iter.hasNext()) {
            block = (Block)iter.next();
            type = block.getType();
            if (type instanceof JAXBType) {
                ((JAXBType)type).accept(this);
            }
            this.requestHeaderBlock(block);
        }
    }

    protected void requestBodyBlock(Block block) throws Exception {
    }

    protected void requestHeaderBlock(Block block) throws Exception {
    }

    protected void postVisitRequest(Request request) throws Exception {
    }

    @Override
    public void visit(Fault fault) throws Exception {
        this.preVisitFault(fault);
        this.visitFault(fault);
        this.postVisitFault(fault);
    }

    protected void preVisitFault(Fault fault) throws Exception {
    }

    protected void visitFault(Fault fault) throws Exception {
    }

    protected void postVisitFault(Fault fault) throws Exception {
    }

    protected void writeWarning(IndentingWriter p) throws IOException {
        GeneratorBase.writeWarning(p, this.targetVersion);
    }

    public List<String> getJAXWSClassComment() {
        return GeneratorBase.getJAXWSClassComment(this.targetVersion);
    }

    public static List<String> getJAXWSClassComment(String targetVersion) {
        ArrayList<String> comments = new ArrayList<String>();
        comments.add("This class was generated by the JAXWS SI.\n");
        comments.add(ToolVersion.VERSION.BUILD_VERSION + "\n");
        comments.add("Generated source version: " + targetVersion);
        return comments;
    }

    public static void writeWarning(IndentingWriter p, String targetVersion) throws IOException {
        p.pln("// This class was generated by the JAX SI, do not edit.");
        p.pln("// Contents subject to change without notice.");
        p.pln("// " + ToolVersion.VERSION.BUILD_VERSION);
        p.pln("// Generated source version: " + targetVersion);
        p.pln();
    }

    public void writePackage(IndentingWriter p, String classNameStr) throws IOException {
        GeneratorBase.writePackage(p, classNameStr, this.targetVersion);
    }

    public static void writePackage(IndentingWriter p, String classNameStr, String sourceVersion) throws IOException {
        GeneratorBase.writeWarning(p, sourceVersion);
        GeneratorBase.writePackageOnly(p, classNameStr);
    }

    public static void writePackageOnly(IndentingWriter p, String classNameStr) throws IOException {
        int idx = classNameStr.lastIndexOf(".");
        if (idx > 0) {
            p.pln("package " + classNameStr.substring(0, idx) + ";");
            p.pln();
        }
    }

    protected JDefinedClass getClass(String className, ClassType type) {
        JDefinedClass cls = null;
        try {
            cls = this.cm._class(className, type);
        }
        catch (JClassAlreadyExistsException e) {
            cls = this.cm._getClass(className);
        }
        return cls;
    }

    protected void log(String msg) {
        if (this.env.verbose()) {
            System.out.println("[" + Names.stripQualifier(this.getClass().getName()) + ": " + msg + "]");
        }
    }

    protected void warn(String key) {
        this.env.warn(this.messageFactory.getMessage(key, new Object[0]));
    }

    protected void warn(String key, String arg) {
        this.env.warn(this.messageFactory.getMessage(key, arg));
    }

    protected void warn(String key, Object[] args) {
        this.env.warn(this.messageFactory.getMessage(key, args));
    }

    protected void info(String key) {
        this.env.info(this.messageFactory.getMessage(key, new Object[0]));
    }

    protected void info(String key, String arg) {
        this.env.info(this.messageFactory.getMessage(key, arg));
    }

    protected static void fail(String key) {
        throw new GeneratorException(key, new Object[0]);
    }

    protected static void fail(String key, String arg) {
        throw new GeneratorException(key, arg);
    }

    protected static void fail(String key, String arg1, String arg2) {
        throw new GeneratorException(key, arg1, arg2);
    }

    protected static void fail(Localizable arg) {
        throw new GeneratorException("generator.nestedGeneratorError", arg);
    }

    protected static void fail(Throwable arg) {
        throw new GeneratorException("generator.nestedGeneratorError", arg);
    }

    @Override
    public void visit(JAXBType type) throws Exception {
        this.preVisitJAXBType(type);
        this.visitJAXBType(type);
        this.postVisitJAXBType(type);
    }

    protected void postVisitJAXBType(JAXBType type) {
    }

    protected void visitJAXBType(JAXBType type) {
    }

    protected void preVisitJAXBType(JAXBType type) {
    }

    @Override
    public void visit(RpcLitStructure type) throws Exception {
    }

    protected void writeHandlerConfig(String className, JDefinedClass cls, WSDLModelInfo wsdlModelInfo) {
        Element e = wsdlModelInfo.getHandlerConfig();
        if (e == null) {
            return;
        }
        JAnnotationUse handlerChainAnn = cls.annotate(this.cm.ref(HandlerChain.class));
        NodeList nl = e.getElementsByTagNameNS("http://java.sun.com/xml/ns/javaee", "handler-chain");
        if (nl.getLength() > 0) {
            Element hn = (Element)nl.item(0);
            String fName = this.getHandlerConfigFileName(className);
            handlerChainAnn.param("file", fName);
            this.generateHandlerChainFile(e, className);
        }
    }

    private String getHandlerConfigFileName(String fullName) {
        String name = Names.stripQualifier(fullName);
        return name + "_handler.xml";
    }

    private void generateHandlerChainFile(Element hChains, String name) {
        String hcName = this.getHandlerConfigFileName(name);
        File packageDir = DirectoryUtil.getOutputDirectoryFor(name, this.destDir, this.env);
        File hcFile = new File(packageDir, hcName);
        GeneratedFileInfo fi = new GeneratedFileInfo();
        fi.setFile(hcFile);
        fi.setType("HandlerConfig");
        this.env.addGeneratedFile(fi);
        try {
            IndentingWriter p = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(hcFile)));
            Transformer it = XmlUtil.newTransformer();
            it.setOutputProperty("method", "xml");
            it.setOutputProperty("indent", "yes");
            it.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            it.setOutputProperty("encoding", "UTF-8");
            it.transform(new DOMSource(hChains), new StreamResult(p));
        }
        catch (Exception e) {
            throw new GeneratorException("generator.nestedGeneratorError", e);
        }
    }
}

