/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.generator;

import com.sun.tools.ws.processor.generator.GeneratorConstants;
import com.sun.tools.ws.processor.generator.Names;
import com.sun.tools.ws.processor.model.Block;
import com.sun.tools.ws.processor.model.Fault;
import com.sun.tools.ws.processor.model.Operation;
import com.sun.tools.ws.processor.model.java.JavaException;
import com.sun.tools.ws.processor.model.java.JavaStructureType;
import com.sun.tools.ws.processor.util.IndentingWriter;
import com.sun.tools.ws.processor.util.ProcessorEnvironment;
import java.io.IOException;
import java.util.Comparator;
import javax.xml.namespace.QName;

public class GeneratorUtil
implements GeneratorConstants {
    public static void writeNewQName(IndentingWriter p, QName name) throws IOException {
        p.p("new QName(\"" + name.getNamespaceURI() + "\", \"" + name.getLocalPart() + "\")");
    }

    public static void writeBlockQNameDeclaration(IndentingWriter p, Operation operation, Block block, Names names) throws IOException {
        String qname = names.getBlockQNameName(operation, block);
        p.p("private static final QName ");
        p.p(qname + " = ");
        GeneratorUtil.writeNewQName(p, block.getName());
        p.pln(";");
    }

    public static void writeQNameDeclaration(IndentingWriter p, QName name, Names names) throws IOException {
        String qname = names.getQNameName(name);
        p.p("private static final QName ");
        p.p(qname + " = ");
        GeneratorUtil.writeNewQName(p, name);
        p.pln(";");
    }

    public static void writeQNameTypeDeclaration(IndentingWriter p, QName name, Names names) throws IOException {
        String qname = names.getTypeQName(name);
        p.p("private static final QName ");
        p.p(qname + " = ");
        GeneratorUtil.writeNewQName(p, name);
        p.pln(";");
    }

    public static boolean classExists(ProcessorEnvironment env, String className) {
        try {
            GeneratorUtil.getLoadableClassName(className, env.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static String getLoadableClassName(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            int idx = className.lastIndexOf(46);
            if (idx > -1) {
                String tmp = className.substring(0, idx) + "$";
                tmp = tmp + className.substring(idx + 1);
                return GeneratorUtil.getLoadableClassName(tmp, classLoader);
            }
            throw e;
        }
        return className;
    }

    public static class FaultComparator
    implements Comparator {
        private boolean sortName = false;

        public FaultComparator() {
        }

        public FaultComparator(boolean sortName) {
            this.sortName = sortName;
        }

        public int compare(Object o1, Object o2) {
            QName name2;
            QName name1;
            if (this.sortName && !(name1 = ((Fault)o1).getBlock().getName()).equals(name2 = ((Fault)o2).getBlock().getName())) {
                return name1.toString().compareTo(name2.toString());
            }
            JavaException type1 = ((Fault)o1).getJavaException();
            JavaException type2 = ((Fault)o2).getJavaException();
            int result = this.sort(type1, type2);
            return result;
        }

        protected int sort(JavaStructureType type1, JavaStructureType type2) {
            JavaStructureType superType;
            if (type1.getName().equals(type2.getName())) {
                return 0;
            }
            for (superType = type1.getSuperclass(); superType != null; superType = superType.getSuperclass()) {
                if (!superType.equals(type2)) continue;
                return -1;
            }
            for (superType = type2.getSuperclass(); superType != null; superType = superType.getSuperclass()) {
                if (!superType.equals(type1)) continue;
                return 1;
            }
            if (type1.getSubclasses() == null && type2.getSubclasses() != null) {
                return -1;
            }
            if (type1.getSubclasses() != null && type2.getSubclasses() == null) {
                return 1;
            }
            if (type1.getSuperclass() != null && type2.getSuperclass() == null) {
                return 1;
            }
            if (type1.getSuperclass() == null && type2.getSuperclass() != null) {
                return -1;
            }
            return type1.getName().compareTo(type2.getName());
        }
    }
}

