/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ui.ModuleNode;
import org.netbeans.modules.j2ee.earproject.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class LogicalViewChildren
extends Children.Keys
implements AntProjectListener {
    private final AntProjectHelper model;
    private Map<String, VisualClassPathItem> vcpItems;

    public LogicalViewChildren(AntProjectHelper model) {
        if (null == model) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
    }

    protected void addNotify() {
        super.addNotify();
        this.updateKeys();
        this.model.addAntProjectListener((AntProjectListener)this);
    }

    private void updateKeys() {
        Project p = FileOwnerQuery.getOwner((FileObject)this.model.getProjectDirectory());
        if (p == null) {
            ErrorManager.getDefault().notify(16, (Throwable)new IllegalStateException("FileOwnerQuery.getOwner(" + this.model.getProjectDirectory() + ") returned null. " + "Please report this with the situation description to issue #62823 " + "(http://www.netbeans.org/issues/show_bug.cgi?id=62823)."));
            return;
        }
        EarProject earProject = (EarProject)p.getLookup().lookup(EarProject.class);
        List<VisualClassPathItem> vcpis = earProject.getProjectProperties().getJarContentAdditional();
        this.vcpItems = new HashMap<String, VisualClassPathItem>();
        for (VisualClassPathItem vcpi : vcpis) {
            AntArtifact aa;
            Project vcpiProject;
            J2eeModuleProvider jmp;
            Object obj = vcpi.getObject();
            if (!(obj instanceof AntArtifact) || null == (jmp = (J2eeModuleProvider)(vcpiProject = (aa = (AntArtifact)obj).getProject()).getLookup().lookup(J2eeModuleProvider.class))) continue;
            this.vcpItems.put(vcpi.getRaw(), vcpi);
        }
        this.setKeys(this.vcpItems.keySet());
    }

    protected void removeNotify() {
        this.model.removeAntProjectListener((AntProjectListener)this);
        this.setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }

    protected Node[] createNodes(Object key) {
        VisualClassPathItem vcpItem = this.vcpItems.get((String)key);
        return new Node[]{new ModuleNode(vcpItem, this.model.getProjectDirectory())};
    }

    public void modelChanged(Object ev) {
        this.updateKeys();
    }

    public void configurationXmlChanged(AntProjectEvent ape) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                LogicalViewChildren.this.updateKeys();
            }
        });
    }

    public void propertiesChanged(AntProjectEvent ape) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                LogicalViewChildren.this.updateKeys();
            }
        });
    }
}

