/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.earproject.ui.customizer.VisualClasspathSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class LibrariesChooser
extends JPanel
implements HelpCtx.Provider {
    private final Collection incompatibleLibs;
    private JButton edit;
    private JLabel jLabel1;
    private JList jList1;
    private JScrollPane jScrollPane1;

    public LibrariesChooser(Collection alreadySelectedLibs, String j2eePlatform) {
        this.initComponents();
        this.jList1.setPrototypeCellValue("0123456789012345678901234");
        this.jList1.setModel(new LibrariesListModel());
        this.incompatibleLibs = Collections.EMPTY_LIST;
        this.jList1.setCellRenderer(new LibraryRenderer(alreadySelectedLibs, this.incompatibleLibs, j2eePlatform));
    }

    public Library[] getSelectedLibraries() {
        Object[] selected = this.jList1.getSelectedValues();
        ArrayList<Library> libs = new ArrayList<Library>();
        for (int i = 0; i < selected.length; ++i) {
            Library lib = (Library)selected[i];
            if (this.incompatibleLibs.contains(lib)) continue;
            libs.add(lib);
        }
        return libs.toArray(new Library[libs.size()]);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(LibrariesChooser.class);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.jList1.addListSelectionListener(listener);
    }

    public boolean isValidSelection() {
        Object[] selected = this.jList1.getSelectedValues();
        if (selected.length == 0) {
            return false;
        }
        for (int i = 0; i < selected.length; ++i) {
            if (!this.incompatibleLibs.contains(selected[i])) continue;
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.edit = new JButton();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(350, 250));
        this.getAccessibleContext().setAccessibleDescription(null);
        this.jLabel1.setLabelFor(this.jList1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(LibrariesChooser.class, (String)"CTL_Libraries"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jList1);
        this.jList1.getAccessibleContext().setAccessibleDescription(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.edit, (String)NbBundle.getMessage(LibrariesChooser.class, (String)"CTL_ManageLibraries"));
        this.edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LibrariesChooser.this.editLibraries(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.edit, gridBagConstraints);
        this.edit.getAccessibleContext().setAccessibleDescription(null);
    }

    private void editLibraries(ActionEvent evt) {
        LibrariesListModel model = (LibrariesListModel)this.jList1.getModel();
        List<Library> oldLibraries = Arrays.asList(model.getLibraries());
        LibrariesCustomizer.showCustomizer((Library)((Library)this.jList1.getSelectedValue()));
        List<Library> currentLibraries = Arrays.asList(model.getLibraries());
        ArrayList<Library> newLibraries = new ArrayList<Library>(currentLibraries);
        newLibraries.removeAll(oldLibraries);
        int[] indexes = new int[newLibraries.size()];
        int i = 0;
        for (Library lib : newLibraries) {
            indexes[i++] = currentLibraries.indexOf(lib);
        }
        this.jList1.setSelectedIndices(indexes);
    }

    private static final class LibraryRenderer
    extends DefaultListCellRenderer {
        private static final String LIBRARY_ICON = "org/netbeans/modules/j2ee/earproject/ui/resources/libraries.gif";
        private Icon cachedIcon;
        private final Collection alreadySelectedLibs;
        private final Collection incompatibleLibs;
        private final String j2eePlatform;

        public LibraryRenderer(Collection alreadySelectedLibs, Collection incompatibleLibs, String j2eePlatform) {
            this.alreadySelectedLibs = alreadySelectedLibs;
            this.j2eePlatform = j2eePlatform;
            this.incompatibleLibs = incompatibleLibs;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String toolTipText;
            String displayName = null;
            if (value instanceof Library) {
                displayName = ((Library)value).getDisplayName();
            }
            super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
            if (value instanceof Library) {
                String libraryString = VisualClasspathSupport.getLibraryString((Library)value);
                if (this.alreadySelectedLibs.contains(value)) {
                    toolTipText = NbBundle.getMessage(LibrariesChooser.class, (String)"LBL_LibraryAlreadyInProject_ToolTip") + " !!!     (" + libraryString + ")";
                } else if (this.incompatibleLibs.contains(value)) {
                    toolTipText = NbBundle.getMessage(LibrariesChooser.class, (String)"LBL_IncompatibleLibrary_ToolTip") + " (" + this.j2eePlatform + ") !!!     (" + libraryString + ")";
                    this.setEnabled(false);
                } else {
                    toolTipText = libraryString;
                }
            } else {
                toolTipText = null;
            }
            this.setToolTipText(toolTipText);
            this.setIcon(this.createIcon());
            return this;
        }

        private synchronized Icon createIcon() {
            if (this.cachedIcon == null) {
                Image img = Utilities.loadImage((String)LIBRARY_ICON);
                this.cachedIcon = new ImageIcon(img);
            }
            return this.cachedIcon;
        }
    }

    private static final class LibrariesListModel
    extends AbstractListModel
    implements PropertyChangeListener {
        private Library[] cache;
        private int numberOfLibs;

        public LibrariesListModel() {
            LibraryManager manager = LibraryManager.getDefault();
            manager.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)manager));
        }

        public synchronized int getSize() {
            if (this.cache == null) {
                this.cache = this.createLibraries();
            }
            return this.cache.length;
        }

        public synchronized Object getElementAt(int index) {
            if (this.cache == null) {
                this.cache = this.createLibraries();
            }
            if (index >= 0 && index < this.cache.length) {
                return this.cache[index];
            }
            return null;
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            int oldSize = this.cache == null ? 0 : this.numberOfLibs;
            this.cache = this.createLibraries();
            int newSize = this.numberOfLibs;
            this.fireContentsChanged(this, 0, Math.min(oldSize - 1, newSize - 1));
            if (oldSize > newSize) {
                this.fireIntervalRemoved(this, newSize, oldSize - 1);
            } else if (oldSize < newSize) {
                this.fireIntervalAdded(this, oldSize, newSize - 1);
            }
        }

        public synchronized Library[] getLibraries() {
            if (this.cache == null) {
                this.cache = this.createLibraries();
            }
            return this.cache;
        }

        private Library[] createLibraries() {
            Library[] libs = LibraryManager.getDefault().getLibraries();
            this.numberOfLibs = libs.length;
            Arrays.sort(libs, new Comparator<Library>(){

                @Override
                public int compare(Library l1, Library l2) {
                    String name1 = l1.getDisplayName();
                    String name2 = l2.getDisplayName();
                    return name1.compareToIgnoreCase(name2);
                }
            });
            return libs;
        }
    }
}

