/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.j2ee.earproject.ui.FoldersListSettings;
import org.netbeans.modules.j2ee.earproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.j2ee.earproject.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class PanelProjectLocationVisual
extends SettingsPanel
implements DocumentListener {
    private final PanelConfigureProject panel;
    private final String propNameIndex;
    private final ResourceBundle customBundle;
    private final boolean importStyle;
    private JButton browseFolderButton;
    private JButton browseLocationButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JPanel spaceFiller;
    public static final String PROP_PROJECT_NAME = "projectName";
    private String generatedProjectName = "";
    private int generatedProjectNameIndex = 0;

    public PanelProjectLocationVisual(PanelConfigureProject panel, String propNameIndex, ResourceBundle customBundle, boolean importStyle) {
        this.customBundle = customBundle;
        this.initComponents();
        this.panel = panel;
        this.propNameIndex = propNameIndex;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.importStyle = importStyle;
        this.createdFolderTextField.setEditable(importStyle);
        if (importStyle) {
            this.createdFolderTextField.getDocument().addDocumentListener(this);
        }
        this.browseFolderButton.setVisible(importStyle);
    }

    void addNameListener(DocumentListener listener) {
        this.projectNameTextField.getDocument().addDocumentListener(listener);
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseLocationButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.browseFolderButton = new JButton();
        this.spaceFiller = new JPanel();
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 5);
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_ProjectName_A11YDesc"));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.projectLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.projectLocationTextField, gridBagConstraints);
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NPW1_ProjectLocation_A11YDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseLocationButton, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.browseLocationButton.setActionCommand("BROWSE");
        this.browseLocationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelProjectLocationVisual.this.browseLocationAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 3, 5);
        this.add((Component)this.browseLocationButton, gridBagConstraints);
        this.browseLocationButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_BrowseLocation_A11YDesc"));
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.createdFolderLabel, gridBagConstraints);
        this.createdFolderTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.createdFolderTextField, gridBagConstraints);
        this.createdFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_CreatedProjectFolder_A11YDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseFolderButton, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.browseFolderButton.setActionCommand("BROWSE");
        this.browseFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelProjectLocationVisual.this.browseLocationAction2(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.browseFolderButton, gridBagConstraints);
        this.browseFolderButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACSD_LBL_NWP1_BrowseFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.spaceFiller, gridBagConstraints);
    }

    private void browseLocationAction2(ActionEvent evt) {
        String command = evt.getActionCommand();
        if ("BROWSE".equals(command)) {
            File f;
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(this.customBundle.getString("LBL_NWP1_SelectProjectLocation"));
            chooser.setFileSelectionMode(1);
            String path = this.getCreatedFolderText();
            if (path.length() > 0 && (f = new File(path)).exists()) {
                chooser.setSelectedFile(f);
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.createdFolderTextField.setText(projectDir.getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    private void browseLocationAction(ActionEvent evt) {
        String command = evt.getActionCommand();
        if ("BROWSE".equals(command)) {
            File f;
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(this.customBundle.getString("LBL_NWP1_SelectProjectLocation"));
            chooser.setFileSelectionMode(1);
            String path = this.projectLocationTextField.getText();
            if (path.length() > 0 && (f = new File(path)).exists()) {
                chooser.setSelectedFile(f);
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.projectLocationTextField.setText(projectDir.getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if ("\\".equals(this.getCreatedFolderText())) {
            return false;
        }
        if (!SettingsPanel.isValidProjectName(this.projectNameTextField.getText())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)this.customBundle.getString("MSG_IllegalProjectName"));
            return false;
        }
        String relativeDDPath = "src" + File.separator + "conf" + File.separator + "application.xml";
        if (this.importStyle) {
            File appXmlSrc = new File(this.projectLocationTextField.getText().trim() + File.separator + relativeDDPath);
            if (!appXmlSrc.exists()) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(this.customBundle.getString("MSG_Requires"), appXmlSrc.getAbsolutePath()));
                return false;
            }
            if (this.getCreatedFolderText().length() == 0) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)this.customBundle.getString("MSG_EmptyProjectFolder"));
                return false;
            }
        }
        File destParent = SettingsPanel.findExistingParent(this.getCreatedFolderText());
        File destDir = new File(this.getCreatedFolderText());
        if (destDir.exists() && !destDir.isDirectory()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(this.customBundle.getString("MSG_WillOverwrite"), destDir.getAbsolutePath()));
            return false;
        }
        File buildXml = new File(this.getCreatedFolderText() + File.separator + "build.xml");
        if (buildXml.exists()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(this.customBundle.getString("MSG_WillOverwrite"), buildXml.getAbsolutePath()));
            return false;
        }
        File tFile = new File(this.getCreatedFolderText() + File.separator + relativeDDPath);
        if (tFile.exists()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(this.customBundle.getString("MSG_WillOverwrite"), tFile.getAbsolutePath()));
            return false;
        }
        tFile = new File(this.getCreatedFolderText() + File.separator + "nbproject" + File.separator + "project.xml");
        if (tFile.exists()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(this.customBundle.getString("MSG_WillOverwrite"), tFile.getAbsolutePath()));
            return false;
        }
        tFile = new File(this.getCreatedFolderText() + File.separator + "nbproject" + File.separator + "project.properties");
        if (tFile.exists()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(this.customBundle.getString("MSG_WillOverwrite"), tFile.getAbsolutePath()));
            return false;
        }
        if (null != destParent && destParent.exists() && !destParent.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(this.customBundle.getString("MSG_ProjectLocationRO"), destParent.getAbsolutePath()));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    void store(WizardDescriptor d) {
        String name = this.projectNameTextField.getText().trim();
        String folder = this.getCreatedFolderText();
        d.putProperty("projdir", (Object)new File(folder));
        d.putProperty("name", (Object)name);
        Integer nameIndex = this.projectNameTextField.getText().equals(this.generatedProjectName) ? Integer.valueOf(this.generatedProjectNameIndex) : null;
        d.putProperty(this.propNameIndex, (Object)nameIndex);
    }

    void read(WizardDescriptor settings) {
        File projectLocation = (File)settings.getProperty("projdir");
        projectLocation = projectLocation == null || projectLocation.getParentFile() == null || !projectLocation.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : projectLocation.getParentFile();
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        String projectName = (String)settings.getProperty("name");
        if (projectName == null) {
            int baseCount = FoldersListSettings.getDefault().getNewProjectCount() + 1;
            String formater = this.customBundle.getString("LBL_NPW1_DefaultProjectName");
            while ((projectName = this.validFreeProjectName(projectLocation, formater, baseCount)) == null) {
                ++baseCount;
            }
            settings.putProperty(this.propNameIndex, (Object)baseCount);
        }
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
    }

    private String validFreeProjectName(File parentFolder, String formater, int index) {
        String name = MessageFormat.format(formater, index);
        File file = new File(parentFolder, name);
        return file.exists() ? null : name;
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.projectNameTextField.getDocument() || doc == this.projectLocationTextField.getDocument()) {
            String projectName = this.projectNameTextField.getText();
            if (doc == this.projectLocationTextField.getDocument()) {
                if (projectName.equals(this.generatedProjectName)) {
                    File f = new File(this.projectLocationTextField.getText().trim());
                    this.generatedProjectNameIndex = PanelProjectLocationVisual.getValidProjectNameIndex(this.generatedProjectNameIndex, f, this.customBundle);
                } else {
                    this.generatedProjectNameIndex = 0;
                }
                String string = this.generatedProjectName = this.generatedProjectNameIndex > 0 ? PanelProjectLocationVisual.getProjectName(this.generatedProjectNameIndex, this.customBundle) : null;
                if (this.generatedProjectNameIndex > 0) {
                    projectName = this.generatedProjectName;
                    this.projectNameTextField.setText(this.generatedProjectName);
                    this.projectNameTextField.selectAll();
                }
            }
            String projectFolder = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(projectFolder + File.separatorChar + projectName);
        }
        this.panel.fireChangeEvent();
    }

    static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getProjectName(int index, ResourceBundle rb) {
        return MessageFormat.format(rb.getString("LBL_NPW1_DefaultProjectName"), String.valueOf(index));
    }

    private static int getValidProjectNameIndex(int currentIndex, File projectLocation, ResourceBundle rb) {
        int index;
        int n = index = currentIndex > 0 ? currentIndex : FoldersListSettings.getDefault().getNewProjectCount() + 1;
        if (projectLocation != null) {
            while (new File(projectLocation, PanelProjectLocationVisual.getProjectName(index, rb)).exists()) {
                ++index;
            }
        }
        return index;
    }

    private String getCreatedFolderText() {
        return this.createdFolderTextField.getText().trim();
    }
}

