/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Element;

final class Subprojects
implements SubprojectProvider {
    private final FreeformProject project;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Subprojects(FreeformProject project) {
        this.project = project;
    }

    public Set getSubprojects() {
        return new LazySubprojectsSet();
    }

    private Set createSubprojects(Set subprojects) {
        Element config = this.project.helper().getPrimaryConfigurationData(true);
        Element subprjsEl = Util.findElement(config, "subprojects", "http://www.netbeans.org/ns/freeform-project/1");
        if (subprjsEl != null) {
            List kids = Util.findSubElements(subprjsEl);
            Iterator it = kids.iterator();
            while (it.hasNext()) {
                FileObject subprjDir;
                Element prjEl = (Element)it.next();
                if (!$assertionsDisabled && !prjEl.getLocalName().equals("project")) {
                    throw new AssertionError((Object)("Bad element " + prjEl + " in <subprojects> for " + this.project));
                }
                String rawtext = Util.findText(prjEl);
                if (!$assertionsDisabled && rawtext == null) {
                    throw new AssertionError((Object)("Need text content for <project> in " + this.project));
                }
                String evaltext = this.project.evaluator().evaluate(rawtext);
                if (evaltext == null || (subprjDir = this.project.helper().resolveFileObject(evaltext)) == null) continue;
                try {
                    Project p = ProjectManager.getDefault().findProject(subprjDir);
                    if (p == null) continue;
                    if (subprojects == null) {
                        return Collections.EMPTY_SET;
                    }
                    subprojects.add(p);
                }
                catch (IOException e) {
                    org.netbeans.modules.ant.freeform.Util.err.notify(1, (Throwable)e);
                }
            }
        }
        return subprojects;
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }

    static {
        $assertionsDisabled = !Subprojects.class.desiredAssertionStatus();
    }

    private final class LazySubprojectsSet
    implements Set {
        private Set delegateTo = null;

        private LazySubprojectsSet() {
        }

        private synchronized Set getDelegateTo() {
            if (this.delegateTo == null) {
                this.delegateTo = Subprojects.this.createSubprojects(new HashSet());
            }
            return this.delegateTo;
        }

        public boolean contains(Object o) {
            return this.getDelegateTo().contains(o);
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection c) {
            return this.getDelegateTo().containsAll(c);
        }

        public Object[] toArray(Object[] a) {
            return this.getDelegateTo().toArray(a);
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.getDelegateTo().size();
        }

        public synchronized boolean isEmpty() {
            if (this.delegateTo == null) {
                return Subprojects.this.createSubprojects(null) == null;
            }
            return this.delegateTo.isEmpty();
        }

        public Iterator iterator() {
            return this.getDelegateTo().iterator();
        }

        public Object[] toArray() {
            return this.getDelegateTo().toArray();
        }
    }
}

