/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;

public class JPDAStepImpl
extends JPDAStep
implements Executor {
    private Session session;

    public JPDAStepImpl(JPDADebugger debugger, Session session, int size, int depth) {
        super(debugger, size, depth);
        this.session = session;
    }

    public void addStep(JPDAThread tr) {
        JPDADebuggerImpl debuggerImpl = (JPDADebuggerImpl)this.debugger;
        JPDAThreadImpl trImpl = (JPDAThreadImpl)tr;
        EventRequestManager erm = debuggerImpl.getVirtualMachine().eventRequestManager();
        erm.deleteEventRequests(erm.stepRequests());
        StepRequest stepRequest = debuggerImpl.getVirtualMachine().eventRequestManager().createStepRequest(trImpl.getThreadReference(), this.getSize(), this.getDepth());
        stepRequest.addCountFilter(1);
        debuggerImpl.getOperator().register(stepRequest, this);
        stepRequest.setSuspendPolicy(2);
        stepRequest.enable();
    }

    public boolean exec(Event event) {
        JPDADebuggerImpl debuggerImpl = (JPDADebuggerImpl)this.debugger;
        JPDAThreadImpl trImpl = (JPDAThreadImpl)debuggerImpl.getCurrentThread();
        EventRequestManager erm = debuggerImpl.getVirtualMachine().eventRequestManager();
        erm.deleteEventRequest(event.request());
        this.firePropertyChange("exec", null, null);
        if (!this.getHidden()) {
            DebuggerManager.getDebuggerManager().setCurrentSession(this.session);
            debuggerImpl.setStoppedState(trImpl.getThreadReference());
        }
        return this.getHidden();
    }
}

