/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;

public class FieldBreakpointImpl
extends ClassBasedBreakpoint {
    private FieldBreakpoint breakpoint;

    public FieldBreakpointImpl(FieldBreakpoint breakpoint, JPDADebuggerImpl debugger, Session session) {
        super((JPDABreakpoint)breakpoint, debugger, session);
        this.breakpoint = breakpoint;
        this.set();
    }

    protected void setRequests() {
        this.setClassRequests(new String[]{this.breakpoint.getClassName()}, new String[0], 1);
        this.checkLoadedClasses(this.breakpoint.getClassName(), true);
    }

    protected void classLoaded(ReferenceType referenceType) {
        Field f = referenceType.fieldByName(this.breakpoint.getFieldName());
        try {
            if ((this.breakpoint.getBreakpointType() & 1) != 0) {
                AccessWatchpointRequest awr = this.getEventRequestManager().createAccessWatchpointRequest(f);
                this.addEventRequest(awr);
            }
            if ((this.breakpoint.getBreakpointType() & 2) != 0) {
                ModificationWatchpointRequest mwr = this.getEventRequestManager().createModificationWatchpointRequest(f);
                this.addEventRequest(mwr);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public boolean exec(Event event) {
        if (event instanceof ModificationWatchpointEvent) {
            return this.perform(this.breakpoint.getCondition(), ((WatchpointEvent)event).thread(), ((LocatableEvent)event).location().declaringType(), ((ModificationWatchpointEvent)event).valueToBe());
        }
        if (event instanceof AccessWatchpointEvent) {
            return this.perform(this.breakpoint.getCondition(), ((WatchpointEvent)event).thread(), ((LocatableEvent)event).location().declaringType(), ((AccessWatchpointEvent)event).valueCurrent());
        }
        return super.exec(event);
    }
}

